/**
 * Created by rockyl on 2019-12-16.
 */

const customId = 'jump-high-2';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	engine.globalEvent.addEventListener('update-game-status', (e) => {
		console.log(e.type, e.data);
	});

	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const {props: propsOption, assets} = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
		}],
	}, null, function () {
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);

		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jump-high-start', {level: 1});
		}, 500);
	});
}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
