

import { props } from './../props';


/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";

export class GameWrapper extends engine.Container {
	private _gameView: GameView;

	constructor() {
		super();

		engine.globalEvent.addEventListener('jiugong-turntable-init', this.init, this);

		engine.globalEvent.addEventListener('jiugong-turntable-start', this.start, this);

		engine.globalEvent.addEventListener('jiugong-turntable-winPrize', this.winPrize, this);
		engine.globalEvent.addEventListener('jiugong-turntable-reset', this.reset, this);
		engine.globalEvent.addEventListener('jiugong-turntable-abnormal', this.reset, this);
	}

	init(event: engine.Event) {
		//初始化场景
		let gameView = this._gameView = new GameView();
		this.addChild(gameView);
		console.log('奖品图',event.data.resources); 
		this._gameView.setup(event.data.resources);
	}

	//开始抽奖
	start(event: engine.Event){
		this._gameView.startDraw();
	}
	winPrize(event: engine.Event){
		this._gameView.setRecordID(event.data.prizeID)
	}
	reset(){
		this._gameView.reset();
	}
	// private visibilitychange(){
	// 	document.addEventListener('visibilitychange', function () {
    //         if (document.visibilityState === 'hidden') {
	// 			console.log('放置后台');
	// 			engine.globalEvent.dispatchEvent('answer-game-visibilitychange',{hidden:true});
    //         }
    //     });
	// }
}
