(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['jiugong-turntable'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	//# sourceMappingURL=utils.js.map

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var Turntable = (function (_super) {
	    tslib.__extends(Turntable, _super);
	    function Turntable(res) {
	        var _this = _super.call(this) || this;
	        _this._vertical_Y = props.vertical || 20;
	        _this._horizontal_X = props.horizontal || 20;
	        _this._prizeIndex = 0;
	        _this._boxArray = [];
	        _this._boxIndex = 0;
	        _this.tweenTime = props.tweenTime || 200;
	        _this.slowTweenTime = props.slowTweenTime || 200;
	        _this.circleNumber = 0;
	        _this.turntableOrder = [1, 2, 3, 5, 8, 7, 6, 4];
	        _this.recordID = -1;
	        _this.boxPrizeIndex = -1;
	        _this.slowDown = false;
	        _this.isStop = false;
	        _this.initTurntable(res);
	        _this.setNodeOrder();
	        return _this;
	    }
	    Turntable.prototype.initTurntable = function (res) {
	        var turnTableNode = this._turnTableNode = new engine.Container();
	        this.addChild(turnTableNode);
	        for (var index_Y = 0; index_Y < 3; index_Y++) {
	            for (var index_X = 0; index_X < 3; index_X++) {
	                if (index_X == 1 && index_Y == 1)
	                    continue;
	                var tmpNode = new engine.Container();
	                var unchecked = this.getImage('unchecked', 1);
	                var checked = this.getImage('checked', 0);
	                tmpNode.width = Math.max(unchecked.width, checked.width);
	                this._singleNodeWidth = this._singleNodeWidth ? this._singleNodeWidth : tmpNode.width;
	                tmpNode.height = Math.max(unchecked.height, checked.height);
	                tmpNode.x = index_X * (tmpNode.width + this._horizontal_X);
	                tmpNode.y = index_Y * (tmpNode.height + this._vertical_Y);
	                checked.x = (tmpNode.width - checked.width) / 2;
	                checked.y = (tmpNode.height - checked.height) / 2;
	                unchecked.x = (tmpNode.width - unchecked.width) / 2;
	                unchecked.y = (tmpNode.height - unchecked.height) / 2;
	                if (props.layer) {
	                    tmpNode.addChild(checked);
	                    tmpNode.addChild(unchecked);
	                }
	                else {
	                    tmpNode.addChild(unchecked);
	                    tmpNode.addChild(checked);
	                }
	                turnTableNode.addChild(tmpNode);
	                var prize = new engine.Sprite(engine.Texture.fromImage(res[this._prizeIndex].img));
	                var prizeID = res[this._prizeIndex].id;
	                prize.width = props.icon_width;
	                prize.height = props.icon_height;
	                prize.x = (tmpNode.width - prize.width) / 2 + props.icon_X;
	                prize.y = (tmpNode.height - prize.height) / 2 + props.icon_Y;
	                tmpNode.prizeID = prizeID;
	                tmpNode.addChild(prize);
	                this._prizeIndex++;
	                this._boxArray.push(tmpNode);
	            }
	        }
	        turnTableNode.x = (750 - (this._singleNodeWidth * 3 + this._horizontal_X * 2)) / 2;
	    };
	    Turntable.prototype.setNodeOrder = function () {
	        var tmpNodeArray = [];
	        for (var index = 0; index < this.turntableOrder.length; index++) {
	            var order = this.turntableOrder[index];
	            tmpNodeArray.push(this._boxArray[order - 1]);
	        }
	        this._boxArray = tmpNodeArray;
	    };
	    Turntable.prototype.getImage = function (resName, alpha) {
	        var tmpImage = new engine.Sprite(getTextureByName(resName));
	        tmpImage.x = 0;
	        tmpImage.y = 0;
	        tmpImage.alpha = alpha;
	        tmpImage.name = resName;
	        return tmpImage;
	    };
	    Turntable.prototype.startDraw = function () {
	        var _this = this;
	        var tmpCheckNode = this._boxArray[this._boxIndex].getChildByName('checked');
	        if (this.isStop) {
	            engine.Tween.removeTweens(tmpCheckNode);
	            return;
	        }
	        if (this.slowDown) {
	            if (this._boxIndex != this.getNodeIndexOFprize()) {
	                this.tweenTime += this.slowTweenTime;
	            }
	            else {
	                this.isStop = true;
	                this.twinkle(tmpCheckNode);
	            }
	        }
	        engine.Tween.get(tmpCheckNode)
	            .to({ alpha: 1 }, this.tweenTime / 2)
	            .to({ alpha: 0 }, this.tweenTime / 2)
	            .call(function () {
	            if (_this.circleNumber >= props.circleNumber && _this.getSlowStart() == _this._boxIndex) {
	                _this.slowDown = true;
	            }
	            _this._boxIndex++;
	            if (_this._boxIndex >= _this._boxArray.length) {
	                _this._boxIndex = 0;
	                _this.circleNumber++;
	            }
	            _this.startDraw();
	        });
	    };
	    Turntable.prototype.getSlowStart = function () {
	        if (this.recordID < 0)
	            return -1;
	        var tmpIndex = this.getNodeIndexOFprize();
	        if (tmpIndex < 4) {
	            return tmpIndex + 4;
	        }
	        else {
	            return tmpIndex - 4;
	        }
	    };
	    Turntable.prototype.getNodeIndexOFprize = function () {
	        if (this.recordID < 0)
	            return -1;
	        for (var index = 0; index < this._boxArray.length; index++) {
	            var element = this._boxArray[index];
	            if (element.prizeID === this.recordID) {
	                return index;
	            }
	        }
	        return -1;
	    };
	    Turntable.prototype.twinkle = function (tmpNode) {
	        engine.Tween.removeTweens(tmpNode);
	        var twinkleTime = 1;
	        engine.Tween.get(tmpNode, { loop: true })
	            .to({ alpha: 0 }, 30)
	            .to({ alpha: 1 }, 30)
	            .call(function () {
	            if (twinkleTime > 5) {
	                engine.Tween.removeTweens(tmpNode);
	                engine.globalEvent.dispatchEvent('jiugong-turntable-over');
	                return;
	            }
	            else {
	                twinkleTime++;
	            }
	        });
	    };
	    Turntable.prototype.setRecordID = function (prizeID) {
	        this.recordID = prizeID;
	    };
	    Turntable.prototype.reset = function () {
	        engine.Tween.removeAllTweens();
	        this._boxIndex = 0;
	        this.tweenTime = props.tweenTime || 200;
	        this.slowTweenTime = props.slowTweenTime || 200;
	        this.circleNumber = 0;
	        this.recordID = -1;
	        this.boxPrizeIndex = -1;
	        this.slowDown = false;
	        this.isStop = false;
	        for (var index = 0; index < this._boxArray.length; index++) {
	            var element = this._boxArray[index];
	            element.getChildByName('checked').alpha = 0;
	        }
	    };
	    return Turntable;
	}(engine.Container));

	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        return _super.call(this) || this;
	    }
	    GameView.prototype.setup = function (res) {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        var turntable = this._turntable = new Turntable(res);
	        this.addChild(turntable);
	    };
	    GameView.prototype.startDraw = function () {
	        this._turntable.startDraw();
	    };
	    GameView.prototype.setRecordID = function (prizeID) {
	        this._turntable.setRecordID(prizeID);
	    };
	    GameView.prototype.reset = function () {
	        this._turntable.reset();
	    };
	    return GameView;
	}(engine.Container));
	//# sourceMappingURL=GameView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('jiugong-turntable-init', _this.init, _this);
	        engine.globalEvent.addEventListener('jiugong-turntable-start', _this.start, _this);
	        engine.globalEvent.addEventListener('jiugong-turntable-winPrize', _this.winPrize, _this);
	        engine.globalEvent.addEventListener('jiugong-turntable-reset', _this.reset, _this);
	        engine.globalEvent.addEventListener('jiugong-turntable-abnormal', _this.reset, _this);
	        return _this;
	    }
	    GameWrapper.prototype.init = function (event) {
	        var gameView = this._gameView = new GameView();
	        this.addChild(gameView);
	        console.log('奖品图', event.data.resources);
	        this._gameView.setup(event.data.resources);
	    };
	    GameWrapper.prototype.start = function (event) {
	        this._gameView.startDraw();
	    };
	    GameWrapper.prototype.winPrize = function (event) {
	        this._gameView.setRecordID(event.data.prizeID);
	    };
	    GameWrapper.prototype.reset = function () {
	        this._gameView.reset();
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map