/**
 * Created by rockyl on 2019-12-16.
 */

const customId = 'jiugong-turntable';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const {props: propsOption, assets} = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
			properties: {
				x: 0,
				y: 0,
			}
		}],
	}, null, function () {
		
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);
		let pram = [
			{
				id:1,
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:2,
				img:'//yun.dui88.com/images/201907/xsit2cvmyl.jpeg'
			},
			{
				id:3,
				img:'//yun.dui88.com/projectxh5/phonebill-250-250.png'
			},
			{
				id:4,
				img:'//yun.dui88.com/images/201907/xsit2cvmyl.jpeg'
			},
			{
				id:5,
				img:'//yun.dui88.com/projectxh5/alipay-250-250.png'
			},
			{
				id:6,
				img:'//yun.dui88.com/projectxh5/phonebill-250-250.png'
			},
			{
				id:7,
				img:'//yun.dui88.com/images/201907/xsit2cvmyl.jpeg'
			},
			{
				id:8,
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			}
		]
		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jiugong-turntable-init',{resources:pram})
		}, 2000);

		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jiugong-turntable-start')
		}, 4000);

		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jiugong-turntable-winPrize',{prizeID:4})
		}, 6000);

	});
}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
