
import {getTextureByName} from "./utils";
import {getStage} from "./utils";

import { props } from '../props';

export class Turntable extends engine.Container{
    private _turnTableNode:engine.Container;
    private _vertical_Y = props.vertical || 20;//纵向间距
    private _horizontal_X = props.horizontal || 20;//横向间距
    private _prizeIndex = 0;

    private _boxArray = [];
    private _boxIndex = 0;//当前下标

    private tweenTime = props.tweenTime || 200;//单个动画时间（毫秒）
    private slowTweenTime = props.slowTweenTime || 200;
    private circleNumber = 0;//圈数

    private turntableOrder = [1,2,3,5,8,7,6,4]; 
    private recordID = -1;//中奖奖品ID
    private boxPrizeIndex = -1;//中奖奖品节点下标 
    private slowDown = false;//是否开始缓速
    private isStop = false;

    private _singleNodeWidth;//单个节点宽度
    constructor(){
        super()
        
    }
    public initData(res){
        this.initTurntable(res);
        this.setNodeOrder();
    }
    initTurntable(res){
        let turnTableNode = null;
        if(this._turnTableNode){
            this.removeChild(this._turnTableNode);
            this._turnTableNode = null;
            this._boxArray = [];
            this._prizeIndex = 0;
            this._boxIndex = 0;
        }
        turnTableNode = this._turnTableNode = new engine.Container();
        //turnTableNode.y = 50;
        this.addChild(turnTableNode);
        for (let index_Y = 0; index_Y < 3; index_Y++) {
            for (let index_X = 0; index_X < 3; index_X++) {  
                if(index_X == 1 && index_Y == 1)continue;
                let tmpNode:any = new engine.Container()

                let unchecked = this.getImage('unchecked',1);
                let checked = this.getImage('checked',0);

                tmpNode.width = Math.max(unchecked.width,checked.width);
                this._singleNodeWidth = this._singleNodeWidth ? this._singleNodeWidth : tmpNode.width;
                tmpNode.height = Math.max(unchecked.height,checked.height);
                tmpNode.x = index_X*(tmpNode.width + this._horizontal_X);
                tmpNode.y = index_Y*(tmpNode.height + this._vertical_Y);
                tmpNode.addChild(unchecked);
                tmpNode.addChild(checked);
                
                let prize =new engine.Sprite(engine.Texture.fromImage(res[this._prizeIndex].img)) ;
                let prizeID = res[this._prizeIndex].id;
                prize.width = props.icon_width;
                prize.height = props.icon_height;
                prize.x = (tmpNode.width - prize.width)/2 + props.icon_X;
                prize.y = (tmpNode.height - prize.height)/2 + props.icon_Y;
                tmpNode.prizeID = prizeID;
                tmpNode.addChild(prize);
            
                let titleLabel = new engine.Label();
                titleLabel.fillColor = props.prizeName_color;
                titleLabel.size = props.prizeName_size;
                titleLabel.width = unchecked.width;
                titleLabel.textAlign = engine.TEXT_ALIGN.CENTER;
                titleLabel.x = 0;
                titleLabel.y = props.prizeName_Ypos;
    
                titleLabel.text = this.fixTitle(res[this._prizeIndex].name);
                tmpNode.addChild(titleLabel)
                
                this._prizeIndex ++ ;
                this._boxArray.push(tmpNode);     
                turnTableNode.addChild(tmpNode); 
            }
        }
        turnTableNode.x = (750 - (this._singleNodeWidth*3 + this._horizontal_X*2))/2;
    }

    setNodeOrder(){
        let tmpNodeArray = [];
        for (let index = 0; index < this.turntableOrder.length; index++) {
            let order = this.turntableOrder[index];
            tmpNodeArray.push(this._boxArray[order-1]);
        }
        this._boxArray = tmpNodeArray;
    }

    fixTitle(name){
        if(!name){
            return ""
        }
        if(name.split("").length<props.prizeName_maxLength){
            return name
        }
        let n = ""
        for(let i=0;i<props.prizeName_retainLength;i++){
            n += name.split("")[i]
        }
        n+="..."
        return n
    }

    getImage(resName,alpha){
        let tmpImage = new engine.Sprite(getTextureByName(resName));
        tmpImage.x = 0
        tmpImage.y = 0
        tmpImage.alpha = alpha;
        tmpImage.name = resName;
        return tmpImage;
    }
    startDraw(){
        let tmpCheckNode = this._boxArray[this._boxIndex].getChildByName('checked');
        if(this.isStop){engine.Tween.removeTweens(tmpCheckNode);return}
        if(this.slowDown)
        {
            if(this._boxIndex != this.getNodeIndexOFprize()){
                this.tweenTime += this.slowTweenTime;
            }else{
                this.isStop = true;
                this.twinkle(tmpCheckNode);
            }
        }
        engine.Tween.get(tmpCheckNode)
        .to({alpha:1},this.tweenTime/2)
        .to({alpha:0},this.tweenTime/2)
        .call(()=>{
            if(this.circleNumber >= props.circleNumber && this.getSlowStart() == this._boxIndex){
                this.slowDown = true;
            }
            this._boxIndex ++;
            if(this._boxIndex >= this._boxArray.length){
                this._boxIndex = 0;
                this.circleNumber++;
            }
            
            this.startDraw();
    
            
        })
    }
    //获取开始减速的下标
    private getSlowStart(){
        if(this.recordID < 0)return -1;
        let tmpIndex = this.getNodeIndexOFprize();
        if(tmpIndex < 4){
            return tmpIndex + 4;
        }else{
            return tmpIndex - 4
        }
    }
    //获取奖品节点下标
    getNodeIndexOFprize(){
        if(this.recordID < 0)return -1;
        for (let index = 0; index < this._boxArray.length; index++) {
            let element = this._boxArray[index];
            if(element.prizeID === this.recordID){
                return index;
            } 
        }
        return -1;
    }
    //中奖节点闪烁
    twinkle(tmpNode){
        engine.Tween.removeTweens(tmpNode)
        let twinkleTime = 1;
        engine.Tween.get(tmpNode, {loop:true})
        .to({alpha:0}, 30)
        .to({alpha:1}, 30)
        .call(()=>{
            if(twinkleTime > 5){
                engine.Tween.removeTweens(tmpNode);
                engine.globalEvent.dispatchEvent('jiugong-turntable-change-over')
                return;
            }else{
                twinkleTime++;
            }
        })
    }
    setRecordID(prizeID){
        this.recordID = prizeID;
    }
    reset(){
        this._boxArray.forEach(element => {
            engine.Tween.removeTweens(element.getChildByName('checked'));
        });
        this._boxIndex = 0;//当前下标
        this.tweenTime = props.tweenTime || 200;//单个动画时间（毫秒）
        this.slowTweenTime = props.slowTweenTime || 200;
        this.circleNumber = 0;//圈数
        this.recordID = -1;//中奖奖品ID
        this.boxPrizeIndex = -1;//中奖奖品节点下标 
        this.slowDown = false;//是否开始缓速
        this.isStop = false;
        for (let index = 0; index < this._boxArray.length; index++) {
            let element = this._boxArray[index];
            element.getChildByName('checked').alpha = 0;
        }
        
    }

}