

import { props } from '../props';


/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";

export class GameWrapper extends engine.Container {
	private _gameView: GameView;

	constructor() {
		super();

		engine.globalEvent.addEventListener('jiugong-turntable-change-init', this.init, this);
		engine.globalEvent.addEventListener('jiugong-turntable-change-prizeData', this.initPrizeData, this);

		engine.globalEvent.addEventListener('jiugong-turntable-change-start', this.start, this);

		engine.globalEvent.addEventListener('jiugong-turntable-change-winPrize', this.winPrize, this);
		engine.globalEvent.addEventListener('jiugong-turntable-change-reset', this.reset, this);
		engine.globalEvent.addEventListener('jiugong-turntable-change-abnormal', this.reset, this);
	}

	init(event: engine.Event) {
		//初始化场景
		let gameView = this._gameView = new GameView();
		this.addChild(gameView);
		this._gameView.setup();
	}
	initPrizeData(event: engine.Event){
		this._gameView.setSetup();
		this._gameView.setPrizeData(event.data.resources);
	}

	//开始抽奖
	start(event: engine.Event){
		this._gameView.startDraw();
	}
	winPrize(event: engine.Event){
		this._gameView.setRecordID(event.data.prizeID)
	}
	reset(){
		this._gameView.reset();
	}
	// private visibilitychange(){
	// 	document.addEventListener('visibilitychange', function () {
    //         if (document.visibilityState === 'hidden') {
	// 			console.log('放置后台');
	// 			engine.globalEvent.dispatchEvent('answer-game-visibilitychange',{hidden:true});
    //         }
    //     });
	// }
}
