/**
 * Created by rockyl on 2019-12-16.
 */

const customId = 'jiugong-turntable-change';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const {props: propsOption, assets} = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
			properties: {
				x: 0,
				y: 0,
			}
		}],
	}, null, function () {
		
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);
		let pram = [
			{
				id:1,
				name:'奖品1奖品1',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:2,
				name:'奖品2奖品2奖品2',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:3,
				name:'奖品333333',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:4,
				name:'奖品4545545454',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:5,
				name:'奖奖品5奖品5奖品5品5',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:6,
				name:'奖品6',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:7,
				name:'奖品7',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:8,
				name:'奖品奖品5奖品5奖品58',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			}
		]
		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jiugong-turntable-change-init')
		}, 1000);
		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jiugong-turntable-change-prizeData',{resources:pram})
		}, 1500);

		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jiugong-turntable-change-start')
		}, 4000);
		let pram1 = [
			{
				id:1,
				name:'奖品1',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:2,
				name:'奖品2',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:3,
				name:'奖品3',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:4,
				name:'奖品4',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:5,
				name:'奖品5',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:6,
				name:'奖品6',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:7,
				name:'奖品7',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			},
			{
				id:8,
				name:'奖品8',
				img:'//yun.dui88.com/images/201907/ui83og75fr.png'
			}
		]
		setTimeout(() => {
			engine.globalEvent.dispatchEvent('jiugong-turntable-change-winPrize',{prizeID:4})
		}, 6000);

		// setTimeout(() => {
		// 	engine.globalEvent.dispatchEvent('jiugong-turntable-change-prizeData',{resources:pram1})
		// }, 10000);


	});
}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
