
import { getTextureByName, createSvga } from './utils';
import { props } from "../props";

export default class Gameinit extends engine.Container {

    private _isSetUp = false;
    _body: engine.Rect;
    constructor() {
        super();
        this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }
    /**首页加载 */
    setup() {
        console.log("初始化加载000000000000000000000000！");
        if (this._isSetUp) {
            return;
        }
        else {
            this.loadThings();
            console.log("this._isSetUp=", this._isSetUp, '<<<<');
        }
    }
    /**套圈资源加载 */
    loadThings() {
        let self = this;
        let body;
        body = this._body = new engine.Rect;
        body.width = 0.0001;
        body.width = 0.0001;
        this.addChild(body);
        let bubble = createSvga("打气球");
        body.addChild(bubble);
        let [v2X, v2Y] = props.hitbubbleModuleGlobalPosition;
        body.x = v2X;
        body.y = v2Y;
        console.log(">>>>>>", bubble.width, bubble.height, "<<<<<<", "》》》》", body.width, body.height, '《《《《');
        // self.aniPlay(bubble, 0, 0);
        engine.globalEvent.addEventListener("hit-bubble-game-start", function () {
            self.aniPlay(bubble, 0, 0);
        }, this);
        engine.globalEvent.addEventListener("hit-bubble-game-init", function () {
            bubble.addEventListener(engine.Event.END_FRAME, function () {
                console.log(1000000000000);
                bubble.gotoAndStop(1);
            })
        }, this);
    }
    /**动画播放 */
    aniPlay(node0, vX, vY) {
        console.log("播放动画！！！");
        node0.x = vX;
        node0.y = vY;
        node0.play(false, false);
        node0.addEventListener(engine.Event.END_FRAME, function () {
            console.log("最后一帧");
            engine.globalEvent.dispatchEvent("hit-bubble-game-end");
        })
        /**动画播放完毕，派发（执行）一个事件 */
    }
    /**给场景添加图片,resName:资源名字，v2X：资源X位置, v2Y：资源Y位置, resW：资源Width, resH:资源Height */
    addRes(fatherNode, resName, v2X, v2Y, resW, resH) {
        console.log("进行资源的添加");
        let thing = new engine.Sprite(getTextureByName(resName));
        thing.x = v2X;
        thing.y = v2Y;
        thing.width = resW;
        thing.height = resH;
        return fatherNode.addChild(thing);
    }
}
