(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['hit-bubble'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}
	//# sourceMappingURL=utils.js.map

	var Gameinit = (function (_super) {
	    tslib.__extends(Gameinit, _super);
	    function Gameinit() {
	        var _this = _super.call(this) || this;
	        _this._isSetUp = false;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    Gameinit.prototype.setup = function () {
	        console.log("初始化加载000000000000000000000000！");
	        if (this._isSetUp) {
	            return;
	        }
	        else {
	            this.loadThings();
	            console.log("this._isSetUp=", this._isSetUp, '<<<<');
	        }
	    };
	    Gameinit.prototype.loadThings = function () {
	        var self = this;
	        var body;
	        body = this._body = new engine.Rect;
	        body.width = 0.0001;
	        body.width = 0.0001;
	        this.addChild(body);
	        var bubble = createSvga("打气球");
	        body.addChild(bubble);
	        var _a = props.hitbubbleModuleGlobalPosition, v2X = _a[0], v2Y = _a[1];
	        body.x = v2X;
	        body.y = v2Y;
	        console.log(">>>>>>", bubble.width, bubble.height, "<<<<<<", "》》》》", body.width, body.height, '《《《《');
	        engine.globalEvent.addEventListener("hit-bubble-game-start", function () {
	            self.aniPlay(bubble, 0, 0);
	        }, this);
	        engine.globalEvent.addEventListener("hit-bubble-game-init", function () {
	            bubble.addEventListener(engine.Event.END_FRAME, function () {
	                console.log(1000000000000);
	                bubble.gotoAndStop(1);
	            });
	        }, this);
	    };
	    Gameinit.prototype.aniPlay = function (node0, vX, vY) {
	        console.log("播放动画！！！");
	        node0.x = vX;
	        node0.y = vY;
	        node0.play(false, false);
	        node0.addEventListener(engine.Event.END_FRAME, function () {
	            console.log("最后一帧");
	            engine.globalEvent.dispatchEvent("hit-bubble-game-end");
	        });
	    };
	    Gameinit.prototype.addRes = function (fatherNode, resName, v2X, v2Y, resW, resH) {
	        console.log("进行资源的添加");
	        var thing = new engine.Sprite(getTextureByName(resName));
	        thing.x = v2X;
	        thing.y = v2Y;
	        thing.width = resW;
	        thing.height = resH;
	        return fatherNode.addChild(thing);
	    };
	    return Gameinit;
	}(engine.Container));
	//# sourceMappingURL=Gameinit.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new Gameinit();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map