import {getTexture} from './utils'

export default class Moist extends engine.Container{

    percent:number
    moistBg:engine.Sprite = new engine.Sprite(getTexture('8a8e79b6-2c6f-441b-81ae-c441465abfb0'))
    moist:engine.Sprite = new engine.Sprite(getTexture('024d67e9-ed7f-4481-94ca-a15bd5226cad'))
    moistCover:any = new engine.Sprite(getTexture('024d67e9-ed7f-4481-94ca-a15bd5226cad'))
    txt = new engine.TextInput();
    hintpic:engine.Sprite = new engine.Sprite(getTexture('ed0e8931-2557-4527-bcfc-9071f90d5737'))

    addPercent:number
    constructor(){
        super();
        this.percent = 0;
        this.addChild(this.moistBg)
        this.moistBg.addChild(this.moist)
        this.moist.mask = this.moistCover;


        this.txt.text = this.percent*100+'%';
        this.txt.size = 30;
        this.txt.fillColor = '#7A83C5';
        this.addChild(this.txt)
        this.txt.x = 0;
        this.txt.y = -50;

        this.hintpic.x = -10;
        this.hintpic.y = 440;
        this.addChild(this.hintpic)
    }

    cover(percent){
        this.moistCover.anchorY = 416;
        this.moistBg.addChild(this.moistCover)
        this.moistCover.scaleY = percent;
        let ld = Date.now();
        // let time
        // this.addEventListener(engine.Event.ENTER_FRAME,()=>{
        //     let dt = Date.now() - ld;
        //     time += dt;
        //     if(time >= 100){
        //         // this.moistCover.scaleY =
        //     }
        // })
        let t = engine.Tween.get(this.moistCover);
        // t.set({alpha:1,scaleY:this.percent})
        //     .to({alpha:1,scaleY:percent - 0.08},100)
        //     .to({alpha:1,scaleY:percent - 0.06},100)
        //     .to({alpha:1,scaleY:percent - 0.04},100)
        //     .to({alpha:1,scaleY:percent - 0.02},100)
        //     .to({alpha:1,scaleY:percent},100)

    }

    stopScale(){
        this.moistCover.scaleY = 1;
        this.txt.text = '100%';
    }

    updateText(percent){
        let a = percent * 100;
        if(a <=90){
            this.txt.text = a.toPrecision(2)+'%';
        }else{
            this.txt.text = a.toPrecision(3)+'%';
        }
    }

    updatePercent(percent){
        this.percent = percent;
    }
}