import {getTexture} from './utils'

export default class Human extends engine.Container{
    
    //常态,吃力,沮丧
    humanArray = [
        '487c1ca7-dea5-4732-b4b6-acb5406ee3a4',
        '71e07cee-fd6d-40bb-ac0b-5bb28c87276e',
        '2cd9f1bb-d0d8-42ea-941b-dcd0428e474d'
    ]
    //三张面部表情
    human:engine.Sprite = new engine.Sprite(getTexture(this.humanArray[0]))

    constructor(){
        super();
        this.addChild(this.human)
        this.width = this.human.width;
        this.height = this.human.height;
    }

    facialChange(num){
        let face = new engine.Sprite(getTexture(this.humanArray[num]));
        this.human.addChild(face);
        return face;
    }

    removeFace(face){
        this.human.removeChild(face);
    }

    scaleEffect(){
        let aaa = 0;
        let pt = Date.now();
        this.addEventListener(engine.Event.ENTER_FRAME,()=>{
            let dt = Date.now() -pt;
            aaa += dt;
            this.anchorX = this.width + this.width / 2
            this.anchorY = this.height;
            if(aaa > 90 && aaa<=100 ){
                this.scaleY = 0.99;
                this.scaleX = 1.01;
            }

            if(aaa >190 && aaa < 200){
                this.scaleX = 1;
                this.scaleY = 1;
                aaa = 0;
            }

            pt = Date.now();
        })
    }
}