import {getTexture} from './utils'

export default class CloudRain extends engine.Container{

    clound1:engine.Sprite = new engine.Sprite(getTexture('1e1a6993-9da0-4813-b1bd-00f2dbae2af2'))
    clound2:engine.Sprite = new engine.Sprite(getTexture('6ed0e2e7-3ba3-4967-8fe0-39667792e343'))
    sun = new engine.Sprite(getTexture("0f05aaae-338a-439a-82b0-20efcee5cca4"));
        
    constructor(){
        super()
        this.sun.x = 90;
        this.sun.y = 120;
        this.addChild(this.sun)

        this.addChild(this.clound1);
        this.addChild(this.clound2);

        this.clound1.x = 100;
        this.clound1.y = 220;
        this.clound2.x = 150;
        this.clound2.y = 220;

    }

    succeed(){
        // 380 580
        let a = 0
        let ld = Date.now();
        this.addEventListener(engine.Event.ENTER_FRAME,()=>{
            let dt = Date.now() - ld;
            a += dt;
            if(a>100){
                this.clound1.x -= (800 * dt) / 1000;
                this.clound2.x += (820*dt)/1000;
                if(this.clound1.x <= -380){
                    this.clound1.x = -380;
                }
                if(this.clound2.x >= 750){
                    this.clound2.x = 750;
                }

                this.sun.y -= (150 * dt) / 1000;
                if(this.sun.y <= 60){
                    this.sun.y = 60;
                }
            }
            ld = Date.now();
        })
    }


    



}