(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.getAwayFromCloud = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}
	//# sourceMappingURL=utils.js.map

	var Human = (function (_super) {
	    tslib.__extends(Human, _super);
	    function Human() {
	        var _this = _super.call(this) || this;
	        _this.humanArray = [
	            '487c1ca7-dea5-4732-b4b6-acb5406ee3a4',
	            '71e07cee-fd6d-40bb-ac0b-5bb28c87276e',
	            '2cd9f1bb-d0d8-42ea-941b-dcd0428e474d'
	        ];
	        _this.human = new engine.Sprite(getTexture(_this.humanArray[0]));
	        _this.addChild(_this.human);
	        _this.width = _this.human.width;
	        _this.height = _this.human.height;
	        return _this;
	    }
	    Human.prototype.facialChange = function (num) {
	        var face = new engine.Sprite(getTexture(this.humanArray[num]));
	        this.human.addChild(face);
	        return face;
	    };
	    Human.prototype.removeFace = function (face) {
	        this.human.removeChild(face);
	    };
	    Human.prototype.scaleEffect = function () {
	        var _this = this;
	        var aaa = 0;
	        var pt = Date.now();
	        this.addEventListener(engine.Event.ENTER_FRAME, function () {
	            var dt = Date.now() - pt;
	            aaa += dt;
	            _this.anchorX = _this.width + _this.width / 2;
	            _this.anchorY = _this.height;
	            if (aaa > 90 && aaa <= 100) {
	                _this.scaleY = 0.99;
	                _this.scaleX = 1.01;
	            }
	            if (aaa > 190 && aaa < 200) {
	                _this.scaleX = 1;
	                _this.scaleY = 1;
	                aaa = 0;
	            }
	            pt = Date.now();
	        });
	    };
	    return Human;
	}(engine.Container));
	//# sourceMappingURL=Human.js.map

	var Moist = (function (_super) {
	    tslib.__extends(Moist, _super);
	    function Moist() {
	        var _this = _super.call(this) || this;
	        _this.moistBg = new engine.Sprite(getTexture('8a8e79b6-2c6f-441b-81ae-c441465abfb0'));
	        _this.moist = new engine.Sprite(getTexture('024d67e9-ed7f-4481-94ca-a15bd5226cad'));
	        _this.moistCover = new engine.Sprite(getTexture('024d67e9-ed7f-4481-94ca-a15bd5226cad'));
	        _this.txt = new engine.TextInput();
	        _this.hintpic = new engine.Sprite(getTexture('ed0e8931-2557-4527-bcfc-9071f90d5737'));
	        _this.percent = 0;
	        _this.addChild(_this.moistBg);
	        _this.moistBg.addChild(_this.moist);
	        _this.moist.mask = _this.moistCover;
	        _this.txt.text = _this.percent * 100 + '%';
	        _this.txt.size = 30;
	        _this.txt.fillColor = '#7A83C5';
	        _this.addChild(_this.txt);
	        _this.txt.x = 0;
	        _this.txt.y = -50;
	        _this.hintpic.x = -10;
	        _this.hintpic.y = 440;
	        _this.addChild(_this.hintpic);
	        return _this;
	    }
	    Moist.prototype.cover = function (percent) {
	        this.moistCover.anchorY = 416;
	        this.moistBg.addChild(this.moistCover);
	        this.moistCover.scaleY = percent;
	        var t = engine.Tween.get(this.moistCover);
	    };
	    Moist.prototype.stopScale = function () {
	        this.moistCover.scaleY = 1;
	        this.txt.text = '100%';
	    };
	    Moist.prototype.updateText = function (percent) {
	        var a = percent * 100;
	        if (a <= 90) {
	            this.txt.text = a.toPrecision(2) + '%';
	        }
	        else {
	            this.txt.text = a.toPrecision(3) + '%';
	        }
	    };
	    Moist.prototype.updatePercent = function (percent) {
	        this.percent = percent;
	    };
	    return Moist;
	}(engine.Container));
	//# sourceMappingURL=Moist.js.map

	var TimeCounter = (function (_super) {
	    tslib.__extends(TimeCounter, _super);
	    function TimeCounter() {
	        var _this = _super.call(this) || this;
	        _this.timeCounter = new engine.Sprite(getTexture('b7d2a60a-9e60-4eca-be80-a991abea47c9'));
	        _this.time = 20;
	        _this.addChild(_this.timeCounter);
	        _this.timeCounter.x = 256;
	        _this.timeCounter.y = 50;
	        _this.timeText = new engine.TextInput();
	        _this.timeText.text = _this.time + 's';
	        _this.timeText.size = 48;
	        _this.timeText.fillColor = '#7A83C5';
	        _this.timeCounter.addChild(_this.timeText);
	        _this.timeText.x = 100;
	        _this.timeText.y = 15;
	        return _this;
	    }
	    TimeCounter.prototype.updateTime = function (time) {
	        this.time = time;
	        this.timeText.text = this.time + 's';
	    };
	    return TimeCounter;
	}(engine.Container));
	//# sourceMappingURL=TimeCounter.js.map

	var CloudRain = (function (_super) {
	    tslib.__extends(CloudRain, _super);
	    function CloudRain() {
	        var _this = _super.call(this) || this;
	        _this.clound1 = new engine.Sprite(getTexture('1e1a6993-9da0-4813-b1bd-00f2dbae2af2'));
	        _this.clound2 = new engine.Sprite(getTexture('6ed0e2e7-3ba3-4967-8fe0-39667792e343'));
	        _this.sun = new engine.Sprite(getTexture("0f05aaae-338a-439a-82b0-20efcee5cca4"));
	        _this.sun.x = 90;
	        _this.sun.y = 120;
	        _this.addChild(_this.sun);
	        _this.addChild(_this.clound1);
	        _this.addChild(_this.clound2);
	        _this.clound1.x = 100;
	        _this.clound1.y = 220;
	        _this.clound2.x = 150;
	        _this.clound2.y = 220;
	        return _this;
	    }
	    CloudRain.prototype.succeed = function () {
	        var _this = this;
	        var a = 0;
	        var ld = Date.now();
	        this.addEventListener(engine.Event.ENTER_FRAME, function () {
	            var dt = Date.now() - ld;
	            a += dt;
	            if (a > 100) {
	                _this.clound1.x -= (800 * dt) / 1000;
	                _this.clound2.x += (820 * dt) / 1000;
	                if (_this.clound1.x <= -380) {
	                    _this.clound1.x = -380;
	                }
	                if (_this.clound2.x >= 750) {
	                    _this.clound2.x = 750;
	                }
	                _this.sun.y -= (150 * dt) / 1000;
	                if (_this.sun.y <= 60) {
	                    _this.sun.y = 60;
	                }
	            }
	            ld = Date.now();
	        });
	    };
	    return CloudRain;
	}(engine.Container));
	//# sourceMappingURL=CloudRain.js.map

	var GameTest = (function (_super) {
	    tslib.__extends(GameTest, _super);
	    function GameTest() {
	        var _this = _super.call(this) || this;
	        _this.timeArray = [];
	        _this.container = new engine.Container();
	        _this.dripArray = [];
	        _this.clicknum = 0;
	        _this.R = 250;
	        _this.D = 340;
	        _this.con = new engine.Sprite();
	        _this.t1 = new engine.Sprite(getTexture('a163b74f-32bc-43d2-8015-7cf1eac71501'));
	        _this.t2 = new engine.Sprite(getTexture('22de82d1-97ec-4195-a32c-f4fc1656e2de'));
	        _this.t3 = new engine.Sprite(getTexture('cc952365-a990-4912-98af-50905559b9d5'));
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameTest.prototype.setup = function () {
	        var playBg = new engine.Sprite(getTexture("5ab43bdc-a6ce-46fb-99c2-a806f57f7484"));
	        this.addChild(playBg);
	        this.humanbeing = new Human();
	        this.humanbeing.x = 290;
	        this.humanbeing.y = 750;
	        this.addChild(this.humanbeing);
	        console.log("xxxxxx", this.stage.width, this.stage.height, this.width, this.height);
	        this.rightHand = new engine.Sprite(getTexture("c7129f77-92a6-479e-9994-7d4b39040a15"));
	        this.rightHand.x = -70;
	        this.rightHand.y = -65;
	        this.rightHand.anchorX = 196;
	        this.rightHand.anchorY = 253;
	        this.humanbeing.addChild(this.rightHand);
	        this.playBtn = new engine.Sprite(getTexture("9e347bef-6e91-4c92-ba5f-f9a52e656207"));
	        this.playBtn.x = 138;
	        this.playBtn.y = 1150;
	        this.playBtn.anchorX = this.playBtn.x + this.playBtn.width / 2;
	        this.playBtn.anchorY = this.playBtn.y + this.playBtn.height / 2;
	        this.addChild(this.playBtn);
	        this.moists = new Moist();
	        this.moists.x = 20;
	        this.moists.y = 450;
	        this.addChild(this.moists);
	        this.cloud = new CloudRain();
	        this.addChild(this.cloud);
	        this.timeArray.push(this.t3, this.t2, this.t1);
	    };
	    GameTest.prototype.start = function () {
	        var _this = this;
	        var middleX = this.humanbeing.x + this.humanbeing.width / 2;
	        var validX1 = this.humanbeing.x;
	        var validX2 = this.humanbeing.x + this.humanbeing.width;
	        var point1 = new engine.Graphics();
	        point1.beginFill(0xff0000);
	        point1.drawRect(0, 0, 10, 10);
	        point1.x = 0;
	        point1.y = 100;
	        point1.endFill();
	        this.rightHand.addChild(point1);
	        var point2 = new engine.Graphics();
	        point2.beginFill(0xff0000);
	        point2.drawRect(0, 0, 10, 10);
	        point2.x = 170;
	        point2.y = 0;
	        point2.endFill();
	        this.rightHand.addChild(point2);
	        var point3 = new engine.Graphics();
	        point3.beginFill(0xff0000);
	        point3.drawRect(0, 0, 10, 10);
	        point3.x = 330;
	        point3.y = 100;
	        point3.endFill();
	        this.rightHand.addChild(point3);
	        window['p1'] = point1;
	        window['p2'] = point2;
	        window['p3'] = point3;
	        this.timeCounter = new TimeCounter();
	        this.addChild(this.timeCounter);
	        var ld = Date.now();
	        var a = 0;
	        var b = 0;
	        var timer = 0;
	        var succeedFlag = false;
	        var failFlag = false;
	        for (var i = 0; i < this.timeArray.length; i++) {
	            var t = this.timeArray[i];
	            t.anchorTexture.set(0.5, 0.5);
	            t.x = 750 / 2;
	            t.y = 1624 / 2;
	            t.alpha = 0;
	            this.container.addChild(t);
	            this.addChild(this.container);
	        }
	        for (var i = 0; i < this.timeArray.length; i++) {
	            var img = this.timeArray[i];
	            var delta = i * 1000;
	            var t = engine.Tween.get(img);
	            t.wait(delta).set({ alpha: 0.2, scaleX: 2, scaleY: 2 })
	                .to({ alpha: 1, scaleX: 1, scaleY: 1 }, 300)
	                .to({ alpha: 0 }, 200)
	                .wait(500);
	            if (i === this.timeArray.length - 1) {
	                t.call(function () {
	                    engine.Tween.get(_this.container).to({ alpha: 0 }, 200).call(function () {
	                        _this.removeChild(_this.container);
	                    });
	                    _this.winds = createSvga("wind");
	                    _this.addChild(_this.winds);
	                    _this.winds.visible = true;
	                    _this.winds.play(true, true);
	                    _this.winds.once(engine.Event.END_FRAME, function () {
	                        _this.removeChild(_this.winds);
	                    }, _this);
	                });
	            }
	        }
	        this.rainEffect = createSvga("雨滴动效");
	        this.addEventListener(engine.Event.ENTER_FRAME, function addFrame() {
	            var _this = this;
	            var dt = Date.now() - ld;
	            b += dt;
	            timer += dt;
	            if (timer >= 3000) {
	                a += dt;
	                if (a > 10) {
	                    a = 0;
	                    if (this.moists.percent < 1 && this.timeCounter.time > 0) {
	                        var drip = new engine.Sprite(getTexture("07f74bf6-416f-445e-98d5-021efe4c9fdc"));
	                        drip.x = Math.random() * (this.humanbeing.x + 160) + (this.humanbeing.x - 160);
	                        drip.y = Math.random() * 100 + 300;
	                        this.dripArray.push(drip);
	                        this.addChild(drip);
	                    }
	                }
	                var _loop_1 = function (drip) {
	                    drip.y += (300 * dt) / 1000;
	                    if (drip.y > this_1.stage.height) {
	                        var index_1 = this_1.dripArray.indexOf(drip);
	                        this_1.removeChild(drip);
	                        this_1.dripArray = this_1.dripArray.filter(function (ele, i) { return i != index_1; });
	                    }
	                };
	                var this_1 = this;
	                for (var _i = 0, _a = this.dripArray; _i < _a.length; _i++) {
	                    var drip = _a[_i];
	                    _loop_1(drip);
	                }
	                if (b >= 1000) {
	                    b = 0;
	                    if (this.moists.percent < 1) {
	                        this.timeCounter.time -= 1;
	                        if (this.timeCounter.time <= 0) {
	                            this.timeCounter.time = 0;
	                        }
	                        this.timeCounter.updateTime(this.timeCounter.time);
	                    }
	                    if (this.timeCounter.time <= 0 && !succeedFlag) {
	                        this.timeCounter.time = 0;
	                        succeedFlag = true;
	                        console.log("游戏成功！");
	                        this.success();
	                    }
	                }
	                var wind = -40;
	                this.rightHand.rotation += wind / 60;
	                if (this.rightHand.rotation <= -90) {
	                    this.rightHand.rotation = -90;
	                }
	                else if (this.rightHand.rotation >= 90) {
	                    this.rightHand.rotation = 90;
	                }
	                if (this.rightHand.rotation <= -60) {
	                    var face_1 = this.humanbeing.facialChange(1);
	                    face_1.x = 7;
	                    face_1.y = 22;
	                    setTimeout(function () {
	                        _this.humanbeing.removeFace(face_1);
	                    }, 100);
	                }
	                this.angle = Math.asin(this.D / 2 / this.R) * 57.18;
	                this.rightHand.name = "aaa";
	                var sa = this.worldMatrix.a;
	                var sd = this.worldMatrix.d;
	                var p1x = point1.worldMatrix.tx / sa;
	                var p2x = point2.worldMatrix.tx / sa;
	                var p3x = point3.worldMatrix.tx / sa;
	                var p1y = point1.worldMatrix.ty / sd;
	                var p2y = point2.worldMatrix.ty / sd;
	                var p3y = point3.worldMatrix.ty / sd;
	                var k12 = (p1y - p2y) / (p1x - p2x);
	                var k23 = (p2y - p3y) / (p2x - p3x);
	                var px1 = p1x;
	                var px2 = p2x;
	                var px3 = p3x;
	                var maxX = px1 >= px2 ? (px1 >= px3 ? px1 : px3) : px2 >= px3 ? px2 : px3;
	                var minX = px1 >= px2 ? (px2 >= px3 ? px3 : px2) : px1 >= px3 ? px3 : px1;
	                var x2 = (middleX + this.R) < maxX ? (middleX + this.R) : maxX;
	                var _loop_2 = function (drip) {
	                    var dx = drip.worldMatrix.tx / sa;
	                    var dy = drip.worldMatrix.ty / sd;
	                    var b12 = p1y - p1x * k12 - 50;
	                    var b23 = p2y - p2x * k23 - 50;
	                    var y12 = k12 * dx + b12;
	                    var y23 = k23 * dx + b23;
	                    if (dx >= minX && dx < maxX) {
	                        if (dx < px2) {
	                            if (dy >= y12) {
	                                var index_2 = this_2.dripArray.indexOf(drip);
	                                this_2.removeChild(drip);
	                                this_2.dripArray = this_2.dripArray.filter(function (ele, i) { return i != index_2; });
	                            }
	                        }
	                        if (dx >= px2) {
	                            if (dy >= y23) {
	                                var index_3 = this_2.dripArray.indexOf(drip);
	                                this_2.removeChild(drip);
	                                this_2.dripArray = this_2.dripArray.filter(function (ele, i) { return i != index_3; });
	                            }
	                        }
	                    }
	                    if (drip.x > this_2.humanbeing.x &&
	                        drip.x < this_2.humanbeing.x + this_2.humanbeing.width) {
	                        if (drip.y >= this_2.humanbeing.y) {
	                            this_2.moists.percent += 0.1;
	                            this_2.moists.cover(this_2.moists.percent);
	                            this_2.moists.updateText(this_2.moists.percent);
	                            this_2.addChild(this_2.rainEffect);
	                            this_2.rainEffect.visible = true;
	                            this_2.rainEffect.play(true, true);
	                            this_2.rainEffect.x = drip.x - drip.width * 2;
	                            this_2.rainEffect.y = drip.y;
	                            this_2.rainEffect.once(engine.Event.END_FRAME, function () {
	                                _this.rainEffect.visible = false;
	                            });
	                            if (this_2.moists.percent >= 1 && !failFlag) {
	                                this_2.moists.stopScale();
	                                failFlag = true;
	                                console.log("游戏结束！");
	                                this_2.stop();
	                            }
	                            this_2.removeChild(drip);
	                            var face_2 = this_2.humanbeing.facialChange(2);
	                            face_2.x = 7;
	                            face_2.y = 22;
	                            setTimeout(function () {
	                                _this.humanbeing.removeFace(face_2);
	                            }, 500);
	                            console.log("人");
	                            var index_4 = this_2.dripArray.indexOf(drip);
	                            this_2.dripArray = this_2.dripArray.filter(function (ele, i) { return i != index_4; });
	                            this_2.humanbeing.scaleEffect();
	                        }
	                    }
	                };
	                var this_2 = this;
	                for (var _b = 0, _c = this.dripArray; _b < _c.length; _b++) {
	                    var drip = _c[_b];
	                    _loop_2(drip);
	                }
	            }
	            ld = Date.now();
	        });
	        this.playBtn.addEventListener(engine.MouseEvent.CLICK, this.onClick, this);
	        this.rightHand.rotation = 0;
	    };
	    GameTest.prototype.onClick = function () {
	        this.clicknum += 1;
	        this.rightHand.rotation += 10 * this.clicknum;
	        this.clicknum = 0;
	    };
	    GameTest.prototype.stop = function () {
	        engine.globalEvent.dispatchEvent("cloud-game-fail", { reason: 1 });
	    };
	    GameTest.prototype.success = function () {
	        this.cloud.succeed();
	        engine.globalEvent.dispatchEvent("cloud-game-success", {
	            moist: this.moists.percent,
	        });
	    };
	    return GameTest;
	}(engine.Container));

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('pictures-start', _this.start, _this);
	        engine.globalEvent.addEventListener('pictures-stop', _this.stop, _this);
	        var gameTest = _this._gameTest = new GameTest();
	        _this.addChild(gameTest);
	        return _this;
	    }
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._gameTest.start();
	    };
	    GameWrapper.prototype.stop = function (event) {
	        this._gameTest.stop();
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map