(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['food-fell2'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	function getTextureByName(name) {
	    return engine.Texture.from(getAssetByName(name).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + getAssetByName(name).uuid;
	    return inst;
	}

	var Goods = (function (_super) {
	    tslib.__extends(Goods, _super);
	    function Goods() {
	        var _this = _super.call(this) || this;
	        var body;
	        body = _this._body = new engine.Rect();
	        var rain = new engine.Sprite(getTextureByName('雨滴0'));
	        var rain1 = new engine.Sprite(getTextureByName('雨滴1'));
	        var rain2 = new engine.Sprite(getTextureByName('雨滴2'));
	        rain["npcType"] = "rain0";
	        rain1["npcType"] = "rain1";
	        rain2["npcType"] = "rain2";
	        var stone = new engine.Sprite(getTextureByName('石块'));
	        stone["npcType"] = "stone";
	        var boom = new engine.Sprite(getTextureByName('炸弹'));
	        boom["npcType"] = "boom";
	        rain.visible = false;
	        rain1.visible = false;
	        rain2.visible = false;
	        stone.visible = false;
	        boom.visible = false;
	        body.addChild(rain);
	        body.addChild(rain1);
	        body.addChild(rain2);
	        body.addChild(stone);
	        body.addChild(boom);
	        _this.addChild(body);
	        body.width = .0001;
	        body.height = .0001;
	        body.mouseEnabled = false;
	        return _this;
	    }
	    Goods.prototype.getRandomNumberByRange = function (start, end) {
	        return Math.floor(Math.random() * (end - start) + start);
	    };
	    Goods.prototype.reset = function () {
	        this.visible = true;
	        this.rotation = 0;
	        this.anchorOffsetY = 0;
	        this.y = 0;
	        this.x = (750 - 120) * Math.random() + 30;
	        this.rotation = 0;
	        var random = Math.random();
	        if (typeof (props.goodsProbability) == 'string') {
	            props.goodsProbability = props.goodsProbability.split(',').map(function (i) { return +i; });
	        }
	        if (random < props.goodsProbability[0]) {
	            var randomNum = Math.floor(Math.random() * 3);
	            this.showNpc("rain" + randomNum);
	        }
	        else if (random >= props.goodsProbability[0] && random <= (props.goodsProbability[0] + props.goodsProbability[1])) {
	            this.showNpc("stone");
	        }
	        else if (random > (props.goodsProbability[0] + props.goodsProbability[1])) {
	            this.showNpc("boom");
	        }
	    };
	    Goods.prototype.showNpc = function (type) {
	        for (var i = 0; i < this._body.children.length; i++) {
	            this._body.children[i].visible = false;
	            this._body.children[i].mouseEnabled = false;
	        }
	        for (var i = 0; i < this._body.children.length; i++) {
	            if (this._body.children[i]["npcType"] == type) {
	                this["npcType"] = type;
	                this._body.children[i].visible = true;
	                this._body.children[i].mouseEnabled = false;
	            }
	        }
	    };
	    Object.defineProperty(Goods.prototype, "anchorOffsetY", {
	        set: function (v) {
	            this._body.y = v;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Goods;
	}(engine.Container));

	var ObjectPool = engine.ObjectPool;
	var PoolName = 'goods';
	ObjectPool.registerPool(PoolName, function () {
	    return new Goods();
	}, function (item, data) {
	    item.reset();
	});

	var ObjectPool$1 = engine.ObjectPool;
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.goodsItems = [];
	        _this.viewVisible = true;
	        _this.cacheTime = 0;
	        _this.cacheTime2 = 0;
	        _this.moveCatchX = 0;
	        _this.playerCatchX = 0;
	        _this.onDownStage = function (e) {
	            _this.moveCatchX = e.localX;
	            _this.playerCatchX = _this.player.x;
	        };
	        _this.onMoveStage = function (e) {
	            var maxStageBound = props.maxStageBound;
	            if (_this.gameIng) {
	                var playerX = _this.playerCatchX + (e.localX - _this.moveCatchX);
	                if (playerX < maxStageBound) {
	                    _this.player.x = maxStageBound;
	                }
	                else if (playerX + _this.player.width + maxStageBound > 750) {
	                    _this.player.x = 750 - maxStageBound - _this.player.width;
	                }
	                else {
	                    _this.player.x = playerX;
	                }
	            }
	        };
	        _this.onOutStage = function (e) {
	            _this.moveCatchX = 0;
	        };
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        var _this = this;
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        this.NpcBg = new engine.Container();
	        this.NpcBg.alpha = 1;
	        this.NpcBg.width = 0;
	        this.NpcBg.height = 0;
	        this.addChild(this.NpcBg);
	        this.player = new engine.Container();
	        this.player.mouseEnabled = false;
	        this.addChild(this.player);
	        this.waterSvga = createSvga("水花");
	        this.stoneSvga = createSvga("石头svga");
	        this.playerSvga = new engine.Sprite(getTextureByName('玩家'));
	        this.boomSvga = createSvga("炸弹svga");
	        this.player.addChild(this.playerSvga);
	        this.player.addChild(this.stoneSvga);
	        this.player.addChild(this.waterSvga);
	        this.player.addChild(this.boomSvga);
	        this.waterSvga.visible = false;
	        this.stoneSvga.visible = false;
	        this.boomSvga.visible = false;
	        this.visible = false;
	        setTimeout(function () {
	            _this.visible = true;
	            _this.player.anchorY = _this.player.height / 2;
	            _this.player.anchorX = _this.player.width / 2;
	            _this.player.x = 375 - _this.player.width / 2;
	            _this.player.y = props.playerPositionY;
	            _this.stoneSvga.x = _this.player.width / 2 - _this.stoneSvga.width / 2 + props.boomPosition1Offset[0];
	            _this.stoneSvga.y = _this.player.height / 2 - _this.stoneSvga.height / 2 + props.boomPosition1Offset[1];
	            _this.waterSvga.x = _this.player.width / 2 - _this.waterSvga.width / 2 + props.boomPosition2Offset[0];
	            _this.waterSvga.y = _this.player.height / 2 - _this.waterSvga.height / 2 + props.boomPosition2Offset[1];
	            _this.boomSvga.x = _this.player.width / 2 - _this.boomSvga.width / 2 + props.boomPosition3Offset[0];
	            _this.boomSvga.y = _this.player.height / 2 - _this.boomSvga.height / 2 + props.boomPosition3Offset[1];
	        }, 300);
	        this.rectBg = new engine.Container();
	        this.rectBg.alpha = 0;
	        this.rectBg.width = 750;
	        this.rectBg.height = 1624;
	        this.addChild(this.rectBg);
	        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDownStage, this);
	        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onMoveStage, this);
	        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_OUT, this.onOutStage, this);
	        document.addEventListener("visibilitychange", function () {
	            if (document.visibilityState == "visible") {
	                _this.viewVisible = true;
	            }
	            if (document.visibilityState == "hidden") {
	                _this.viewVisible = false;
	            }
	        });
	        this.addEventListener(engine.Event.ENTER_FRAME, this.enterFrame, this);
	    };
	    GameView.prototype.enterFrame = function () {
	        this.updateTime();
	        this.updateTimeBeginNpc();
	    };
	    GameView.prototype.reset = function () {
	        this.score = props.speed;
	        this.recycleGoods();
	        this.player.x = 375 - this.player.width / 2;
	    };
	    GameView.prototype.start = function () {
	        this.score = 0;
	        this.speed = 1;
	        this.gameIng = true;
	        this.beginNpc();
	        this.countdown = props.countDown;
	    };
	    GameView.prototype.updateTime = function () {
	        if (Date.now() - this.cacheTime > 1000) {
	            this.cacheTime = Date.now();
	        }
	        else {
	            return;
	        }
	        if (this.gameIng) {
	            if (this.countdown > 0) {
	                engine.globalEvent.dispatchEvent('food-fell-time-update', {
	                    time: this.countdown,
	                });
	                this.countdown -= 1;
	            }
	            else {
	                engine.globalEvent.dispatchEvent('food-fell-game-over', {
	                    score: this.score,
	                    reason: 1
	                });
	                this.died();
	            }
	        }
	    };
	    GameView.prototype.beginNpc = function () {
	    };
	    GameView.prototype.updateTimeBeginNpc = function () {
	        if (Date.now() - this.cacheTime2 > (2000 / this.speed)) {
	            this.cacheTime2 = Date.now();
	        }
	        else {
	            return;
	        }
	        if (this.gameIng) {
	            this.speed += props.acceleratedSpeed;
	            if (this.speed >= props.maxSpeed) {
	                this.speed = props.maxSpeed;
	            }
	            this.creatNpc();
	        }
	    };
	    GameView.prototype.pause = function () {
	        this.gameIng = false;
	    };
	    GameView.prototype.revive = function () {
	        this.gameIng = true;
	    };
	    GameView.prototype.resume = function () {
	        this.reset();
	        this.start();
	    };
	    GameView.prototype.creatNpc = function () {
	        var _this = this;
	        var goods = this._goods = ObjectPool$1.getObject(PoolName);
	        this.goodsItems.push(goods);
	        this.NpcBg.addChild(goods);
	        goods.addEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"] = function () {
	            if (goods.y > 1624) {
	                _this.removeNpc(goods);
	            }
	            else {
	                if (_this.gameIng) {
	                    goods.y += (4 * _this.speed);
	                    if (_this.hasHit(_this.player, goods)) {
	                        if (goods["npcType"].indexOf("rain") > -1) {
	                            _this.score += props.rainScore;
	                            _this.waterSvga.visible = true;
	                            _this.waterSvga.play(false, false);
	                            _this.waterSvga.once(engine.Event.END_FRAME, function () {
	                                _this.waterSvga.visible = false;
	                            }, _this);
	                            if (_this.score < 0) {
	                                _this.score = 0;
	                            }
	                        }
	                        else if (goods["npcType"] == "stone") {
	                            _this.score += props.stoneScore;
	                            if (_this.score < 0) {
	                                _this.score = 0;
	                            }
	                            _this.stoneSvga.visible = true;
	                            _this.stoneSvga.play(false, false);
	                            _this.stoneSvga.once(engine.Event.END_FRAME, function () {
	                                _this.stoneSvga.visible = false;
	                            }, _this);
	                        }
	                        else if (goods["npcType"] == "boom") {
	                            _this.boomSvga.visible = true;
	                            _this.boomSvga.play(false, false);
	                            _this.died();
	                            _this.boomSvga.once(engine.Event.END_FRAME, function () {
	                                _this.boomSvga.visible = false;
	                                engine.globalEvent.dispatchEvent('food-fell-game-over', {
	                                    score: _this.score,
	                                    reason: 2
	                                });
	                            }, _this);
	                        }
	                        engine.globalEvent.dispatchEvent('food-fell-score-update', {
	                            score: _this.score,
	                        });
	                        _this.removeNpc(goods);
	                    }
	                }
	            }
	        }, this);
	    };
	    GameView.prototype.died = function () {
	        this.pause();
	    };
	    GameView.prototype.removeNpc = function (goods) {
	        this.NpcBg.removeChild(goods);
	        ObjectPool$1.recycleObject(PoolName, goods);
	        goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
	        var index = this.goodsItems.indexOf(goods);
	        if (index > -1) {
	            this.goodsItems.splice(index, 1);
	        }
	    };
	    GameView.prototype.recycleGoods = function () {
	        clearTimeout(this.timer);
	        clearInterval(this.countdownTimer);
	        for (var _i = 0, _a = this.goodsItems; _i < _a.length; _i++) {
	            var goods = _a[_i];
	            if (goods) {
	                this.NpcBg.removeChild(goods);
	                ObjectPool$1.recycleObject(PoolName, goods);
	                goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
	            }
	        }
	        this.goodsItems = [];
	    };
	    GameView.prototype.hasHit = function (a, b) {
	        var playerH = a.height;
	        var playerW = a.width;
	        var playerX = a.x;
	        if (props.playerHeight) {
	            playerH = props.playerHeight;
	        }
	        if (props.playerWidth) {
	            playerW = props.playerWidth;
	            playerX = a.x + (a.width - props.playerWidth) / 2;
	        }
	        if (Math.abs((playerX + playerW / 2) - (b.x + b.width / 2)) < playerW / 2 + b.width / 2
	            &&
	                Math.abs((a.y + playerH / 1.3) - (b.y + b.height / 2)) < playerH / 2 + b.height / 2) {
	            return true;
	        }
	        else {
	            return false;
	        }
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('food-fell-reset', _this.reset, _this);
	        engine.globalEvent.addEventListener('food-fell-start', _this.start, _this);
	        engine.globalEvent.addEventListener('food-fell-pause', _this.pause, _this);
	        engine.globalEvent.addEventListener('food-fell-resume', _this.resume, _this);
	        engine.globalEvent.addEventListener('food-fell-revive', _this.revive, _this);
	        engine.globalEvent.addEventListener('food-fell-clear', _this.clear, _this);
	        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._status = 1;
	        this._gameView.start();
	    };
	    GameWrapper.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    GameWrapper.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    GameWrapper.prototype.revive = function () {
	        this._gameView.revive();
	    };
	    GameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    GameWrapper.prototype.onTap = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map