import {getTexture} from "./utils"
import TestView from "./TestView";
export class Card extends engine.Sprite
{
    cardImg:engine.Image;
    testShape:engine.Shape;
    cardState:boolean;//false:代表反面，true:代表正面
    id:number;
    texture1:engine.Texture;
    texture2:engine.Texture;
    curLevel:number = 1;
    view:TestView;
    constructor(curLevel:number){
        super();
        this.curLevel = curLevel;
        this.addEventListener(engine.Event.ADDED_TO_STAGE,this.setup,this);
    }

    setup(){
        var that = this;
        that.removeEventListener(engine.Event.ADDED_TO_STAGE,this.setup,this);
        that.cardState = false;
        that.cardImg = new engine.Image();
        that.addChild(that.cardImg);
        var uuid:string = '';
        switch(that.curLevel){
            case 1: uuid = "d47b90ee-5295-4bd7-bb83-5fbd19a46e00";break;
            case 2: uuid = "6af07fd2-9e73-4633-88fe-f963c6e23c4e";break;
            case 3: uuid = "07586544-a854-4245-9ebf-d2b35d92be0e";break;
            // default:console.log("卡牌初始化失败，当前关卡异常")
        }
        that.texture1 = getTexture(uuid);

        that.cardImg.texture = that.texture1;
        that.anchorX = that.cardImg.width>>1;
        that.anchorY = that.cardImg.height>>1;
    }

    setView(view:TestView){
        this.view = view;
    }

    setCard(data){
        this.id = data.id;
        this.texture2 = getTexture(data.texture);
    }

    removeCard(){
        engine.Tween.get(this).to({alpha:0,rotation:1800},400).call(()=>{
            if(this.parent&&this.parent.contains(this)){
                this.view.arrRemove(this);
                this.parent.removeChild(this);
            }
        });
    }

    changeState(){
        var that = this;
        return new Promise((resolve,reject)=>{
            that.cardState = !that.cardState;
            engine.Tween.removeTweens(this);
            if(!that.cardState){
                engine.Tween.get(this).to({scaleX:0},150).call(()=>{
                    that.cardImg.texture = that.texture1;
                }).to({scaleX:1},150).call(()=>{resolve()});
            }else{
                engine.Tween.get(this).to({scaleX:0},150).call(()=>{
                    that.cardImg.texture = that.texture2;
                }).to({scaleX:1},150).call(()=>{resolve()});
            }
        })
        
    }
}
