import { props } from "../props";

export class Strut extends engine.Container{
    _strut: engine.Rect;
    _distance;
    _callBack;
    init(){
        this._strut = new engine.Rect();
        this.addChild(this._strut);
        this._strut.width = props.strutWidth;
        this._strut.y = 833;
        this._strut.fillColor = props.strutColor;
        this._strut.rotation  = 180;
    }
    onMouseDown(pierWidth,distance,callBack){
        this._strut.x = pierWidth - 60;
        this._distance = distance;
        this._callBack = callBack;
        this._strut.visible = true;
        this.addEventListener(engine.Event.ENTER_FRAME,this.frameStrut,this);
    }
    onMouseUp(){
        this.removeEventListener(engine.Event.ENTER_FRAME,this.frameStrut,this);
        setTimeout(() => {
            this.strutRotation();
        }, 200);
    }
    strutRotation(){
        engine.Tween.get(this._strut,{loop:false})
        .to({rotation:270},props.strutRotationSpeed)
        .call(()=>{
            this.judgeResult();
            engine.Tween.removeTweens(this._strut);
        })
    }
    judgeResult(){
        let isSuccess = false;
        if(this._distance[0] - this._distance[1] + 100 <= this._strut.height && this._strut.height <= this._distance[0] + 20){
            isSuccess = true;
        }
        if(this._callBack){
            this._callBack(isSuccess);
        }
    }
    frameStrut(){
        if(this._strut.height < 1000){
            this._strut.height += props.strutUpSpeed;
        }
    }
    rest(){
        this._strut.width = props.strutWidth;
        this._strut.y = 833;
        this._strut.fillColor = props.strutColor;
        this._strut.rotation  = 180;
        this._strut.height = 0;
        this._strut.visible = false;
    }
    getStrutHeight(){
        let distance = this._strut.height > 1000 ? 1000 :this._strut.height;
        return distance;
    }

}