

import { props } from './../props';
import ObjectPool = engine.ObjectPool;
import {getStage} from "./utils";
import { Pier } from './Pier';
import GameView from './GameView';

export class Road extends engine.Container{
    //container: engine.Container;
    lastPos;
    setup(){
        // this.container = new engine.Container();
        // this.addChild(this.container);
        this.lastPos = 0;
        this.addPier();

    }
    getFristPier(){
        return this.getChildAt(0).width;
    }
    getDistance(){
        let distance = [];
        let pier1 = this.getChildAt(0);
        let pier2 = this.getChildAt(1);
        distance.push(pier2.x - pier1.x);
        distance.push(pier2.width);

        return distance;
    }
    addPier(){     
        while(this.children.length < props.pierCount + 1){
            let childrenNum = this.children.length;
            let randomPos = this.makeRandomFloat(props.pierMaxDistance,props.pierMinDistance);
            const pier: Pier = ObjectPool.getObject('pier');
            this.addChild(pier);
            if(childrenNum == 0){
                pier.x = 0;
            }else{
                pier.x = this.lastPos + randomPos;
            }
            this.lastPos = pier.x;
        }
    }
    moveAddPier(){
        let randomPos = this.makeRandomFloat(props.pierMaxDistance,props.pierMinDistance);
        const pier: Pier = ObjectPool.getObject('pier');
        let lastChild = this.getChildAt(this.children.length -1);
        pier.x = lastChild.x + randomPos;
        this.addChild(pier);

    }
    makeRandomFloat(max: number, min: number = 0): number {
        return Math.random() * (max - min) + min;
    }
    setViewport(){
        let tmpMovepos = this.getMovePos();
        this.children.forEach((item,index) => {
            this.playTween(item,index,tmpMovepos);
        })
    }
    //获得移动位移
    getMovePos(){
        let movePos:any = this.getChildAt(1);
        return movePos.x;
    }
    playTween(item,index,tmpMovepos){
        engine.Tween.get(item,{loop:false})
        .to({x : item.x - tmpMovepos},props.pierMoveTime)
        .call(()=>{
            if(this.getChildIndex(item) == 0){
                engine.Tween.removeTweens(item);
                this.removeChild(item);
                ObjectPool.recycleObject('pier',item);
            }
            if(index == 0){
                this.moveAddPier();
            }
        })
    }
    //桥墩是否有金币
    getStartGold(index,isClose = true){
        let tmpNode:any = this.getChildAt(index);
        let haveGold = tmpNode.haveGold;
        if(haveGold && isClose){
            tmpNode.closeGold();
        }
        return haveGold;
    }     
    //设置新手引导 第二个桥墩要有金币
    setGuide(){
        let tmpNode:any = this.getChildAt(1);
        if(!tmpNode.haveGold){
            tmpNode.children.forEach((item) => {
                if(item.name == 'gold'){
                    item.visible = true;
                }
            })
            tmpNode.haveGold = true;
        }
    }
}