import {props} from "../props";
import {createSvga, playSound} from "./utils";
export class Player extends engine.Container{
    _container;
    private playerNode: svga.Svga;

    initPlayer(pierWidth){
   
        this._container = new engine.Container();
        this.addChild(this._container);


        this.playerNode = createSvga('walk');
        this._container.addChild(this.playerNode);
        this.playerNode.y = 675;
        this.playerNode.x = pierWidth/2 - 80;
        this.playerNode.play();
    }
    setViewport(pos,callBack,pierWidth?){
        let tmpPos = 0;
        let isSuccess = false;
        if(!pierWidth){
            tmpPos = pos;
            isSuccess = true;
        }else{
            tmpPos = pierWidth - this.playerNode.x + pos - 60;
        }
        this.playGoTween(tmpPos,callBack,isSuccess)
    }
    playGoTween(pos,callBack,isSuccess){
        engine.Tween.get(this._container,{loop:false})
        .to({x : pos},props.playerMoveSpeed)
        .call(()=>{
            engine.Tween.removeTweens(this._container);
            if(isSuccess){
                if(callBack){
                    callBack();
                }
            }else{
                this.playDropTween(callBack);
            }
     
        })
    }
    playDropTween(callBack){
        engine.Tween.get(this._container,{loop:false})
        .to({y : 2000},1000)
        .call(()=>{
            engine.Tween.removeTweens(this._container);
            if(callBack){
                callBack();
            }
        })
    }
    setBackViewport(callBack){
        engine.Tween.get(this._container,{loop:false})
        .to({x : 0},props.pierMoveTime)
        .call(()=>{
            engine.Tween.removeTweens(this._container);
            if(callBack){
                callBack();
            }
        })
    }

}