import { props } from './../props';
import {getTextureByName,getStage} from "./utils";
export class Pier extends engine.Container {
    bmp;
    public haveGold;
    constructor() {
		super();
        this.bmp = new engine.Sprite();
        this.addChild(this.bmp);
		
    }
    init(){
		const bmp = this.bmp;
		bmp.alpha = 1;
		bmp.texture = getTextureByName('pier');
		bmp.x = 0;
        bmp.y = bmp.height ;
        if(this.children.length < 2){
            const gold = new engine.Sprite();
            gold.texture = getTextureByName('gold');
            gold.name = 'gold';
            this.addChild(gold);
        }
        this.setGoldPosX(bmp);
        this.setShowGold();
    }
    setShowGold(){
        let nodeGold = this.getChildByName('gold');
        let randomWard = Math.random();
        nodeGold.alpha = 1;
        let isShow = randomWard < props.reward ? true : false ;
        nodeGold.visible = isShow;
        this.haveGold = isShow;
    }
    setGoldPosX(bmp){
        let nodeGold = this.getChildByName('gold');
        let pos = bmp.width / 2 - nodeGold.width/2;
        nodeGold.x = pos
        nodeGold.y = bmp.height - nodeGold.height - 50;
        nodeGold.visible = false;
    }
    closeGold(){
        this.children.forEach((item) => {
            if(item.name == 'gold')
            {
                item.anchorX = item.width/2;
                item.anchorY = item.height/2;
                engine.Tween.get(item,{loop:false})
                .to({scaleX:2.5,scaleY:2.5},200,engine.Ease.cubicOut)
                .to({scaleX:1,scaleY:1,alpha:0},200,engine.Ease.cubicIn)
                .call(()=>{
                    item.visible = false;
                    this.haveGold = false;
                })
            }
        })
    }
}