/**
 * Created by rockyl on 2020-01-30.
 */
import {props} from "../props";
import {getTextureByName} from "./utils";

export class GuideLayer extends engine.Container {
	private guideMask: engine.Container;
	private _options;
	_guideHole;
	_canClear:any = [];
	_callBack;
	private label: engine.Label;

	constructor() {
		super();

		this.setup();
	}

	private setup() {

	}

	show(id, options,callback?) {
		this.visible = true;
		this._callBack = callback?callback:null;
		if (!this.guideMask) {
			this._options = options;
			const {width, height} = this.stage;
			let guideMask = this.guideMask = new engine.Container();
			
			let guideHole = this._guideHole= new engine.Image(getTextureByName('guide'));
			guideHole.x = options.x;
			guideHole.y = options.y;
			guideHole.width = 250;
			guideHole.height = 250;
			guideHole.name = 'guideHole';
			guideMask.addChild(guideHole);

			
			this.createRect(guideMask, 0, 0, width, guideHole.y);
			this.createRect(guideMask, 0, guideHole.y, guideHole.x, guideHole.height);
			this.createRect(guideMask, guideHole.x + guideHole.width, guideHole.y, width - guideHole.x - guideHole.width, guideHole.height);
			this.createRect(guideMask, 0, guideHole.y + guideHole.height, width, height - guideHole.y - guideHole.height);
			this.guideStep(id);
			let label = this.label = new engine.Label();
			label.fillColor = 'white';
			label.size = 30;
			label.text = options.guideText;
			label.x = (width - label.width) / 2;
			label.y = guideHole.y + guideHole.height + 50;
			label.textAlign = engine.TEXT_ALIGN.CENTER;
			label.name = 'labHint';
			guideMask.addChild(label);

			this.addChild(guideMask);
		}
		this.once(engine.MouseEvent.CLICK, function(){
	
			this.removeChild(this.guideMask);
			this.guideMask = null;
		
			if(this._callBack){
				this._callBack();
			}
		
		}, this);
	}

	createRect(container, x, y, width, height) {
		let rect = new engine.Rect();
		rect.x = x;
		rect.y = y;
		rect.width = width;
		rect.height = height;
		rect.fillColor = 'black';
		rect.alpha = 0.7;

		container.addChild(rect);
	}
	guideStep(id){
		if(id == 1){
			let guideHand = new engine.Image(getTextureByName('guideHand'));
			guideHand.x = this._options.x + 300;
			guideHand.y = this._options.y + 100;
			this.guideMask.addChild(guideHand);
	
			let rect = new engine.Rect();
			rect.x = this._options.x + 200;
			rect.y = this._options.y - 15;
			rect.width = props.strutWidth;
			rect.height = 200;
			rect.fillColor = props.strutColor;
			this.guideMask.addChild(rect);

			this._canClear.push(guideHand);
			this._canClear.push(rect);
		}
		if(id == 2){

			let know = new engine.Image(getTextureByName('know'));
			know.x = (this.stage.width - know.width) / 2;
			know.y =   this._options.y + 400;
			this.guideMask.addChild(know);
			this._canClear.push(know);
		}
	}
}
