
import { Road } from './Road';
/**
 * Created by rockyl on 2018/8/16.
 */

import {props} from "../props";
import {getStage,getTextureByName} from "./utils";
import {GuideLayer} from "./GuideLayer";
import { Background } from "./Background";
import ObjectPool = engine.ObjectPool;
import { Pier } from './Pier';
import { Player } from './Player';
import { Strut } from './Strut';
import { ScoreLabel } from './ScoreLabel';

export const PoolName: string = 'pier';

ObjectPool.registerPool(PoolName, function () {
	return new Pier();
}, function (item: Pier, data) {
	item.init();
});

export default class GameView extends engine.Container {
	guideLayer: GuideLayer;
	
	private _hasSetup;
	_backgroud:Background;
	_road:Road;
	_player:Player;
	_strut:Strut;
	_touchLayer: engine.Rect;
	_isTouchLayer;
	_scoreContainer;
	moveX = 0;
	labScore:ScoreLabel;
	_sumScore;
	_isMouseDown;

	_guide;
	constructor() {
		super();	
		this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
	}
	setup(){
		if (this._hasSetup) {
			return;
		}
		this._hasSetup = true;
		
		this._backgroud = new Background();
		this.addChild(this._backgroud);
		this._backgroud.initBg();

		const road = this._road = new Road();
		this.addChild(road);
		road.setup();

		let pierWidth = this._road.getFristPier();
		const player = this._player = new Player();
		this.addChild(player);
		player.initPlayer(pierWidth);

		const strut = this._strut = new Strut();
		this.addChild(strut);
		strut.init();

		this._scoreContainer = new engine.Container();
		this.addChild(this._scoreContainer);
		this.initLabScore();

	}
	async start(guide) {
		this._isTouchLayer = true;
		this._sumScore = 0;
		this._isMouseDown = false;
		this._guide = guide;

		let initScore = this._road.getStartGold(0) ? props.goldScore : 0;
		this.updateScore(initScore);

		//是否是新手
		if(this._guide == '1'){
			this.setGuide();
		}else{
			this.initTouch();
			this.registerEvent();
		}
	}    
	//新手引导
	setGuide(){
		this._road.setGuide();
		const guideLayer = this.guideLayer = new GuideLayer();
		this.addChild(guideLayer);
		this.guideLayer.show(1, {x:20,y: 650,guideText:props.guideText1},()=>{
			let posX = this._road.getMovePos();
			this.guideLayer.show(2, {x:posX + 20,y: 620,guideText:props.guideText2},()=>{
				this.initTouch();
				this.registerEvent();
			})
		});
	}
	//分数显示
	initLabScore(){
		const scoreBg = new engine.Sprite(getTextureByName('scoreBg'));
		scoreBg.x = getStage().width/2 - scoreBg.width/2; 
		scoreBg.y = 80;
		//this._scoreContainer.addChild(scoreBg);
	
		const scoreHint = new engine.Sprite(getTextureByName('scoreHint'));
		scoreHint.x = getStage().width/2 - scoreHint.width/2; 
		scoreHint.y = 40;
		this._scoreContainer.addChild(scoreHint);

		this.labScore = new ScoreLabel();
        this.labScore.fillColor = 0xff7646;
		this.labScore.size = 70;
		this.labScore.width = getStage().width;
		this.labScore.height = scoreBg.height;
		this.labScore.textAlign = engine.TEXT_ALIGN.CENTER;
		this.labScore.x = 0;
		this.labScore.y = scoreBg.y+10;
		this._scoreContainer.addChild(this.labScore);
    }
	registerEvent(){
        this._touchLayer.addEventListener(engine.MouseEvent.MOUSE_DOWN,this.onMouseDown,this);
        this._touchLayer.addEventListener(engine.MouseEvent.MOUSE_UP,this.onMouseUp,this);
	}
	removeListener(){
        this._touchLayer.removeEventListener(engine.MouseEvent.MOUSE_DOWN,this.onMouseDown,this);
        this._touchLayer.removeEventListener(engine.MouseEvent.MOUSE_UP,this.onMouseUp,this);
	}
	//触碰层
	initTouch(){
        this._touchLayer = new engine.Rect();
        this.addChild(this._touchLayer);
        this._touchLayer.width = getStage().width;
        this._touchLayer.height = getStage().height;
        this._touchLayer.x = 0;
        this._touchLayer.y = 0;
        this._touchLayer.alpha = 0;
	}
	setScoreShow(){

	}
	//鼠标事件
	onMouseDown(){
		if(this._isTouchLayer){
			this._isMouseDown = true;
			this._strut.onMouseDown(this._road.getFristPier(),this._road.getDistance(),this.goCallBcak.bind(this));
		}
	}
	onMouseUp(){
		if(this._isTouchLayer && this._isMouseDown){
			this._strut.onMouseUp();
			this._isMouseDown = false;
			this._isTouchLayer = false;
		}
	}
	//撑杆回调
	goCallBcak(isSuccess){
		if(isSuccess){
			console.log('成功了');
			let movePos = this._road.getMovePos();
			if(this._road.getStartGold(1,false)){
				this.updateScore(props.singleScore + props.goldScore);
			}else{
				this.updateScore(props.singleScore);
			}
			//人物前行
			this._player.setViewport(movePos,this.complete.bind(this));
			
		}else{
			console.log('失败了');
			this._player.setViewport(this._strut.getStrutHeight(),()=>{
				console.log('掉下去了');
				engine.globalEvent.dispatchEvent('dxbcyj-game-result',{score:this._sumScore});
			},this._road.getFristPier())
		}
	}
	//人物前行结束回调
	complete(){
		//关闭金币
		this._road.getStartGold(1);
		//获得位移距离
		let movePos = this._road.getMovePos();
		this._road.setViewport();
		this._backgroud.setViewport(movePos);
		//移动完成 可以再次操作
		this._player.setBackViewport(()=>{
			this._isTouchLayer = true;
		});
		this.closeStrut();
	}
	//重置撑杆
	closeStrut(){
		this._strut.rest();
	}
	//分数更新
	updateScore(score){
		this._sumScore += score;
		if(0 <= this._sumScore && this._sumScore <= props.bgFristScore){
			this.changeBg(0);
		}else if(props.bgFristScore < this._sumScore && this._sumScore <= props.bgSecondScore){
			this.changeBg(1);
		}else{
			this.changeBg(2);
		}
		this.labScore.updateScore(this._sumScore);
	}
	getScore(){
		return this._sumScore;
	}

	changeBg(index){
		if(this._backgroud.getBgIndex() != index){
			this._backgroud.changeBg(index);
		}
	}
}
