(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['dxbcyj-game'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	var ObjectPool = engine.ObjectPool;
	var Road = (function (_super) {
	    tslib.__extends(Road, _super);
	    function Road() {
	        return _super !== null && _super.apply(this, arguments) || this;
	    }
	    Road.prototype.setup = function () {
	        this.lastPos = 0;
	        this.addPier();
	    };
	    Road.prototype.getFristPier = function () {
	        return this.getChildAt(0).width;
	    };
	    Road.prototype.getDistance = function () {
	        var distance = [];
	        var pier1 = this.getChildAt(0);
	        var pier2 = this.getChildAt(1);
	        distance.push(pier2.x - pier1.x);
	        distance.push(pier2.width);
	        return distance;
	    };
	    Road.prototype.addPier = function () {
	        while (this.children.length < props.pierCount + 1) {
	            var childrenNum = this.children.length;
	            var randomPos = this.makeRandomFloat(props.pierMaxDistance, props.pierMinDistance);
	            var pier = ObjectPool.getObject('pier');
	            this.addChild(pier);
	            if (childrenNum == 0) {
	                pier.x = 0;
	            }
	            else {
	                pier.x = this.lastPos + randomPos;
	            }
	            this.lastPos = pier.x;
	        }
	    };
	    Road.prototype.moveAddPier = function () {
	        var randomPos = this.makeRandomFloat(props.pierMaxDistance, props.pierMinDistance);
	        var pier = ObjectPool.getObject('pier');
	        var lastChild = this.getChildAt(this.children.length - 1);
	        pier.x = lastChild.x + randomPos;
	        this.addChild(pier);
	    };
	    Road.prototype.makeRandomFloat = function (max, min) {
	        if (min === void 0) { min = 0; }
	        return Math.random() * (max - min) + min;
	    };
	    Road.prototype.setViewport = function () {
	        var _this = this;
	        var tmpMovepos = this.getMovePos();
	        this.children.forEach(function (item, index) {
	            _this.playTween(item, index, tmpMovepos);
	        });
	    };
	    Road.prototype.getMovePos = function () {
	        var movePos = this.getChildAt(1);
	        return movePos.x;
	    };
	    Road.prototype.playTween = function (item, index, tmpMovepos) {
	        var _this = this;
	        engine.Tween.get(item, { loop: false })
	            .to({ x: item.x - tmpMovepos }, props.pierMoveTime)
	            .call(function () {
	            if (_this.getChildIndex(item) == 0) {
	                engine.Tween.removeTweens(item);
	                _this.removeChild(item);
	                ObjectPool.recycleObject('pier', item);
	            }
	            if (index == 0) {
	                _this.moveAddPier();
	            }
	        });
	    };
	    Road.prototype.getStartGold = function (index, isClose) {
	        if (isClose === void 0) { isClose = true; }
	        var tmpNode = this.getChildAt(index);
	        var haveGold = tmpNode.haveGold;
	        if (haveGold && isClose) {
	            tmpNode.closeGold();
	        }
	        return haveGold;
	    };
	    Road.prototype.setGuide = function () {
	        var tmpNode = this.getChildAt(1);
	        if (!tmpNode.haveGold) {
	            tmpNode.children.forEach(function (item) {
	                if (item.name == 'gold') {
	                    item.visible = true;
	                }
	            });
	            tmpNode.haveGold = true;
	        }
	    };
	    return Road;
	}(engine.Container));

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function getStage() {
	    return engine.gameStage.stage;
	}
	function createSvga(name) {
	    var inst = new svga.Svga();
	    inst.source = engine.getAssetByName(name).uuid;
	    return inst;
	}

	var GuideLayer = (function (_super) {
	    tslib.__extends(GuideLayer, _super);
	    function GuideLayer() {
	        var _this = _super.call(this) || this;
	        _this._canClear = [];
	        _this.setup();
	        return _this;
	    }
	    GuideLayer.prototype.setup = function () {
	    };
	    GuideLayer.prototype.show = function (id, options, callback) {
	        this.visible = true;
	        this._callBack = callback ? callback : null;
	        if (!this.guideMask) {
	            this._options = options;
	            var _a = this.stage, width = _a.width, height = _a.height;
	            var guideMask = this.guideMask = new engine.Container();
	            var guideHole = this._guideHole = new engine.Image(getTextureByName('guide'));
	            guideHole.x = options.x;
	            guideHole.y = options.y;
	            guideHole.width = 250;
	            guideHole.height = 250;
	            guideHole.name = 'guideHole';
	            guideMask.addChild(guideHole);
	            this.createRect(guideMask, 0, 0, width, guideHole.y);
	            this.createRect(guideMask, 0, guideHole.y, guideHole.x, guideHole.height);
	            this.createRect(guideMask, guideHole.x + guideHole.width, guideHole.y, width - guideHole.x - guideHole.width, guideHole.height);
	            this.createRect(guideMask, 0, guideHole.y + guideHole.height, width, height - guideHole.y - guideHole.height);
	            this.guideStep(id);
	            var label = this.label = new engine.Label();
	            label.fillColor = 'white';
	            label.size = 30;
	            label.text = options.guideText;
	            label.x = (width - label.width) / 2;
	            label.y = guideHole.y + guideHole.height + 50;
	            label.textAlign = engine.TEXT_ALIGN.CENTER;
	            label.name = 'labHint';
	            guideMask.addChild(label);
	            this.addChild(guideMask);
	        }
	        this.once(engine.MouseEvent.CLICK, function () {
	            this.removeChild(this.guideMask);
	            this.guideMask = null;
	            if (this._callBack) {
	                this._callBack();
	            }
	        }, this);
	    };
	    GuideLayer.prototype.createRect = function (container, x, y, width, height) {
	        var rect = new engine.Rect();
	        rect.x = x;
	        rect.y = y;
	        rect.width = width;
	        rect.height = height;
	        rect.fillColor = 'black';
	        rect.alpha = 0.7;
	        container.addChild(rect);
	    };
	    GuideLayer.prototype.guideStep = function (id) {
	        if (id == 1) {
	            var guideHand = new engine.Image(getTextureByName('guideHand'));
	            guideHand.x = this._options.x + 300;
	            guideHand.y = this._options.y + 100;
	            this.guideMask.addChild(guideHand);
	            var rect = new engine.Rect();
	            rect.x = this._options.x + 200;
	            rect.y = this._options.y - 15;
	            rect.width = props.strutWidth;
	            rect.height = 200;
	            rect.fillColor = props.strutColor;
	            this.guideMask.addChild(rect);
	            this._canClear.push(guideHand);
	            this._canClear.push(rect);
	        }
	        if (id == 2) {
	            var know = new engine.Image(getTextureByName('know'));
	            know.x = (this.stage.width - know.width) / 2;
	            know.y = this._options.y + 400;
	            this.guideMask.addChild(know);
	            this._canClear.push(know);
	        }
	    };
	    return GuideLayer;
	}(engine.Container));

	var LoopComponent = (function (_super) {
	    tslib.__extends(LoopComponent, _super);
	    function LoopComponent() {
	        var _this = _super.call(this) || this;
	        _this.onceInfo = { width: 0, height: 0, count: 0 };
	        _this.loopInfo = { width: 0, height: 0, count: 0 };
	        _this.parts = [];
	        return _this;
	    }
	    LoopComponent.prototype.setup = function (parts, info) {
	        var _this = this;
	        parts.forEach(function (item, index) {
	            var part;
	            if (typeof item == 'string') {
	                part = new engine.Sprite(getTextureByName(item));
	            }
	            else if (item instanceof engine.Texture) {
	                part = new engine.Sprite(item);
	            }
	            else {
	                part = item;
	            }
	            _this.addChild(part);
	            _this.parts.push(part);
	            if (index == 0) {
	                info.width = part.width;
	                info.height = part.height;
	            }
	        });
	        info.count = parts.length;
	        this.setViewport(0, 0);
	    };
	    LoopComponent.prototype.changeBg = function (changName) {
	        this.parts.forEach(function (item, index) {
	            item.texture = getTextureByName(changName);
	        });
	    };
	    LoopComponent.prototype.setupLoop = function (resArr) {
	        this.setup(resArr, this.loopInfo);
	    };
	    LoopComponent.prototype.setViewport = function (x, y) {
	        if (y === void 0) { y = 0; }
	        var sizeField = y == 0 ? 'width' : 'height';
	        var posField = y == 0 ? 'x' : 'y';
	        var pos = y == 0 ? x : y;
	        var index;
	        var onceSize = this.onceInfo[sizeField];
	        var onceCount = this.onceInfo.count;
	        var loopCount = this.loopInfo.count;
	        var loopSize = this.loopInfo[sizeField];
	        index = onceSize == 0 ? -1 : Math.floor(pos / onceSize);
	        if (index < 0 || index >= onceCount) {
	            var loopIndex = Math.floor((pos - onceCount * onceSize) / this.loopInfo[sizeField]);
	            index = onceCount + loopIndex;
	        }
	        var formerIndex = index < onceCount ? index : (index) % loopCount + onceCount;
	        var latterIndex = index < onceCount ? index + 1 : (index - onceCount + 1) % loopCount + onceCount;
	        var former = this.parts[formerIndex];
	        var latter = this.parts[latterIndex];
	        if (!former || !latter) {
	            console.log(formerIndex, latterIndex);
	        }
	        former[posField] = -(pos - loopSize * (index < onceCount ? index : index - onceCount) - (index < onceCount ? 0 : onceCount * onceSize));
	        latter[posField] = former.x + (index < onceCount ? onceSize : loopSize);
	    };
	    return LoopComponent;
	}(engine.Container));

	var Background = (function (_super) {
	    tslib.__extends(Background, _super);
	    function Background() {
	        var _this = _super !== null && _super.apply(this, arguments) || this;
	        _this.partResHHL = ['hhl_after', 'hhl_front'];
	        _this.partResHB = ['hb_after', 'hb_front'];
	        _this.partResWH = ['wh_after', 'wh_front'];
	        _this.speeds = [];
	        _this.resArray = [];
	        _this.frameMovePos = 0;
	        return _this;
	    }
	    Background.prototype.initBg = function () {
	        this.sumMovePos = 0;
	        this.speeds.push(props.afterBGMoveSpeed);
	        this.speeds.push(props.frontBGMoveSpeed);
	        var bottomBg = new engine.Rect();
	        bottomBg.x = 0;
	        bottomBg.y = 0;
	        bottomBg.width = getStage().width;
	        bottomBg.height = 0;
	        bottomBg.fillColor = 0x75c9f5;
	        this.addChild(bottomBg);
	        this.resArray.push(this.partResHHL);
	        this.resArray.push(this.partResHB);
	        this.resArray.push(this.partResWH);
	        this._bgIndex = 0;
	        var parts = [];
	        for (var i = 0; i < 2; i++) {
	            var part = new LoopComponent();
	            part.setupLoop([
	                this.resArray[0][i],
	                this.resArray[0][i],
	            ]);
	            parts.push(part);
	            this.addChild(part);
	        }
	        parts[1].y = 200;
	    };
	    Background.prototype.setViewport = function (pos) {
	        this.needFrameSum = (props.pierMoveTime / 1000) * 60;
	        this.frameMovePos = pos / this.needFrameSum;
	        this.frameIndex = 0;
	        this.addEventListener(engine.Event.ENTER_FRAME, this.frameBack, this);
	    };
	    Background.prototype.frameBack = function () {
	        if (this.frameIndex < this.needFrameSum) {
	            for (var i = 0; i < 2; i++) {
	                var part = this.getChildAt(i + 1);
	                var speed = this.speeds[i];
	                var tmpPos = ((this.frameMovePos * this.frameIndex) + this.sumMovePos) * speed;
	                part.setViewport(tmpPos);
	            }
	            this.frameIndex++;
	        }
	        else {
	            this.sumMovePos += this.frameMovePos * this.needFrameSum;
	            this.frameIndex = 0;
	            this.removeEventListener(engine.Event.ENTER_FRAME, this.frameBack, this);
	        }
	    };
	    Background.prototype.changeBg = function (index) {
	        for (var i = 0; i < 2; i++) {
	            var part = this.getChildAt(i + 1);
	            part.changeBg(this.resArray[index][i]);
	            if (i == 1 && index == 1) {
	                part.y = 400;
	            }
	            if (i == 1 && index == 2) {
	                part.y = 250;
	            }
	        }
	        this._bgIndex = index;
	    };
	    Background.prototype.getBgIndex = function () {
	        return this._bgIndex;
	    };
	    return Background;
	}(engine.Container));

	var Pier = (function (_super) {
	    tslib.__extends(Pier, _super);
	    function Pier() {
	        var _this = _super.call(this) || this;
	        _this.bmp = new engine.Sprite();
	        _this.addChild(_this.bmp);
	        return _this;
	    }
	    Pier.prototype.init = function () {
	        var bmp = this.bmp;
	        bmp.alpha = 1;
	        bmp.texture = getTextureByName('pier');
	        bmp.x = 0;
	        bmp.y = bmp.height;
	        if (this.children.length < 2) {
	            var gold = new engine.Sprite();
	            gold.texture = getTextureByName('gold');
	            gold.name = 'gold';
	            this.addChild(gold);
	        }
	        this.setGoldPosX(bmp);
	        this.setShowGold();
	    };
	    Pier.prototype.setShowGold = function () {
	        var nodeGold = this.getChildByName('gold');
	        var randomWard = Math.random();
	        nodeGold.alpha = 1;
	        var isShow = randomWard < props.reward ? true : false;
	        nodeGold.visible = isShow;
	        this.haveGold = isShow;
	    };
	    Pier.prototype.setGoldPosX = function (bmp) {
	        var nodeGold = this.getChildByName('gold');
	        var pos = bmp.width / 2 - nodeGold.width / 2;
	        nodeGold.x = pos;
	        nodeGold.y = bmp.height - nodeGold.height - 50;
	        nodeGold.visible = false;
	    };
	    Pier.prototype.closeGold = function () {
	        var _this = this;
	        this.children.forEach(function (item) {
	            if (item.name == 'gold') {
	                item.anchorX = item.width / 2;
	                item.anchorY = item.height / 2;
	                engine.Tween.get(item, { loop: false })
	                    .to({ scaleX: 2.5, scaleY: 2.5 }, 200, engine.Ease.cubicOut)
	                    .to({ scaleX: 1, scaleY: 1, alpha: 0 }, 200, engine.Ease.cubicIn)
	                    .call(function () {
	                    item.visible = false;
	                    _this.haveGold = false;
	                });
	            }
	        });
	    };
	    return Pier;
	}(engine.Container));

	var Player = (function (_super) {
	    tslib.__extends(Player, _super);
	    function Player() {
	        return _super !== null && _super.apply(this, arguments) || this;
	    }
	    Player.prototype.initPlayer = function (pierWidth) {
	        this._container = new engine.Container();
	        this.addChild(this._container);
	        this.playerNode = createSvga('walk');
	        this._container.addChild(this.playerNode);
	        this.playerNode.y = 675;
	        this.playerNode.x = pierWidth / 2 - 80;
	        this.playerNode.play();
	    };
	    Player.prototype.setViewport = function (pos, callBack, pierWidth) {
	        var tmpPos = 0;
	        var isSuccess = false;
	        if (!pierWidth) {
	            tmpPos = pos;
	            isSuccess = true;
	        }
	        else {
	            tmpPos = pierWidth - this.playerNode.x + pos - 60;
	        }
	        this.playGoTween(tmpPos, callBack, isSuccess);
	    };
	    Player.prototype.playGoTween = function (pos, callBack, isSuccess) {
	        var _this = this;
	        engine.Tween.get(this._container, { loop: false })
	            .to({ x: pos }, props.playerMoveSpeed)
	            .call(function () {
	            engine.Tween.removeTweens(_this._container);
	            if (isSuccess) {
	                if (callBack) {
	                    callBack();
	                }
	            }
	            else {
	                _this.playDropTween(callBack);
	            }
	        });
	    };
	    Player.prototype.playDropTween = function (callBack) {
	        var _this = this;
	        engine.Tween.get(this._container, { loop: false })
	            .to({ y: 2000 }, 1000)
	            .call(function () {
	            engine.Tween.removeTweens(_this._container);
	            if (callBack) {
	                callBack();
	            }
	        });
	    };
	    Player.prototype.setBackViewport = function (callBack) {
	        var _this = this;
	        engine.Tween.get(this._container, { loop: false })
	            .to({ x: 0 }, props.pierMoveTime)
	            .call(function () {
	            engine.Tween.removeTweens(_this._container);
	            if (callBack) {
	                callBack();
	            }
	        });
	    };
	    return Player;
	}(engine.Container));

	var Strut = (function (_super) {
	    tslib.__extends(Strut, _super);
	    function Strut() {
	        return _super !== null && _super.apply(this, arguments) || this;
	    }
	    Strut.prototype.init = function () {
	        this._strut = new engine.Rect();
	        this.addChild(this._strut);
	        this._strut.width = props.strutWidth;
	        this._strut.y = 833;
	        this._strut.fillColor = props.strutColor;
	        this._strut.rotation = 180;
	    };
	    Strut.prototype.onMouseDown = function (pierWidth, distance, callBack) {
	        this._strut.x = pierWidth - 60;
	        this._distance = distance;
	        this._callBack = callBack;
	        this._strut.visible = true;
	        this.addEventListener(engine.Event.ENTER_FRAME, this.frameStrut, this);
	    };
	    Strut.prototype.onMouseUp = function () {
	        var _this = this;
	        this.removeEventListener(engine.Event.ENTER_FRAME, this.frameStrut, this);
	        setTimeout(function () {
	            _this.strutRotation();
	        }, 200);
	    };
	    Strut.prototype.strutRotation = function () {
	        var _this = this;
	        engine.Tween.get(this._strut, { loop: false })
	            .to({ rotation: 270 }, props.strutRotationSpeed)
	            .call(function () {
	            _this.judgeResult();
	            engine.Tween.removeTweens(_this._strut);
	        });
	    };
	    Strut.prototype.judgeResult = function () {
	        var isSuccess = false;
	        if (this._distance[0] - this._distance[1] + 100 <= this._strut.height && this._strut.height <= this._distance[0] + 20) {
	            isSuccess = true;
	        }
	        if (this._callBack) {
	            this._callBack(isSuccess);
	        }
	    };
	    Strut.prototype.frameStrut = function () {
	        if (this._strut.height < 1000) {
	            this._strut.height += props.strutUpSpeed;
	        }
	    };
	    Strut.prototype.rest = function () {
	        this._strut.width = props.strutWidth;
	        this._strut.y = 833;
	        this._strut.fillColor = props.strutColor;
	        this._strut.rotation = 180;
	        this._strut.height = 0;
	        this._strut.visible = false;
	    };
	    Strut.prototype.getStrutHeight = function () {
	        var distance = this._strut.height > 1000 ? 1000 : this._strut.height;
	        return distance;
	    };
	    return Strut;
	}(engine.Container));

	var ScoreLabel = (function (_super) {
	    tslib.__extends(ScoreLabel, _super);
	    function ScoreLabel() {
	        return _super !== null && _super.apply(this, arguments) || this;
	    }
	    ScoreLabel.prototype.updateScore = function (score, animation) {
	        if (animation === void 0) { animation = true; }
	        this._value = score;
	        if (animation && this._tmp) {
	            this.animationUpdate();
	        }
	        else {
	            this.updateLocal(score);
	        }
	    };
	    ScoreLabel.prototype.animationUpdate = function () {
	        var _this = this;
	        var tmpInterval = setInterval(function () {
	            _this._tmp += 1;
	            if (_this._tmp <= _this._value) {
	                _this.text = _this._tmp;
	            }
	            else {
	                _this._tmp = _this._value;
	                clearInterval(tmpInterval);
	            }
	        }, 50);
	    };
	    ScoreLabel.prototype.updateLocal = function (v) {
	        this._tmp = v;
	        this.text = v;
	    };
	    return ScoreLabel;
	}(engine.Label));

	var ObjectPool$1 = engine.ObjectPool;
	var PoolName = 'pier';
	ObjectPool$1.registerPool(PoolName, function () {
	    return new Pier();
	}, function (item, data) {
	    item.init();
	});
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.moveX = 0;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        this._backgroud = new Background();
	        this.addChild(this._backgroud);
	        this._backgroud.initBg();
	        var road = this._road = new Road();
	        this.addChild(road);
	        road.setup();
	        var pierWidth = this._road.getFristPier();
	        var player = this._player = new Player();
	        this.addChild(player);
	        player.initPlayer(pierWidth);
	        var strut = this._strut = new Strut();
	        this.addChild(strut);
	        strut.init();
	        this._scoreContainer = new engine.Container();
	        this.addChild(this._scoreContainer);
	        this.initLabScore();
	    };
	    GameView.prototype.start = function (guide) {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var initScore;
	            return tslib.__generator(this, function (_a) {
	                this._isTouchLayer = true;
	                this._sumScore = 0;
	                this._isMouseDown = false;
	                this._guide = guide;
	                initScore = this._road.getStartGold(0) ? props.goldScore : 0;
	                this.updateScore(initScore);
	                if (this._guide == '1') {
	                    this.setGuide();
	                }
	                else {
	                    this.initTouch();
	                    this.registerEvent();
	                }
	                return [2];
	            });
	        });
	    };
	    GameView.prototype.setGuide = function () {
	        var _this = this;
	        this._road.setGuide();
	        var guideLayer = this.guideLayer = new GuideLayer();
	        this.addChild(guideLayer);
	        this.guideLayer.show(1, { x: 20, y: 650, guideText: props.guideText1 }, function () {
	            var posX = _this._road.getMovePos();
	            _this.guideLayer.show(2, { x: posX + 20, y: 620, guideText: props.guideText2 }, function () {
	                _this.initTouch();
	                _this.registerEvent();
	            });
	        });
	    };
	    GameView.prototype.initLabScore = function () {
	        var scoreBg = new engine.Sprite(getTextureByName('scoreBg'));
	        scoreBg.x = getStage().width / 2 - scoreBg.width / 2;
	        scoreBg.y = 80;
	        var scoreHint = new engine.Sprite(getTextureByName('scoreHint'));
	        scoreHint.x = getStage().width / 2 - scoreHint.width / 2;
	        scoreHint.y = 40;
	        this._scoreContainer.addChild(scoreHint);
	        this.labScore = new ScoreLabel();
	        this.labScore.fillColor = 0xff7646;
	        this.labScore.size = 70;
	        this.labScore.width = getStage().width;
	        this.labScore.height = scoreBg.height;
	        this.labScore.textAlign = engine.TEXT_ALIGN.CENTER;
	        this.labScore.x = 0;
	        this.labScore.y = scoreBg.y + 10;
	        this._scoreContainer.addChild(this.labScore);
	    };
	    GameView.prototype.registerEvent = function () {
	        this._touchLayer.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
	        this._touchLayer.addEventListener(engine.MouseEvent.MOUSE_UP, this.onMouseUp, this);
	    };
	    GameView.prototype.removeListener = function () {
	        this._touchLayer.removeEventListener(engine.MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
	        this._touchLayer.removeEventListener(engine.MouseEvent.MOUSE_UP, this.onMouseUp, this);
	    };
	    GameView.prototype.initTouch = function () {
	        this._touchLayer = new engine.Rect();
	        this.addChild(this._touchLayer);
	        this._touchLayer.width = getStage().width;
	        this._touchLayer.height = getStage().height;
	        this._touchLayer.x = 0;
	        this._touchLayer.y = 0;
	        this._touchLayer.alpha = 0;
	    };
	    GameView.prototype.setScoreShow = function () {
	    };
	    GameView.prototype.onMouseDown = function () {
	        if (this._isTouchLayer) {
	            this._isMouseDown = true;
	            this._strut.onMouseDown(this._road.getFristPier(), this._road.getDistance(), this.goCallBcak.bind(this));
	        }
	    };
	    GameView.prototype.onMouseUp = function () {
	        if (this._isTouchLayer && this._isMouseDown) {
	            this._strut.onMouseUp();
	            this._isMouseDown = false;
	            this._isTouchLayer = false;
	        }
	    };
	    GameView.prototype.goCallBcak = function (isSuccess) {
	        var _this = this;
	        if (isSuccess) {
	            console.log('成功了');
	            var movePos = this._road.getMovePos();
	            if (this._road.getStartGold(1, false)) {
	                this.updateScore(props.singleScore + props.goldScore);
	            }
	            else {
	                this.updateScore(props.singleScore);
	            }
	            this._player.setViewport(movePos, this.complete.bind(this));
	        }
	        else {
	            console.log('失败了');
	            this._player.setViewport(this._strut.getStrutHeight(), function () {
	                console.log('掉下去了');
	                engine.globalEvent.dispatchEvent('dxbcyj-game-result', { score: _this._sumScore });
	            }, this._road.getFristPier());
	        }
	    };
	    GameView.prototype.complete = function () {
	        var _this = this;
	        this._road.getStartGold(1);
	        var movePos = this._road.getMovePos();
	        this._road.setViewport();
	        this._backgroud.setViewport(movePos);
	        this._player.setBackViewport(function () {
	            _this._isTouchLayer = true;
	        });
	        this.closeStrut();
	    };
	    GameView.prototype.closeStrut = function () {
	        this._strut.rest();
	    };
	    GameView.prototype.updateScore = function (score) {
	        this._sumScore += score;
	        if (0 <= this._sumScore && this._sumScore <= props.bgFristScore) {
	            this.changeBg(0);
	        }
	        else if (props.bgFristScore < this._sumScore && this._sumScore <= props.bgSecondScore) {
	            this.changeBg(1);
	        }
	        else {
	            this.changeBg(2);
	        }
	        this.labScore.updateScore(this._sumScore);
	    };
	    GameView.prototype.getScore = function () {
	        return this._sumScore;
	    };
	    GameView.prototype.changeBg = function (index) {
	        if (this._backgroud.getBgIndex() != index) {
	            this._backgroud.changeBg(index);
	        }
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('dxbcyj-game-start', _this.start, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.start = function (event) {
	        this._gameView.start(event.data.guide);
	    };
	    return GameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map