/**
 * Created by rockyl on 2020-02-02.
 *
 * 掉落物品
 */
import {getTextureByName} from "./utils";
import {props} from "../props";

export class Goods extends engine.Container {
	private _body:engine.Rect
	private _toY;

	constructor() {
		super();

		let body
		body = this._body =new engine.Rect()
		
		// let randomNum = Math.floor(Math.random() * 3)		
		// console.log('雨滴' + randomNum);
		
		let rain = new engine.Sprite(getTextureByName('金币'));
		let rain1 = new engine.Sprite(getTextureByName('粽子'));
		rain["npcType"]="rain0"
		rain1["npcType"]="rain1"
		let stone = new engine.Sprite(getTextureByName('木头'));
		stone["npcType"]="stone"
		let boom = new engine.Sprite(getTextureByName('石块'));
		boom["npcType"]="boom"

		rain.visible=false;
		rain1.visible=false;
		stone.visible=false;
		boom.visible=false;

		rain.anchorX=rain.width/2
		rain1.anchorX=rain1.width/2
		stone.anchorX=stone.width/2
		boom.anchorX=boom.width/2

		rain.anchorY=rain.height/2
		rain1.anchorY=rain1.height/2
		stone.anchorY=stone.height/2
		boom.anchorY=boom.height/2

		body.addChild(rain)
		body.addChild(rain1)
		body.addChild(stone)
		body.addChild(boom)
		
		this.addChild(body);
		body.width=.0001;
		body.height=.0001;
		body.mouseEnabled=false;
	}


	getRandomNumberByRange(start, end) {
		return Math.floor(Math.random() * (end - start) + start)
	}

	reset() {
		this["lifeState"]=true;
		this.visible = true;
		this.rotation = 0;
		this.anchorOffsetY = 0;
		if(this.width<=0){
			this.anchorX=50;
		}else{
			this.anchorX=this.width/2;
		}
		
		this.anchorY=this.height/2;
		this.scaleX=this.scaleY=1;
		this.y = 0;
		this.x = ((750-props.maxNpcBound)-120)*Math.random()+30+props.maxNpcBound;
		this.rotation = 0;
		let random=Math.random()
		if(typeof (props.goodsProbability) == 'string'){
			props.goodsProbability=props.goodsProbability.split(',').map((i: string) => +i)
			console.log(props.goodsProbability);
		}
		if(random<props.goodsProbability[0]){
			this.showNpc("rain0")
		}else if(random>=props.goodsProbability[0]&&random<=(props.goodsProbability[0]+props.goodsProbability[1])){
			this.showNpc("rain1")
		}else if(random>=(props.goodsProbability[0]+props.goodsProbability[1])&&random<=(props.goodsProbability[0]+props.goodsProbability[1]+props.goodsProbability[2])){
			this.showNpc("stone")
		}else if(random>(props.goodsProbability[0]+props.goodsProbability[1]+props.goodsProbability[2])){
			this.showNpc("boom")
		}
	}


	showNpc(type){
		for(let i=0;i<this._body.children.length;i++){
			this._body.children[i].visible=false;
			this._body.children[i].mouseEnabled=false;
		}		
		for(let i=0;i<this._body.children.length;i++){
			if(this._body.children[i]["npcType"]==type){
				this["npcType"]=type
				this._body.children[i].visible=true;
				this._body.children[i].mouseEnabled=false;
			}
		}
		
	}

	set anchorOffsetY(v) {
		this._body.y = v;
	}
}
