(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['dragon-boat-race'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(getAssetByName(name).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + getAssetByName(name).uuid;
	    return inst;
	}
	//# sourceMappingURL=utils.js.map

	var Goods = (function (_super) {
	    tslib.__extends(Goods, _super);
	    function Goods() {
	        var _this = _super.call(this) || this;
	        var body;
	        body = _this._body = new engine.Rect();
	        var rain = new engine.Sprite(getTextureByName('金币'));
	        var rain1 = new engine.Sprite(getTextureByName('粽子'));
	        rain["npcType"] = "rain0";
	        rain1["npcType"] = "rain1";
	        var stone = new engine.Sprite(getTextureByName('木头'));
	        stone["npcType"] = "stone";
	        var boom = new engine.Sprite(getTextureByName('石块'));
	        boom["npcType"] = "boom";
	        rain.visible = false;
	        rain1.visible = false;
	        stone.visible = false;
	        boom.visible = false;
	        rain.anchorX = rain.width / 2;
	        rain1.anchorX = rain1.width / 2;
	        stone.anchorX = stone.width / 2;
	        boom.anchorX = boom.width / 2;
	        rain.anchorY = rain.height / 2;
	        rain1.anchorY = rain1.height / 2;
	        stone.anchorY = stone.height / 2;
	        boom.anchorY = boom.height / 2;
	        body.addChild(rain);
	        body.addChild(rain1);
	        body.addChild(stone);
	        body.addChild(boom);
	        _this.addChild(body);
	        body.width = .0001;
	        body.height = .0001;
	        body.mouseEnabled = false;
	        return _this;
	    }
	    Goods.prototype.getRandomNumberByRange = function (start, end) {
	        return Math.floor(Math.random() * (end - start) + start);
	    };
	    Goods.prototype.reset = function () {
	        this["lifeState"] = true;
	        this.visible = true;
	        this.rotation = 0;
	        this.anchorOffsetY = 0;
	        if (this.width <= 0) {
	            this.anchorX = 50;
	        }
	        else {
	            this.anchorX = this.width / 2;
	        }
	        this.anchorY = this.height / 2;
	        this.scaleX = this.scaleY = 1;
	        this.y = 0;
	        this.x = ((750 - props.maxNpcBound) - 120) * Math.random() + 30 + props.maxNpcBound;
	        this.rotation = 0;
	        var random = Math.random();
	        if (typeof (props.goodsProbability) == 'string') {
	            props.goodsProbability = props.goodsProbability.split(',').map(function (i) { return +i; });
	            console.log(props.goodsProbability);
	        }
	        if (random < props.goodsProbability[0]) {
	            this.showNpc("rain0");
	        }
	        else if (random >= props.goodsProbability[0] && random <= (props.goodsProbability[0] + props.goodsProbability[1])) {
	            this.showNpc("rain1");
	        }
	        else if (random >= (props.goodsProbability[0] + props.goodsProbability[1]) && random <= (props.goodsProbability[0] + props.goodsProbability[1] + props.goodsProbability[2])) {
	            this.showNpc("stone");
	        }
	        else if (random > (props.goodsProbability[0] + props.goodsProbability[1] + props.goodsProbability[2])) {
	            this.showNpc("boom");
	        }
	    };
	    Goods.prototype.showNpc = function (type) {
	        for (var i = 0; i < this._body.children.length; i++) {
	            this._body.children[i].visible = false;
	            this._body.children[i].mouseEnabled = false;
	        }
	        for (var i = 0; i < this._body.children.length; i++) {
	            if (this._body.children[i]["npcType"] == type) {
	                this["npcType"] = type;
	                this._body.children[i].visible = true;
	                this._body.children[i].mouseEnabled = false;
	            }
	        }
	    };
	    Object.defineProperty(Goods.prototype, "anchorOffsetY", {
	        set: function (v) {
	            this._body.y = v;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Goods;
	}(engine.Container));
	//# sourceMappingURL=Goods.js.map

	var ObjectPool = engine.ObjectPool;
	var PoolName = 'goods';
	ObjectPool.registerPool(PoolName, function () {
	    return new Goods();
	}, function (item, data) {
	    item.reset();
	});
	//# sourceMappingURL=object-pool-init.js.map

	var ObjectPool$1 = engine.ObjectPool;
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.goodsItems = [];
	        _this.moveCatchX = 0;
	        _this.playerCatchX = 0;
	        _this.onDownStage = function (e) {
	            _this.moveCatchX = e.localX;
	            _this.playerCatchX = _this.player.x;
	        };
	        _this.onMoveStage = function (e) {
	            var maxStageBound = props.maxStageBound;
	            if (_this.gameIng) {
	                var playerX = _this.playerCatchX + (e.localX - _this.moveCatchX);
	                if (playerX < maxStageBound) {
	                    _this.player.x = maxStageBound;
	                }
	                else if (playerX + _this.player.width + maxStageBound > 750) {
	                    _this.player.x = 750 - maxStageBound - _this.player.width;
	                }
	                else {
	                    _this.player.x = playerX;
	                }
	            }
	        };
	        _this.onOutStage = function (e) {
	            _this.moveCatchX = 0;
	        };
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        var _this = this;
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        this.bg = new engine.Container();
	        this.bg.mouseEnabled = false;
	        this.addChild(this.bg);
	        this.NpcBg = new engine.Container();
	        this.NpcBg.alpha = 1;
	        this.NpcBg.width = 0;
	        this.NpcBg.height = 0;
	        this.addChild(this.NpcBg);
	        this.player = new engine.Container();
	        this.player.mouseEnabled = false;
	        this.player.mouseChildren = false;
	        this.labelScore = new engine.BitmapText();
	        this.labelScore.font = props.fontName;
	        this.labelScore.scaleX = this.labelScore.scaleY = 1;
	        this.addChild(this.labelScore);
	        this.waterSvga = createSvga("碰到金币svga");
	        this.water2Svga = createSvga("碰到粽子svga");
	        this.boomSvga = createSvga("碰到石头svga");
	        this.playerSvgaReset = new engine.Sprite(getTextureByName('玩家静止'));
	        this.playerSvgaRun = createSvga("玩家滑动");
	        this.playerSvgaOver = createSvga("玩家翻船");
	        this.bg1 = new engine.Sprite(getTextureByName('循环背景1'));
	        this.bg2 = new engine.Sprite(getTextureByName('循环背景2'));
	        this.bg3 = new engine.Sprite(getTextureByName('循环背景1'));
	        this.bg4 = new engine.Sprite(getTextureByName('循环背景2'));
	        this.player.addChild(this.playerSvgaReset);
	        this.player.addChild(this.playerSvgaRun);
	        this.player.addChild(this.playerSvgaOver);
	        this.addChild(this.waterSvga);
	        this.addChild(this.water2Svga);
	        this.addChild(this.boomSvga);
	        this.addChild(this.player);
	        this.bg.addChild(this.bg1);
	        this.bg.addChild(this.bg2);
	        this.bg.addChild(this.bg3);
	        this.bg.addChild(this.bg4);
	        this.waterSvga.visible = false;
	        this.water2Svga.visible = false;
	        this.boomSvga.visible = false;
	        this.setPlayState(this.playerSvgaReset);
	        this.visible = false;
	        setTimeout(function () {
	            _this.visible = true;
	            _this.player.x = props.playerPositionX;
	            _this.player.y = props.playerPositionY;
	            _this.playerSvgaRun.x = props.playerRunPosition3Offset[0];
	            _this.playerSvgaRun.y = props.playerRunPosition3Offset[1];
	            _this.playerSvgaOver.x = props.playerOverPosition3Offset[0];
	            _this.playerSvgaOver.y = props.playerOverPosition3Offset[1];
	            _this.bg1.y = 0;
	            _this.bg2.y = _this.bg1.height;
	            _this.bg3.y = _this.bg1.height + _this.bg2.height;
	            _this.bg4.y = _this.bg1.height + _this.bg2.height + _this.bg3.height;
	            engine.Tween.get(_this.playerSvgaReset, { loop: true })
	                .to({ y: 10 }, 500)
	                .to({ y: 0 }, 500)
	                .to({ y: 10 }, 500)
	                .call(function () { });
	        }, 300);
	        this.rectBg = new engine.Container();
	        this.rectBg.alpha = 0;
	        this.rectBg.width = 750;
	        this.rectBg.height = 1624;
	        this.addChild(this.rectBg);
	        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDownStage, this);
	        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onMoveStage, this);
	        this.rectBg.addEventListener(engine.MouseEvent.MOUSE_OUT, this.onOutStage, this);
	        this.rectBg.addEventListener(engine.Event.ENTER_FRAME, this.enterFrame, this);
	    };
	    GameView.prototype.setBoomPosition = function (svga, callback) {
	        svga.x = this.player.x;
	        svga.y = this.player.y;
	        if (svga == this.waterSvga) {
	            svga.x += props.boomPosition1Offset[0];
	            svga.y += props.boomPosition1Offset[1];
	        }
	        else if (svga == this.water2Svga) {
	            svga.x += props.boomPosition2Offset[0];
	            svga.y += props.boomPosition2Offset[1];
	        }
	        else if (svga == this.boomSvga) {
	            svga.x += props.boomPosition3Offset[0];
	            svga.y += props.boomPosition3Offset[1];
	        }
	        svga.visible = true;
	        svga.play(true, false);
	        svga.once(engine.Event.END_FRAME, function () {
	            svga.visible = false;
	            if (callback) {
	                callback();
	            }
	        }, this);
	    };
	    GameView.prototype.enterFrame = function () {
	        if (this.bg.y >= 0) {
	            this.bg.y = -this.bg3.y;
	        }
	        if (this.gameIng) {
	            this.bg.y += (4 * this.speed);
	        }
	    };
	    GameView.prototype.reset = function () {
	        this.recycleGoods();
	        this.score = 0;
	        this.speed = props.speed;
	        this.bg.y = -this.bg3.y;
	        this.player.anchorY = this.player.height / 2;
	        this.player.anchorX = this.player.width / 2;
	        this.player.x = props.playerPositionX;
	        this.player.y = props.playerPositionY;
	        this.setPlayState(this.playerSvgaReset);
	    };
	    GameView.prototype.setPlayState = function (svga) {
	        this.playerSvgaReset.visible = false;
	        this.playerSvgaRun.visible = false;
	        this.playerSvgaOver.visible = false;
	        console.log(svga);
	        svga.visible = true;
	        if (svga == this.playerSvgaOver) {
	            svga.play(false, false);
	            svga.once(engine.Event.END_FRAME, function () {
	            }, this);
	        }
	        else if (svga == this.playerSvgaRun) {
	            svga.play();
	        }
	    };
	    GameView.prototype.start = function () {
	        var _this = this;
	        this.gameIng = true;
	        this.creatNpc();
	        this.beginNpc();
	        this.countdown = props.countDown;
	        this.setPlayState(this.playerSvgaRun);
	        this.countdownTimer = setInterval(function () {
	            if (_this.gameIng) {
	                if (_this.countdown > 0) {
	                    engine.globalEvent.dispatchEvent('dragon-boat-race-time-update', {
	                        time: _this.countdown,
	                    });
	                    _this.countdown -= 1;
	                }
	                else {
	                    engine.globalEvent.dispatchEvent('dragon-boat-race-game-over', {
	                        score: _this.score,
	                        reason: 1
	                    });
	                    _this.died();
	                }
	                _this.score += Math.round(_this.speed * props.runScore);
	                engine.globalEvent.dispatchEvent('dragon-boat-race-score-update', {
	                    score: _this.score,
	                });
	            }
	        }, 1000);
	    };
	    GameView.prototype.beginNpc = function () {
	        var _this = this;
	        this.timer = setTimeout(function () {
	            if (_this.gameIng) {
	                _this.speed += props.acceleratedSpeed;
	                _this.speed += props.acceleratedSpeed;
	                if (_this.speed > props.maxSpeed) {
	                    _this.speed = props.maxSpeed;
	                }
	                _this.creatNpc();
	            }
	            _this.beginNpc();
	        }, 2000 / this.speed);
	    };
	    GameView.prototype.pause = function () {
	        this.gameIng = false;
	    };
	    GameView.prototype.revive = function () {
	        this.gameIng = true;
	    };
	    GameView.prototype.resume = function () {
	        this.reset();
	        this.start();
	    };
	    GameView.prototype.creatNpc = function () {
	        var _this = this;
	        var goods = this._goods = ObjectPool$1.getObject(PoolName);
	        this.goodsItems.push(goods);
	        this.NpcBg.addChild(goods);
	        goods.addEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"] = function () {
	            if (goods.y > 1624) {
	                _this.removeNpc(goods);
	            }
	            else {
	                if (_this.gameIng) {
	                    goods.y += (4 * _this.speed);
	                    if (goods["lifeState"] && _this.hasHit(_this.player, goods)) {
	                        goods["lifeState"] = false;
	                        if (goods["npcType"] == "rain0") {
	                            console.log("碰到雨滴");
	                            _this.score += props.rainScore;
	                            if (_this.score < 0) {
	                                _this.score = 0;
	                            }
	                            _this.setBoomPosition(_this.waterSvga);
	                            engine.Tween.get(goods, null, null, true)
	                                .to({ scaleX: 0, scaleY: 0 }, 200)
	                                .call(function () { _this.removeNpc(goods); });
	                        }
	                        else if (goods["npcType"] == "rain1") {
	                            console.log("碰到雨滴");
	                            _this.score += props.rain2Score;
	                            if (_this.score < 0) {
	                                _this.score = 0;
	                            }
	                            _this.setBoomPosition(_this.water2Svga);
	                            engine.Tween.get(goods, null, null, true)
	                                .to({ scaleX: 0, scaleY: 0 }, 200)
	                                .call(function () { _this.removeNpc(goods); });
	                        }
	                        else if (goods["npcType"] == "boom" || goods["npcType"] == "stone") {
	                            console.log("碰到炸弹");
	                            _this.setBoomPosition(_this.boomSvga, function () {
	                                engine.globalEvent.dispatchEvent('dragon-boat-race-game-over', {
	                                    score: _this.score,
	                                    reason: 2
	                                });
	                                _this.died();
	                            });
	                            _this.setPlayState(_this.playerSvgaOver);
	                            _this.pause();
	                        }
	                        engine.globalEvent.dispatchEvent('dragon-boat-race-score-update', {
	                            score: _this.score,
	                        });
	                    }
	                }
	            }
	        }, this);
	    };
	    GameView.prototype.died = function () {
	        this.score = 0;
	        this.pause();
	    };
	    GameView.prototype.removeNpc = function (goods) {
	        this.NpcBg.removeChild(goods);
	        ObjectPool$1.recycleObject(PoolName, goods);
	        goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
	        var index = this.goodsItems.indexOf(goods);
	        if (index > -1) {
	            this.goodsItems.splice(index, 1);
	        }
	    };
	    GameView.prototype.recycleGoods = function () {
	        clearTimeout(this.timer);
	        clearInterval(this.countdownTimer);
	        for (var _i = 0, _a = this.goodsItems; _i < _a.length; _i++) {
	            var goods = _a[_i];
	            if (goods) {
	                this.NpcBg.removeChild(goods);
	                ObjectPool$1.recycleObject(PoolName, goods);
	                goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
	            }
	        }
	        this.goodsItems = [];
	    };
	    GameView.prototype.hasHit = function (a, b) {
	        var playerH = a.height;
	        var playerW = a.width;
	        var playerX = a.x;
	        if (props.playerHeight) {
	            playerH = props.playerHeight;
	        }
	        if (props.playerWidth) {
	            playerW = props.playerWidth;
	            playerX = a.x + (a.width - props.playerWidth) / 2;
	        }
	        if (Math.abs((playerX + playerW / 2) - (b.x + b.width / 2)) < playerW / 2 + b.width / 2
	            &&
	                Math.abs((a.y + playerH / 1.3) - (b.y + b.height / 2)) < playerH / 2 + b.height / 2) {
	            return true;
	        }
	        else {
	            return false;
	        }
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('dragon-boat-race-reset', _this.reset, _this);
	        engine.globalEvent.addEventListener('dragon-boat-race-start', _this.start, _this);
	        engine.globalEvent.addEventListener('dragon-boat-race-pause', _this.pause, _this);
	        engine.globalEvent.addEventListener('dragon-boat-race-resume', _this.resume, _this);
	        engine.globalEvent.addEventListener('dragon-boat-race-revive', _this.revive, _this);
	        engine.globalEvent.addEventListener('dragon-boat-race-clear', _this.clear, _this);
	        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	        this._status = 1;
	        this._gameView.start();
	    };
	    GameWrapper.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    GameWrapper.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    GameWrapper.prototype.revive = function () {
	        this._gameView.revive();
	    };
	    GameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    GameWrapper.prototype.onTap = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map