/**
 * Created by renjianfeng on 2020-03-13.
 */

const customId = 'dragon-boat-race';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const {props: propsOption, assets} = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
			properties: {
				x: 0,
				y: 0,
			}
		}],
		customs: []
	}, null, function () {
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);

		setTimeout(() => {
			engine.globalEvent.dispatchEvent('dragon-boat-race-reset', {
				"goodsProbability": "0.3,0.2,0.3,0.2",
				"countDown": 30,
				"acceleratedSpeed":0.1
			});
			engine.globalEvent.dispatchEvent('dragon-boat-race-start');
		}, 1000);
	});
	engine.globalEvent.addEventListener('dragon-boat-race-time-update', (e) => {
		console.log(e.type, e.data);
	});
	engine.globalEvent.addEventListener('dragon-boat-race-score-update', (e) => {
		console.log(e.type, e.data);
	});
	engine.globalEvent.addEventListener('dragon-boat-race-game-over', (e) => {
		console.log(e.type, e.data);
	});
}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
