import { getTextureByName } from "./utils";
import GameView from './GameView';
import { props } from "../props";
export class FrontBoxs extends engine.Container {
  //盒子1
  private box1: engine.Container;
  //盒子2
  private box2: engine.Container;
  //盒子3 
  private box3: engine.Container;
  //盒子4
  private box4: engine.Container;
  //盒子5
  private box5: engine.Container;
  // 需隐藏的盒子
  private hideBox: engine.Container;
  private frontBoxs=[];
  public GameView: GameView;
  constructor() {
    super();
  }
  setup() {
    let initX , initY = 0;
    for(let i = 0; i < props.dollNum; i++) {
      if (!new engine.Sprite(getTextureByName('frontbox_' + i))) {
        return;
      }

      this.frontBoxs[i] = new engine.Sprite(getTextureByName('frontbox_'+i));
      initX = this.frontBoxs[0].x = props.frontInitX;
      initY = this.frontBoxs[0].y = props.frontInitY;
      this.frontBoxs[i]['npcType'] = 'box'+i;
    }
    this.frontBoxs[props.dollNum] = new engine.Sprite(getTextureByName('frontbox_0'));
    this.frontBoxs[props.dollNum]['npcType'] = 'box' + props.dollNum;
    console.log(this.frontBoxs);
    
    for(let i = 0; i < this.frontBoxs.length; i++) {
      if(i == 0) {
        this.frontBoxs[i].x = initX ;
      } else {
        this.frontBoxs[i].x = this.frontBoxs[i - 1].x - this.frontBoxs[0].width - props.frontmargin;
      }
      console.log(this.frontBoxs[i].x);
      this.frontBoxs[i].y = initY;
      this.addChild(this.frontBoxs[i]);
      console.log('aaa', this.frontBoxs[i].x);
    }
    // console.log(this.frontBoxs);
    this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
  }
  frameMove() {
    this.frontBoxs.forEach((item, index) => {
      item.x += props.moveSpeed;
      if (item.x <= 0 && !item.visible) {
        item.visible = true;
      }
      if (item.x >= 750) {
        //let lastitem = this.frontBoxs.shift();
        let tmpIndex = 0;
        if (index <= 0) {
          tmpIndex = this.frontBoxs.length - 1;
        } else {
          tmpIndex = index - 1;
        }

        item.x = this.frontBoxs[tmpIndex].x - this.frontBoxs[0].width - props.frontmargin;

        if (!this.GameView.getMoveX() && item.x <= 0 && this.GameView.startstatus) {
          this.GameView.setMoveX((370 - item.x - 13) / props.moveSpeed, item);
          this.hideBox = item;
        }
        //this.frontBoxs.push(lastitem);
      }
    })
  }
  stop() {
    // this.removeEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
  }
  showHidePrizeBox(isshow) {
    this.hideBox.visible = isshow
  }
}