import { getTextureByName } from "./utils";
import { props } from "../props";
export class BackBoxs extends engine.Container {
  private backBoxs=[];
  constructor() {
    super();
  }
  setup() {
    let initX , initY = 0;
    for (let i = 0; i < props.dollNum; i++) {
      this.backBoxs[i] = new engine.Sprite(getTextureByName('backbox_' + i));
      initX = this.backBoxs[0].x = props.backInitX;
      initY = this.backBoxs[0].y = props.backInitY - props.initOffsetTop;
      this.backBoxs[i]['npcType'] = 'box' + i;
    }
    this.backBoxs[props.dollNum] = new engine.Sprite(getTextureByName('backbox_0'));
    this.backBoxs[props.dollNum]['npcType'] = 'box' + props.dollNum;
    for (let i = 0; i < this.backBoxs.length; i++) {
      if(i == 0) {
        this.backBoxs[i].x = initX;
      } else {
        this.backBoxs[i].x = this.backBoxs[i - 1].x + this.backBoxs[i].width + props.backmargin;
      }
      this.backBoxs[i].y = initY;
      
      this.addChild(this.backBoxs[i]);
    }
    this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
  }
  frameMove() {
    this.backBoxs.forEach((item) => {
      item.x -= props.moveSpeed;
      if (item.x <= 0) {
        let lastitem = this.backBoxs.shift();
        lastitem.x = this.backBoxs[this.backBoxs.length - 1].x + item.width + props.backmargin;
        this.backBoxs.push(lastitem);
      }
    })
  }
}