import { getTextureByName } from "./utils";
import { props } from "../props";
import GameView from './GameView';
export class Zhuazi extends engine.Container {
  private bashouGan: engine.Sprite;
  private bashou: engine.Sprite;
  private ganzi: engine.Sprite;
  private left_zhuazi: engine.Sprite;
  private right_zhuazi: engine.Sprite;
  private connect: engine.Sprite;
  private ganNode: engine.Container;
  private moveNode: engine.Container;
  private moveArr = [];
  private zhuaziY;
  private itemShow: engine.Container;
  private prizeBoxs = [];
  public GameView: GameView;
  constructor() {
    super();
  }
  setup() {
    this.ganNode = new engine.Container();
    this.moveNode = new engine.Container();
    this.ganNode.x = 280;
    this.ganNode.y = 350;
    this.bashouGan = new engine.Sprite(getTextureByName("把手杆子"));
    this.bashouGan.x = 60;
    this.bashouGan.y = 12;
    this.bashou = new engine.Sprite(getTextureByName("把手"));
    this.bashou.x = 0;
    this.bashou.y = 0;
    this.ganzi = new engine.Sprite(getTextureByName("伸缩杆"));
    this.ganzi.x = 97;
    this.ganzi.y = 27;
    this.connect = new engine.Sprite(getTextureByName("连接点"));
    this.connect.x = 18;
    this.connect.y = -5;
    this.left_zhuazi = new engine.Sprite(getTextureByName("左爪"));
    this.left_zhuazi.x = props.leftLocX;
    this.left_zhuazi.y = props.leftLocY;
    this.left_zhuazi.anchorX = this.left_zhuazi.width;
    this.left_zhuazi.anchorY = 0;
    this.right_zhuazi = new engine.Sprite(getTextureByName("右爪"));
    this.right_zhuazi.x = props.rightLocX;
    this.right_zhuazi.y = props.rightLocY;
    this.ganNode.addChild(this.left_zhuazi);
    this.ganNode.addChild(this.right_zhuazi);
    this.ganNode.addChild(this.connect);
    this.ganNode.x = 30;
    this.ganNode.y = this.ganNode.y - 263;
    this.zhuaziY = this.ganNode.y;
    this.moveNode.addChild(this.ganzi);
    this.moveNode.addChild(this.ganNode);
    this.moveNode.addChild(this.bashou);
    this.moveNode.x = 262;
    this.bashouGan.y = this.bashouGan.y;
    this.moveNode.y = this.moveNode.y;
    this.addChild(this.bashouGan);
    this.addChild(this.moveNode);
    if (!props.ganziShow) {
      this.bashouGan.visible = false;
    }
    if (!props.bashouShow) {
      this.bashou.visible = false;
    }
    this.createPrizeBox();
    
  }
  createPrizeBox() {
    for (let i = 0; i < props.dollNum; i++) {
      if (!new engine.Sprite(getTextureByName('prizebox_' + i))) {
        return;
      }
      this.prizeBoxs[i] = new engine.Sprite(getTextureByName('prizebox_' + i));
      this.prizeBoxs[i]['npcType'] = 'box' + i;
    }
    this.prizeBoxs[props.dollNum] = new engine.Sprite(getTextureByName('prizebox_0'));
    this.prizeBoxs[props.dollNum]['npcType'] = 'box' + props.dollNum;

    this.prizeBoxs.forEach(item => {
      this.ganNode.addChild(item);
      item.visible =  false;
      item.x = props.prizeBoxInitX;
      item.y = props.prizeBoxInitY;
    })
  }
  showPrizeBox() {
    this.prizeBoxs.forEach(item => {
      console.log(this.GameView.getBox()['npcType']);
      if (item['npcType'] === this.GameView.getBox()['npcType']) {
          item.visible = true;
          this.itemShow = item;
      } else {
        item.visible = false;
      }
    })
    
  }
  move() {
    let rndist = Math.random();
    let halfWidth = this.bashou.width / 2;
    let randomX = rndist * (rndist > 0.5 ? 1 : -1) * props.bashouMoveDist;
    console.log(randomX);
    engine.Tween.get(this.moveNode).to({ x: 370 + halfWidth - 71}, 1000).call(() => {
      this.zhangkai();
    });
  }
  zhangkai() {
    this.left_zhuazi.anchorX = this.left_zhuazi.width;
    this.left_zhuazi.anchorY = 0;
    engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: props.leftRotation}, 1000);
    engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: props.rightRotation }, 1000);
    setTimeout(() => {
      this.getLong();
    }, 500);
  }
  getLong() {
    let droptime = Number((this.GameView.getMoveX() / 60 - 1).toFixed(2)) * 1000 -130;
    console.log('dr', droptime);
    let times = (props.ganMoveEndY - this.ganzi.y ) / this.ganzi.height;
    console.log(Number(times.toFixed(2)) );
    engine.Tween.get(this.ganzi).to({ scaleY: Number(times.toFixed(2)) }, droptime).to({ scaleY: 1 }, droptime)
    console.log('node', this.zhuaziY);
    engine.Tween.get(this.ganNode).to({ y: props.ganMoveEndY }, droptime).call(() => {
      this.GameView.stopMove();
      if (this.GameView.ifPrize) {
        this.showPrizeBox();
        this.GameView.setVisible(false);
      }
    }).to({ y: this.zhuaziY }, droptime).call(() => {
      // this.getReset();
      if (this.GameView.ifPrize) {
        this.itemShow.visible = false;
      }
      engine.globalEvent.dispatchEvent('doll-machine2-game-end');
    })
  }
  getReset() {
    // if (this.GameView.ifPrize) {
    //   this.itemShow.visible = false;
    // }
    this.left_zhuazi.anchorX = this.left_zhuazi.width;
    this.left_zhuazi.anchorY = 0;
    engine.Tween.get(this.moveNode, {loop: false}).to({x: 262}, 1000);
    engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
    engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
    this.GameView.resetMoveX();
  }
}