/**
 * Created by rockyl on 2020-02-02.
 *
 * 掉落物品
 */
import { getTextureByName } from "./utils";
import { props } from "../props";

export class Goods extends engine.Container {
  private _body: engine.Rect;
  private _toY;

  constructor() {
    super();

    let body;
    body = this._body = new engine.Rect();

    // let rain = new engine.Sprite(getTextureByName('雨滴'));
    // rain["npcType"]="rain"
    // let stone = new engine.Sprite(getTextureByName('石块'));
    // stone["npcType"]="stone"
    // let boom = new engine.Sprite(getTextureByName('炸弹'));
    // boom["npcType"]="boom"

    let box1 = new engine.Sprite(getTextureByName("草泥马盒"));
    box1["npcType"] = "box1";
    let box2 = new engine.Sprite(getTextureByName("狗盒"));
    box2["npcType"] = "box2";
    let box3 = new engine.Sprite(getTextureByName("猫盒"));
    box3["npcType"] = "box3";

    // rain.visible=false;
    // stone.visible=false;
    // boom.visible=false;
    // body.addChild(rain)
    // body.addChild(stone)
    // body.addChild(boom)

    box1.visible = false;
    box2.visible = false;
    box3.visible = false;
    body.addChild(box1);
    body.addChild(box2);
    body.addChild(box3);

    this.addChild(body);
    body.width = 0.0001;
    body.height = 0.0001;
    body.mouseEnabled = false;
  }

  getRandomNumberByRange(start, end) {
    return Math.floor(Math.random() * (end - start) + start);
  }

  // reset() {
  // 	this.visible = true;
  // 	this.rotation = 0;
  // 	this.anchorOffsetY = 0;
  // 	this.y = 0;
  // 	this.x = (750-120)*Math.random()+30;
  // 	this.rotation = 0;
  // 	let random=Math.random()

  // 	if(random<props.goodsProbability[0]){
  // 		this.showNpc("box1")
  // 	}else if(random>=props.goodsProbability[0]&&random<=(props.goodsProbability[0]+props.goodsProbability[1])){
  // 		this.showNpc("box2")
  // 	}else if(random>(props.goodsProbability[0]+props.goodsProbability[1])){
  // 		this.showNpc("box3")
  // 	}
  // }

  reset() {
    this.visible = true;
    this.y = 200;
    this.x = 0;
    this.rotation = 0;
    let random = Math.random();
    if (random < 0.3) {
      this.showNpc("box1");
    } else if (random < 0.6) {
      this.showNpc("box2");
    } else {
      this.showNpc("box3");
    }
    // this.showNpc("box1");
    // this.showNpc("box2");
    // this.showNpc("box3");
  }

  showNpc(type) {
    for (let i = 0; i < this._body.children.length; i++) {
      this._body.children[i].visible = false;
      this._body.children[i].mouseEnabled = false;
    }
    for (let i = 0; i < this._body.children.length; i++) {
      if (this._body.children[i]["npcType"] == type) {
        this["npcType"] = type;
        console.log(type);

        this._body.children[i].visible = true;
        this._body.children[i].mouseEnabled = false;
      }
    }
  }

  set anchorOffsetY(v) {
    this._body.y = v;
  }
}
