/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import {injectProps} from "../props";


export class GameWrapper extends engine.Container {
	private _status;
	private _gameView: GameView;





	constructor() {
		super();
		engine.globalEvent.addEventListener('doll-machine2-game-init', this.reset, this);
		engine.globalEvent.addEventListener('doll-machine2-game-start', this.start, this);

		let gameView = this._gameView = new GameView();
		this.addChild(gameView);
		// gameView.reset();
		// gameView.start()
	}

	reset(event: engine.Event) {		
		injectProps(event.data);
		this._gameView.visible = true;
		this._gameView.reset();
	}

	start(event: engine.Event) {
		console.log('监听开始');
		injectProps(event.data);
		// this._status = 1;
		this._gameView.start(event.data);
	}

	pause() {
		this._gameView.pause();
	}

	resume() {
		this._gameView.resume();
	}

	revive() {
		this._gameView.revive();
	}

	clear() {
		this._gameView.visible = false;
	}

	private onTap(event) {
	//	this._gameView.tap(event);
	}
}
