/**
 * Created by rockyl on 2018/8/16.
 */

import { props } from "../props";
import { playSound, createSvga } from "./utils";
import ObjectPool = engine.ObjectPool;
import { getTextureByName } from "./utils";
import { Goods } from "./Goods";
import { PoolName } from "./object-pool-init";
import { FrontBoxs } from "./frontBox";
import { BackBoxs } from "./backBox";
import { Zhuazi } from './Zhuazi';

export default class GameView extends engine.Container {
  private _hasSetup;

  //触摸层
  private rectBg: engine.Rect;
  //npc层
  private NpcBg: engine.Container;
  //盒子1
  private box1: engine.Container;
  //盒子2
  private box2: engine.Container;
  //盒子3
  private box3: engine.Container;
  //盒子4
  private box4: engine.Container;
  //盒子5
  private box5: engine.Container;
  //前传输区域
  private frontTransfer: engine.Container;
  //后传输区域
  private backTransfer: engine.Container;
  //前台板
  private frontDesk: engine.Sprite;
  //后台板
  private backDesk: engine.Sprite;
  private _frontBoxs: FrontBoxs;
	private _backBoxs: BackBoxs;
	private _Zhuazi: Zhuazi;
	private prizeBox: engine.Container;
	private rect;
  //当前分数
	private score;
	
	//中奖盒子移动距离
	private moveTime;

  //游戏状态
  private gameIng;
  //是否已获取位移值
  public startstatus=false;
  //是否中奖
  public ifPrize=false;
  //npc出身计时器
  private timer;
  //倒计时计时器
  private countdownTimer: any;
  //倒计时
  private countdown: number;

  //当前速度
  private speed: number;

  // 当前场景上面的物品
  private goodsItems = [];

  private _goods: Goods;

  constructor() {
    super();
    this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
  }

  // private waterSvga;
  // private boomSvga;
  // private playerSvga;

  setup() {
    if (this._hasSetup) {
      return;
    }

    this._hasSetup = true;
		const frontBoxs = (this._frontBoxs = new FrontBoxs());
		this._frontBoxs.GameView = this;
		const backBoxs = (this._backBoxs = new BackBoxs());
		this._Zhuazi = new Zhuazi();
		this._Zhuazi.GameView = this;
    this.frontTransfer = new engine.Container();
    this.backTransfer = new engine.Container();
    this.frontTransfer.width = 0;
    this.frontTransfer.height = 0;
    this.frontTransfer.alpha = 1;
    // this.frontTransfer.x = 0;
    // this.frontTransfer.y = 434;

    this.backTransfer.width = 0;
    this.backTransfer.height = 0;
    this.backTransfer.alpha = 1;
    // this.backTransfer.x = 0;
    // this.backTransfer.y = 390;
		this.rect = new engine.Rect();
    this.rect.width = props.gameStageWidth;
    this.rect.height = props.gameStageHeight;
		this.rect.x = 65;
    this.rect.y = 0;
    this.NpcBg = new engine.Container();
    this.NpcBg.x = 0;
    this.NpcBg.y = 0;
		this.addChild(this.NpcBg);
		this.addChild(this.rect);
		
		
		
		// let gameBg = new engine.Sprite(getTextureByName("游戏背景"));
		// gameBg.x = 65;
		// gameBg.y = 263;
		// this.NpcBg.addChild(gameBg);
		
    this.frontDesk = new engine.Sprite(getTextureByName("前传输带"));
    this.frontDesk.x = props.initOffsetLeft;
    this.frontDesk.y = props.frontDeskY - props.initOffsetTop;

    this.backDesk = new engine.Sprite(getTextureByName("后传输带"));
    this.backDesk.x = props.initOffsetLeft;
    this.backDesk.y = props.backDeskY - props.initOffsetTop;
    if(props.single) {
      this.backDesk.visible = false;
    }
    let pcarr = [this.backDesk, this.frontDesk, this.backTransfer, this.frontTransfer, this._Zhuazi];
    pcarr.forEach(item => {
      this.NpcBg.addChild(item);
    })
		this.NpcBg.mask = this.rect;
		this._Zhuazi.setup();
		
		// this._Zhuazi.move();
		this.backTransfer.addChild(this._backBoxs);
    this._backBoxs.setup();
    if (props.single) {
      this.backTransfer.visible = false;
    }
		this.frontTransfer.addChild(this._frontBoxs);
		this._frontBoxs.setup();
	}
	/**
	 * 
	 * @param 暂停move
	 */
	stopMove() {
		this._frontBoxs.stop();
	}
	/**
	 * 赋值x距离值
	 */
	setMoveX(x, item) {
		this.moveTime = x;
    this.prizeBox = item;
		this._Zhuazi.move();
  }
	/**
	 * 显示隐藏盒子
	 */
	setVisible(isshow) {
		this._frontBoxs.showHidePrizeBox(isshow);
	}
	/**
	 * 获取中奖盒子移动的距离
	 */
	getMoveX() {
		return this.moveTime;
  }
  /**
   * 重置moveTime
   */
  resetMoveX() {
    this.moveTime = null;
  }
	/**
	 * 获取中奖盒子
	 */
	getBox() {
		return this.prizeBox;
	}
  /**
   * 重置场景
   */
  reset() {
    this.startstatus = false;
    this.ifPrize = false;
		this._Zhuazi.getReset();
  }

  /**
   * 开始
   */
  start(type=null) {
    this.speed = 1;
    this.gameIng = true;
    console.log('执行', type);
    this.startstatus = true;
    this.ifPrize = type && type.prize || false;
  }

  /**
   * npc开始掉落
   */
  beginNpc() {
    this.timer = setTimeout(() => {
      if (this.gameIng) {
        // this.speed += props.acceleratedSpeed;
        // this.creatNpc()
      }
      //递归执行
      // this.beginNpc();
    }, 2000 / this.speed);
  }

  /**
   * 暂停
   */
  pause() {
    this.gameIng = false;
  }

  /**
   * 恢复
   */
  revive() {
    this.gameIng = true;
  }

  /**
   * 重新开始
   */
  resume() {
    this.reset();
    this.start();
  }
}
