(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['doll-machine2'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	//# sourceMappingURL=utils.js.map

	var FrontBoxs = (function (_super) {
	    tslib.__extends(FrontBoxs, _super);
	    function FrontBoxs() {
	        var _this = _super.call(this) || this;
	        _this.frontBoxs = [];
	        return _this;
	    }
	    FrontBoxs.prototype.setup = function () {
	        var initX, initY = 0;
	        for (var i = 0; i < props.dollNum; i++) {
	            if (!new engine.Sprite(getTextureByName('frontbox_' + i))) {
	                return;
	            }
	            this.frontBoxs[i] = new engine.Sprite(getTextureByName('frontbox_' + i));
	            initX = this.frontBoxs[0].x = props.frontInitX;
	            initY = this.frontBoxs[0].y = props.frontInitY;
	            this.frontBoxs[i]['npcType'] = 'box' + i;
	        }
	        this.frontBoxs[props.dollNum] = new engine.Sprite(getTextureByName('frontbox_0'));
	        this.frontBoxs[props.dollNum]['npcType'] = 'box' + props.dollNum;
	        console.log(this.frontBoxs);
	        for (var i = 0; i < this.frontBoxs.length; i++) {
	            if (i == 0) {
	                this.frontBoxs[i].x = initX;
	            }
	            else {
	                this.frontBoxs[i].x = this.frontBoxs[i - 1].x - this.frontBoxs[0].width - props.frontmargin;
	            }
	            console.log(this.frontBoxs[i].x);
	            this.frontBoxs[i].y = initY;
	            this.addChild(this.frontBoxs[i]);
	            console.log('aaa', this.frontBoxs[i].x);
	        }
	        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
	    };
	    FrontBoxs.prototype.frameMove = function () {
	        var _this = this;
	        this.frontBoxs.forEach(function (item, index) {
	            item.x += props.moveSpeed;
	            if (item.x <= 0 && !item.visible) {
	                item.visible = true;
	            }
	            if (item.x >= 750) {
	                var tmpIndex = 0;
	                if (index <= 0) {
	                    tmpIndex = _this.frontBoxs.length - 1;
	                }
	                else {
	                    tmpIndex = index - 1;
	                }
	                item.x = _this.frontBoxs[tmpIndex].x - _this.frontBoxs[0].width - props.frontmargin;
	                if (!_this.GameView.getMoveX() && item.x <= 0 && _this.GameView.startstatus) {
	                    _this.GameView.setMoveX((370 - item.x - 13) / props.moveSpeed, item);
	                    _this.hideBox = item;
	                }
	            }
	        });
	    };
	    FrontBoxs.prototype.stop = function () {
	    };
	    FrontBoxs.prototype.showHidePrizeBox = function (isshow) {
	        this.hideBox.visible = isshow;
	    };
	    return FrontBoxs;
	}(engine.Container));
	//# sourceMappingURL=frontBox.js.map

	var BackBoxs = (function (_super) {
	    tslib.__extends(BackBoxs, _super);
	    function BackBoxs() {
	        var _this = _super.call(this) || this;
	        _this.backBoxs = [];
	        return _this;
	    }
	    BackBoxs.prototype.setup = function () {
	        var initX, initY = 0;
	        for (var i = 0; i < props.dollNum; i++) {
	            this.backBoxs[i] = new engine.Sprite(getTextureByName('backbox_' + i));
	            initX = this.backBoxs[0].x = props.backInitX;
	            initY = this.backBoxs[0].y = props.backInitY - props.initOffsetTop;
	            this.backBoxs[i]['npcType'] = 'box' + i;
	        }
	        this.backBoxs[props.dollNum] = new engine.Sprite(getTextureByName('backbox_0'));
	        this.backBoxs[props.dollNum]['npcType'] = 'box' + props.dollNum;
	        for (var i = 0; i < this.backBoxs.length; i++) {
	            if (i == 0) {
	                this.backBoxs[i].x = initX;
	            }
	            else {
	                this.backBoxs[i].x = this.backBoxs[i - 1].x + this.backBoxs[i].width + props.backmargin;
	            }
	            this.backBoxs[i].y = initY;
	            this.addChild(this.backBoxs[i]);
	        }
	        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
	    };
	    BackBoxs.prototype.frameMove = function () {
	        var _this = this;
	        this.backBoxs.forEach(function (item) {
	            item.x -= props.moveSpeed;
	            if (item.x <= 0) {
	                var lastitem = _this.backBoxs.shift();
	                lastitem.x = _this.backBoxs[_this.backBoxs.length - 1].x + item.width + props.backmargin;
	                _this.backBoxs.push(lastitem);
	            }
	        });
	    };
	    return BackBoxs;
	}(engine.Container));
	//# sourceMappingURL=backBox.js.map

	var Zhuazi = (function (_super) {
	    tslib.__extends(Zhuazi, _super);
	    function Zhuazi() {
	        var _this = _super.call(this) || this;
	        _this.moveArr = [];
	        _this.prizeBoxs = [];
	        return _this;
	    }
	    Zhuazi.prototype.setup = function () {
	        this.ganNode = new engine.Container();
	        this.moveNode = new engine.Container();
	        this.ganNode.x = 280;
	        this.ganNode.y = 350;
	        this.bashouGan = new engine.Sprite(getTextureByName("把手杆子"));
	        this.bashouGan.x = 60;
	        this.bashouGan.y = 12;
	        this.bashou = new engine.Sprite(getTextureByName("把手"));
	        this.bashou.x = 0;
	        this.bashou.y = 0;
	        this.ganzi = new engine.Sprite(getTextureByName("伸缩杆"));
	        this.ganzi.x = 97;
	        this.ganzi.y = 27;
	        this.connect = new engine.Sprite(getTextureByName("连接点"));
	        this.connect.x = 18;
	        this.connect.y = -5;
	        this.left_zhuazi = new engine.Sprite(getTextureByName("左爪"));
	        this.left_zhuazi.x = props.leftLocX;
	        this.left_zhuazi.y = props.leftLocY;
	        this.left_zhuazi.anchorX = this.left_zhuazi.width;
	        this.left_zhuazi.anchorY = 0;
	        this.right_zhuazi = new engine.Sprite(getTextureByName("右爪"));
	        this.right_zhuazi.x = props.rightLocX;
	        this.right_zhuazi.y = props.rightLocY;
	        this.ganNode.addChild(this.left_zhuazi);
	        this.ganNode.addChild(this.right_zhuazi);
	        this.ganNode.addChild(this.connect);
	        this.ganNode.x = 30;
	        this.ganNode.y = this.ganNode.y - 263;
	        this.zhuaziY = this.ganNode.y;
	        this.moveNode.addChild(this.ganzi);
	        this.moveNode.addChild(this.ganNode);
	        this.moveNode.addChild(this.bashou);
	        this.moveNode.x = 262;
	        this.bashouGan.y = this.bashouGan.y;
	        this.moveNode.y = this.moveNode.y;
	        this.addChild(this.bashouGan);
	        this.addChild(this.moveNode);
	        if (!props.ganziShow) {
	            this.bashouGan.visible = false;
	        }
	        if (!props.bashouShow) {
	            this.bashou.visible = false;
	        }
	        this.createPrizeBox();
	    };
	    Zhuazi.prototype.createPrizeBox = function () {
	        var _this = this;
	        for (var i = 0; i < props.dollNum; i++) {
	            if (!new engine.Sprite(getTextureByName('prizebox_' + i))) {
	                return;
	            }
	            this.prizeBoxs[i] = new engine.Sprite(getTextureByName('prizebox_' + i));
	            this.prizeBoxs[i]['npcType'] = 'box' + i;
	        }
	        this.prizeBoxs[props.dollNum] = new engine.Sprite(getTextureByName('prizebox_0'));
	        this.prizeBoxs[props.dollNum]['npcType'] = 'box' + props.dollNum;
	        this.prizeBoxs.forEach(function (item) {
	            _this.ganNode.addChild(item);
	            item.visible = false;
	            item.x = props.prizeBoxInitX;
	            item.y = props.prizeBoxInitY;
	        });
	    };
	    Zhuazi.prototype.showPrizeBox = function () {
	        var _this = this;
	        this.prizeBoxs.forEach(function (item) {
	            console.log(_this.GameView.getBox()['npcType']);
	            if (item['npcType'] === _this.GameView.getBox()['npcType']) {
	                item.visible = true;
	                _this.itemShow = item;
	            }
	            else {
	                item.visible = false;
	            }
	        });
	    };
	    Zhuazi.prototype.move = function () {
	        var _this = this;
	        var rndist = Math.random();
	        var halfWidth = this.bashou.width / 2;
	        var randomX = rndist * (rndist > 0.5 ? 1 : -1) * props.bashouMoveDist;
	        console.log(randomX);
	        engine.Tween.get(this.moveNode).to({ x: 370 + halfWidth - 71 }, 1000).call(function () {
	            _this.zhangkai();
	        });
	    };
	    Zhuazi.prototype.zhangkai = function () {
	        var _this = this;
	        this.left_zhuazi.anchorX = this.left_zhuazi.width;
	        this.left_zhuazi.anchorY = 0;
	        engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: props.leftRotation }, 1000);
	        engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: props.rightRotation }, 1000);
	        setTimeout(function () {
	            _this.getLong();
	        }, 500);
	    };
	    Zhuazi.prototype.getLong = function () {
	        var _this = this;
	        var droptime = Number((this.GameView.getMoveX() / 60 - 1).toFixed(2)) * 1000 - 130;
	        console.log('dr', droptime);
	        var times = (props.ganMoveEndY - this.ganzi.y) / this.ganzi.height;
	        console.log(Number(times.toFixed(2)));
	        engine.Tween.get(this.ganzi).to({ scaleY: Number(times.toFixed(2)) }, droptime).to({ scaleY: 1 }, droptime);
	        console.log('node', this.zhuaziY);
	        engine.Tween.get(this.ganNode).to({ y: props.ganMoveEndY }, droptime).call(function () {
	            _this.GameView.stopMove();
	            if (_this.GameView.ifPrize) {
	                _this.showPrizeBox();
	                _this.GameView.setVisible(false);
	            }
	        }).to({ y: this.zhuaziY }, droptime).call(function () {
	            if (_this.GameView.ifPrize) {
	                _this.itemShow.visible = false;
	            }
	            engine.globalEvent.dispatchEvent('doll-machine2-game-end');
	        });
	    };
	    Zhuazi.prototype.getReset = function () {
	        this.left_zhuazi.anchorX = this.left_zhuazi.width;
	        this.left_zhuazi.anchorY = 0;
	        engine.Tween.get(this.moveNode, { loop: false }).to({ x: 262 }, 1000);
	        engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
	        engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
	        this.GameView.resetMoveX();
	    };
	    return Zhuazi;
	}(engine.Container));
	//# sourceMappingURL=Zhuazi.js.map

	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.startstatus = false;
	        _this.ifPrize = false;
	        _this.goodsItems = [];
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        var _this = this;
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        var frontBoxs = (this._frontBoxs = new FrontBoxs());
	        this._frontBoxs.GameView = this;
	        var backBoxs = (this._backBoxs = new BackBoxs());
	        this._Zhuazi = new Zhuazi();
	        this._Zhuazi.GameView = this;
	        this.frontTransfer = new engine.Container();
	        this.backTransfer = new engine.Container();
	        this.frontTransfer.width = 0;
	        this.frontTransfer.height = 0;
	        this.frontTransfer.alpha = 1;
	        this.backTransfer.width = 0;
	        this.backTransfer.height = 0;
	        this.backTransfer.alpha = 1;
	        this.rect = new engine.Rect();
	        this.rect.width = props.gameStageWidth;
	        this.rect.height = props.gameStageHeight;
	        this.rect.x = 65;
	        this.rect.y = 0;
	        this.NpcBg = new engine.Container();
	        this.NpcBg.x = 0;
	        this.NpcBg.y = 0;
	        this.addChild(this.NpcBg);
	        this.addChild(this.rect);
	        this.frontDesk = new engine.Sprite(getTextureByName("前传输带"));
	        this.frontDesk.x = props.initOffsetLeft;
	        this.frontDesk.y = props.frontDeskY - props.initOffsetTop;
	        this.backDesk = new engine.Sprite(getTextureByName("后传输带"));
	        this.backDesk.x = props.initOffsetLeft;
	        this.backDesk.y = props.backDeskY - props.initOffsetTop;
	        if (props.single) {
	            this.backDesk.visible = false;
	        }
	        var pcarr = [this.backDesk, this.frontDesk, this.backTransfer, this.frontTransfer, this._Zhuazi];
	        pcarr.forEach(function (item) {
	            _this.NpcBg.addChild(item);
	        });
	        this.NpcBg.mask = this.rect;
	        this._Zhuazi.setup();
	        this.backTransfer.addChild(this._backBoxs);
	        this._backBoxs.setup();
	        if (props.single) {
	            this.backTransfer.visible = false;
	        }
	        this.frontTransfer.addChild(this._frontBoxs);
	        this._frontBoxs.setup();
	    };
	    GameView.prototype.stopMove = function () {
	        this._frontBoxs.stop();
	    };
	    GameView.prototype.setMoveX = function (x, item) {
	        this.moveTime = x;
	        this.prizeBox = item;
	        this._Zhuazi.move();
	    };
	    GameView.prototype.setVisible = function (isshow) {
	        this._frontBoxs.showHidePrizeBox(isshow);
	    };
	    GameView.prototype.getMoveX = function () {
	        return this.moveTime;
	    };
	    GameView.prototype.resetMoveX = function () {
	        this.moveTime = null;
	    };
	    GameView.prototype.getBox = function () {
	        return this.prizeBox;
	    };
	    GameView.prototype.reset = function () {
	        this.startstatus = false;
	        this.ifPrize = false;
	        this._Zhuazi.getReset();
	    };
	    GameView.prototype.start = function (type) {
	        if (type === void 0) { type = null; }
	        this.speed = 1;
	        this.gameIng = true;
	        console.log('执行', type);
	        this.startstatus = true;
	        this.ifPrize = type && type.prize || false;
	    };
	    GameView.prototype.beginNpc = function () {
	        var _this = this;
	        this.timer = setTimeout(function () {
	            if (_this.gameIng) ;
	        }, 2000 / this.speed);
	    };
	    GameView.prototype.pause = function () {
	        this.gameIng = false;
	    };
	    GameView.prototype.revive = function () {
	        this.gameIng = true;
	    };
	    GameView.prototype.resume = function () {
	        this.reset();
	        this.start();
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('doll-machine2-game-init', _this.reset, _this);
	        engine.globalEvent.addEventListener('doll-machine2-game-start', _this.start, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    GameWrapper.prototype.start = function (event) {
	        console.log('监听开始');
	        injectProps(event.data);
	        this._gameView.start(event.data);
	    };
	    GameWrapper.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    GameWrapper.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    GameWrapper.prototype.revive = function () {
	        this._gameView.revive();
	    };
	    GameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    GameWrapper.prototype.onTap = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map