import { getTextureByName } from "./utils";
import GameView from './GameView';
import { props } from "../props";
export class FrontBoxs extends engine.Container {
  //盒子1
  private box1: engine.Container;
  //盒子2
  private box2: engine.Container;
  //盒子3 
  private box3: engine.Container;
  //盒子4
  private box4: engine.Container;
  //盒子5
  private box5: engine.Container;
  // 需隐藏的盒子
  private hideBox: engine.Container;
  private frontBoxs=[];
  public GameView: GameView;
  constructor() {
    super();
  }
  setup() {
    let initX , initY = 0;
    this.box1 = new engine.Sprite(getTextureByName("狗盒"));
    this.box1["npcType"] = "box1";
    initX = this.box1.x = 435;
    initY = this.box1.y = 614;

    this.box2 = new engine.Sprite(getTextureByName("猫盒"));
    this.box2["npcType"] = "box2";
    this.box3 = new engine.Sprite(getTextureByName("草泥马盒"));
    this.box3["npcType"] = "box3";
    this.box4 = new engine.Sprite(getTextureByName("狗盒"));
    this.box4["npcType"] = "box4";
    this.box5 = new engine.Sprite(getTextureByName("猫盒"));
    this.box5["npcType"] = "box5";
    this.frontBoxs = [this.box1, this.box2, this.box3, this.box4];
    for(let i = 0; i < this.frontBoxs.length; i++) {
      if(i == 0) {
        this.frontBoxs[i].x = initX ;
      } else {
        this.frontBoxs[i].x = this.frontBoxs[i - 1].x - this.box1.width - props.frontmargin;
      }
      
      this.frontBoxs[i].y = initY;
      this.addChild(this.frontBoxs[i]);
    }
    this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
  }
  frameMove() {
    this.frontBoxs.forEach((item, index) => {
      item.x += props.moveSpeed;
      if(item.x <=0 && !item.visible) {
        item.visible = true;
      }
      if(item.x >= 750) {
        let lastitem = this.frontBoxs.shift();
        lastitem.x = this.frontBoxs[this.frontBoxs.length - 1].x - this.box1.width - props.frontmargin;
         
        if (!this.GameView.getMoveX() && item.x <= 0 && this.GameView.startstatus) {
          this.GameView.setMoveX((370 - item.x - 13) / props.moveSpeed, item);
          this.hideBox = item;
        }
        this.frontBoxs.push(lastitem);
      }
    })
  }
  stop() {
    // this.removeEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
  }
  showHidePrizeBox(isshow) {
    this.hideBox.visible = isshow
  }
}