(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['doll-machine'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}

	var Goods = (function (_super) {
	    tslib.__extends(Goods, _super);
	    function Goods() {
	        var _this = _super.call(this) || this;
	        var body;
	        body = _this._body = new engine.Rect();
	        var box1 = new engine.Sprite(getTextureByName("草泥马盒"));
	        box1["npcType"] = "box1";
	        var box2 = new engine.Sprite(getTextureByName("狗盒"));
	        box2["npcType"] = "box2";
	        var box3 = new engine.Sprite(getTextureByName("猫盒"));
	        box3["npcType"] = "box3";
	        box1.visible = false;
	        box2.visible = false;
	        box3.visible = false;
	        body.addChild(box1);
	        body.addChild(box2);
	        body.addChild(box3);
	        _this.addChild(body);
	        body.width = 0.0001;
	        body.height = 0.0001;
	        body.mouseEnabled = false;
	        return _this;
	    }
	    Goods.prototype.getRandomNumberByRange = function (start, end) {
	        return Math.floor(Math.random() * (end - start) + start);
	    };
	    Goods.prototype.reset = function () {
	        this.visible = true;
	        this.y = 200;
	        this.x = 0;
	        this.rotation = 0;
	        var random = Math.random();
	        if (random < 0.3) {
	            this.showNpc("box1");
	        }
	        else if (random < 0.6) {
	            this.showNpc("box2");
	        }
	        else {
	            this.showNpc("box3");
	        }
	    };
	    Goods.prototype.showNpc = function (type) {
	        for (var i = 0; i < this._body.children.length; i++) {
	            this._body.children[i].visible = false;
	            this._body.children[i].mouseEnabled = false;
	        }
	        for (var i = 0; i < this._body.children.length; i++) {
	            if (this._body.children[i]["npcType"] == type) {
	                this["npcType"] = type;
	                console.log(type);
	                this._body.children[i].visible = true;
	                this._body.children[i].mouseEnabled = false;
	            }
	        }
	    };
	    Object.defineProperty(Goods.prototype, "anchorOffsetY", {
	        set: function (v) {
	            this._body.y = v;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Goods;
	}(engine.Container));

	var ObjectPool = engine.ObjectPool;
	var PoolName = 'goods';
	ObjectPool.registerPool(PoolName, function () {
	    return new Goods();
	}, function (item, data) {
	    item.reset();
	});

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	var FrontBoxs = (function (_super) {
	    tslib.__extends(FrontBoxs, _super);
	    function FrontBoxs() {
	        var _this = _super.call(this) || this;
	        _this.frontBoxs = [];
	        return _this;
	    }
	    FrontBoxs.prototype.setup = function () {
	        var initX, initY = 0;
	        this.box1 = new engine.Sprite(getTextureByName("狗盒"));
	        this.box1["npcType"] = "box1";
	        initX = this.box1.x = 435;
	        initY = this.box1.y = 614;
	        this.box2 = new engine.Sprite(getTextureByName("猫盒"));
	        this.box2["npcType"] = "box2";
	        this.box3 = new engine.Sprite(getTextureByName("草泥马盒"));
	        this.box3["npcType"] = "box3";
	        this.box4 = new engine.Sprite(getTextureByName("狗盒"));
	        this.box4["npcType"] = "box4";
	        this.box5 = new engine.Sprite(getTextureByName("猫盒"));
	        this.box5["npcType"] = "box5";
	        this.frontBoxs = [this.box1, this.box2, this.box3, this.box4];
	        for (var i = 0; i < this.frontBoxs.length; i++) {
	            if (i == 0) {
	                this.frontBoxs[i].x = initX;
	            }
	            else {
	                this.frontBoxs[i].x = this.frontBoxs[i - 1].x - this.box1.width - props.frontmargin;
	            }
	            this.frontBoxs[i].y = initY;
	            this.addChild(this.frontBoxs[i]);
	        }
	        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
	    };
	    FrontBoxs.prototype.frameMove = function () {
	        var _this = this;
	        this.frontBoxs.forEach(function (item, index) {
	            item.x += props.moveSpeed;
	            if (item.x <= 0 && !item.visible) {
	                item.visible = true;
	            }
	            if (item.x >= 750) {
	                var lastitem = _this.frontBoxs.shift();
	                lastitem.x = _this.frontBoxs[_this.frontBoxs.length - 1].x - _this.box1.width - props.frontmargin;
	                if (!_this.GameView.getMoveX() && item.x <= 0 && _this.GameView.startstatus) {
	                    _this.GameView.setMoveX((370 - item.x - 13) / props.moveSpeed, item);
	                    _this.hideBox = item;
	                }
	                _this.frontBoxs.push(lastitem);
	            }
	        });
	    };
	    FrontBoxs.prototype.stop = function () {
	    };
	    FrontBoxs.prototype.showHidePrizeBox = function (isshow) {
	        this.hideBox.visible = isshow;
	    };
	    return FrontBoxs;
	}(engine.Container));

	var BackBoxs = (function (_super) {
	    tslib.__extends(BackBoxs, _super);
	    function BackBoxs() {
	        var _this = _super.call(this) || this;
	        _this.backBoxs = [];
	        return _this;
	    }
	    BackBoxs.prototype.setup = function () {
	        var initX, initY = 0;
	        this.box1 = new engine.Sprite(getTextureByName("后狗盒"));
	        initX = this.box1.x = 188;
	        initY = this.box1.y = 616;
	        this.box2 = new engine.Sprite(getTextureByName("后猫盒"));
	        this.box3 = new engine.Sprite(getTextureByName("后草泥马盒"));
	        this.box4 = new engine.Sprite(getTextureByName("后狗盒"));
	        this.box5 = new engine.Sprite(getTextureByName("后猫盒"));
	        this.backBoxs = [this.box1, this.box2, this.box3, this.box4, this.box5];
	        for (var i = 0; i < this.backBoxs.length; i++) {
	            if (i == 0) {
	                this.backBoxs[i].x = initX;
	            }
	            else {
	                this.backBoxs[i].x = this.backBoxs[i - 1].x + this.backBoxs[i].width + props.backmargin;
	            }
	            this.backBoxs[i].y = initY;
	            this.addChild(this.backBoxs[i]);
	        }
	        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
	    };
	    BackBoxs.prototype.frameMove = function () {
	        var _this = this;
	        this.backBoxs.forEach(function (item) {
	            item.x -= props.moveSpeed;
	            if (item.x <= 0) {
	                var lastitem = _this.backBoxs.shift();
	                lastitem.x = _this.backBoxs[_this.backBoxs.length - 1].x + item.width + props.backmargin;
	                _this.backBoxs.push(lastitem);
	            }
	        });
	    };
	    return BackBoxs;
	}(engine.Container));

	var Zhuazi = (function (_super) {
	    tslib.__extends(Zhuazi, _super);
	    function Zhuazi() {
	        var _this = _super.call(this) || this;
	        _this.moveArr = [];
	        _this.prizeBoxs = [];
	        return _this;
	    }
	    Zhuazi.prototype.setup = function () {
	        this.ganNode = new engine.Container();
	        this.moveNode = new engine.Container();
	        this.ganNode.x = 280;
	        this.ganNode.y = 350;
	        this.bashouGan = new engine.Sprite(getTextureByName("把手杆子"));
	        this.bashouGan.x = 60;
	        this.bashouGan.y = 275;
	        this.bashou = new engine.Sprite(getTextureByName("把手"));
	        this.bashou.x = 0;
	        this.bashou.y = 263;
	        this.ganzi = new engine.Sprite(getTextureByName("伸缩杆"));
	        this.ganzi.x = 97;
	        this.ganzi.y = 290;
	        this.connect = new engine.Sprite(getTextureByName("连接点"));
	        this.connect.x = 18;
	        this.connect.y = -5;
	        this.left_zhuazi = new engine.Sprite(getTextureByName("左爪"));
	        this.left_zhuazi.x = -15;
	        this.left_zhuazi.y = 60;
	        this.left_zhuazi.anchorX = this.left_zhuazi.width;
	        this.left_zhuazi.anchorY = 0;
	        this.right_zhuazi = new engine.Sprite(getTextureByName("右爪"));
	        this.right_zhuazi.x = 98;
	        this.right_zhuazi.y = 60;
	        this.ganNode.addChild(this.left_zhuazi);
	        this.ganNode.addChild(this.right_zhuazi);
	        this.ganNode.addChild(this.connect);
	        this.ganNode.x = 30;
	        this.zhuaziY = this.ganNode.y;
	        this.moveNode.addChild(this.ganzi);
	        this.moveNode.addChild(this.ganNode);
	        this.moveNode.addChild(this.bashou);
	        this.moveNode.x = 262;
	        this.addChild(this.bashouGan);
	        this.addChild(this.moveNode);
	        this.createPrizeBox();
	    };
	    Zhuazi.prototype.createPrizeBox = function () {
	        var _this = this;
	        this.box1 = new engine.Sprite(getTextureByName("中奖狗盒"));
	        this.box1["npcType"] = "box1";
	        this.box2 = new engine.Sprite(getTextureByName("中奖猫盒"));
	        this.box2["npcType"] = "box2";
	        this.box3 = new engine.Sprite(getTextureByName("中奖草泥马盒"));
	        this.box3["npcType"] = "box3";
	        this.box4 = new engine.Sprite(getTextureByName("中奖狗盒"));
	        this.box4["npcType"] = "box4";
	        this.box5 = new engine.Sprite(getTextureByName("中奖猫盒"));
	        this.box5["npcType"] = "box5";
	        this.prizeBoxs = [this.box1, this.box2, this.box3, this.box4, this.box5];
	        this.prizeBoxs.forEach(function (item) {
	            _this.ganNode.addChild(item);
	            item.visible = false;
	            item.x = 15;
	            item.y = 48;
	        });
	    };
	    Zhuazi.prototype.showPrizeBox = function () {
	        var _this = this;
	        this.prizeBoxs.forEach(function (item) {
	            console.log(_this.GameView.getBox()['npcType']);
	            if (item['npcType'] === _this.GameView.getBox()['npcType']) {
	                item.visible = true;
	                _this.itemShow = item;
	            }
	            else {
	                item.visible = false;
	            }
	        });
	    };
	    Zhuazi.prototype.move = function () {
	        var _this = this;
	        var rndist = Math.random();
	        var halfWidth = this.bashou.width / 2;
	        var randomX = rndist * (rndist > 0.5 ? 1 : -1) * props.bashouMoveDist;
	        console.log(randomX);
	        engine.Tween.get(this.moveNode).to({ x: 370 + halfWidth - 71 }, 1000).call(function () {
	            _this.zhangkai();
	        });
	    };
	    Zhuazi.prototype.zhangkai = function () {
	        var _this = this;
	        this.left_zhuazi.anchorX = this.left_zhuazi.width;
	        this.left_zhuazi.anchorY = 0;
	        engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: props.leftRotation }, 1000);
	        engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: props.rightRotation }, 1000);
	        setTimeout(function () {
	            _this.getLong();
	        }, 500);
	    };
	    Zhuazi.prototype.getLong = function () {
	        var _this = this;
	        var droptime = Number((this.GameView.getMoveX() / 60 - 1).toFixed(2)) * 1000;
	        console.log('dr', droptime);
	        var times = (props.ganMoveEndY - this.ganzi.y) / this.ganzi.height;
	        console.log(Number(times.toFixed(2)));
	        engine.Tween.get(this.ganzi).to({ scaleY: Number(times.toFixed(2)) }, droptime).to({ scaleY: 1 }, droptime);
	        console.log('node', this.zhuaziY);
	        engine.Tween.get(this.ganNode).to({ y: props.ganMoveEndY }, droptime).call(function () {
	            _this.GameView.stopMove();
	            if (_this.GameView.ifPrize) {
	                _this.showPrizeBox();
	                _this.GameView.setVisible(false);
	            }
	        }).to({ y: this.zhuaziY }, droptime).call(function () {
	            if (_this.GameView.ifPrize) {
	                _this.itemShow.visible = false;
	            }
	            engine.globalEvent.dispatchEvent('doll-machine-gameover');
	        });
	    };
	    Zhuazi.prototype.getReset = function () {
	        this.left_zhuazi.anchorX = this.left_zhuazi.width;
	        this.left_zhuazi.anchorY = 0;
	        engine.Tween.get(this.moveNode, { loop: false }).to({ x: 262 }, 1000);
	        engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
	        engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
	        this.GameView.resetMoveX();
	    };
	    return Zhuazi;
	}(engine.Container));

	var ObjectPool$1 = engine.ObjectPool;
	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        var _this = _super.call(this) || this;
	        _this.startstatus = false;
	        _this.ifPrize = false;
	        _this.goodsItems = [];
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    GameView.prototype.setup = function () {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        var frontBoxs = (this._frontBoxs = new FrontBoxs());
	        this._frontBoxs.GameView = this;
	        var backBoxs = (this._backBoxs = new BackBoxs());
	        this._Zhuazi = new Zhuazi();
	        this._Zhuazi.GameView = this;
	        this.frontTransfer = new engine.Container();
	        this.backTransfer = new engine.Container();
	        this.frontTransfer.width = 0;
	        this.frontTransfer.height = 0;
	        this.frontTransfer.alpha = 1;
	        this.backTransfer.width = 0;
	        this.backTransfer.height = 0;
	        this.backTransfer.alpha = 1;
	        this.rect = new engine.Rect();
	        this.rect.width = 611;
	        this.rect.height = 704;
	        this.rect.x = 65;
	        this.rect.y = 263;
	        this.NpcBg = new engine.Container();
	        this.addChild(this.NpcBg);
	        this.addChild(this.rect);
	        var gameBg = new engine.Sprite(getTextureByName("游戏背景"));
	        gameBg.x = 65;
	        gameBg.y = 263;
	        this.NpcBg.addChild(gameBg);
	        this.frontDesk = new engine.Sprite(getTextureByName("前传输带"));
	        this.frontDesk.x = 60;
	        this.frontDesk.y = 781;
	        this.backDesk = new engine.Sprite(getTextureByName("后传输带"));
	        this.backDesk.x = 60;
	        this.backDesk.y = 712;
	        this.NpcBg.addChild(this.backDesk);
	        this.NpcBg.addChild(this.frontDesk);
	        this.NpcBg.addChild(this.backTransfer);
	        this.NpcBg.addChild(this.frontTransfer);
	        this.NpcBg.addChild(this._Zhuazi);
	        this.NpcBg.mask = this.rect;
	        this._Zhuazi.setup();
	        this.backTransfer.addChild(this._backBoxs);
	        this._backBoxs.setup();
	        this.frontTransfer.addChild(this._frontBoxs);
	        this._frontBoxs.setup();
	    };
	    GameView.prototype.stopMove = function () {
	        this._frontBoxs.stop();
	    };
	    GameView.prototype.setMoveX = function (x, item) {
	        this.moveTime = x;
	        this.prizeBox = item;
	        this._Zhuazi.move();
	    };
	    GameView.prototype.setVisible = function (isshow) {
	        this._frontBoxs.showHidePrizeBox(isshow);
	    };
	    GameView.prototype.getMoveX = function () {
	        return this.moveTime;
	    };
	    GameView.prototype.resetMoveX = function () {
	        this.moveTime = null;
	    };
	    GameView.prototype.getBox = function () {
	        return this.prizeBox;
	    };
	    GameView.prototype.reset = function () {
	        this.startstatus = false;
	        this.ifPrize = false;
	        this._Zhuazi.getReset();
	    };
	    GameView.prototype.start = function (type) {
	        if (type === void 0) { type = null; }
	        this.speed = 1;
	        this.gameIng = true;
	        console.log('执行', type);
	        this.startstatus = true;
	        this.ifPrize = type && type.prize || false;
	    };
	    GameView.prototype.beginNpc = function () {
	        var _this = this;
	        this.timer = setTimeout(function () {
	            if (_this.gameIng) ;
	        }, 2000 / this.speed);
	    };
	    GameView.prototype.pause = function () {
	        this.gameIng = false;
	    };
	    GameView.prototype.revive = function () {
	        this.gameIng = true;
	    };
	    GameView.prototype.resume = function () {
	        this.reset();
	        this.start();
	    };
	    GameView.prototype.initNpc = function () {
	        this.box1 = new engine.Sprite(getTextureByName("草泥马盒"));
	        this.box2 = new engine.Sprite(getTextureByName("狗盒"));
	        this.box3 = new engine.Sprite(getTextureByName("猫盒"));
	        this.box4 = new engine.Sprite(getTextureByName("草泥马盒"));
	        this.box5 = new engine.Sprite(getTextureByName("猫盒"));
	        this.box1.x = 120;
	        this.box1.y = 434;
	        this.box2.x = 306;
	        this.box2.y = 434;
	        this.box3.x = 487;
	        this.box3.y = 434;
	        this.box4.x = 240;
	        this.box4.scaleX = 0.5;
	        this.box4.scaleY = 0.5;
	        this.box4.y = 390;
	        this.box5.x = 434;
	        this.box5.y = 390;
	        this.box5.scaleX = 0.5;
	        this.box5.scaleY = 0.5;
	        this.backTransfer.addChild(this.box4);
	        this.backTransfer.addChild(this.box5);
	        this.frontTransfer.addChild(this.box1);
	        this.frontTransfer.addChild(this.box2);
	        this.frontTransfer.addChild(this.box3);
	    };
	    GameView.prototype.died = function () {
	        this.score = 0;
	        this.pause();
	    };
	    GameView.prototype.removeNpc = function (goods) {
	        this.NpcBg.removeChild(goods);
	        ObjectPool$1.recycleObject(PoolName, goods);
	        goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
	        var index = this.goodsItems.indexOf(goods);
	        if (index > -1) {
	            this.goodsItems.splice(index, 1);
	        }
	    };
	    GameView.prototype.recycleGoods = function () {
	        clearTimeout(this.timer);
	        clearInterval(this.countdownTimer);
	        for (var _i = 0, _a = this.goodsItems; _i < _a.length; _i++) {
	            var goods = _a[_i];
	            if (goods) {
	                this.removeChild(goods);
	                ObjectPool$1.recycleObject(PoolName, goods);
	                goods.removeEventListener(engine.Event.ENTER_FRAME, goods["onGoodsEnter"], this);
	            }
	        }
	        this.goodsItems = [];
	    };
	    GameView.prototype.hasHit = function (a, b) {
	        if (Math.abs(a.x + a.width / 2 - (b.x + b.width / 2)) <
	            a.width / 2 + b.width / 2 &&
	            Math.abs(a.y + a.height / 2 - (b.y + b.height / 2)) <
	                a.height / 2 + b.height / 2) {
	            return true;
	        }
	        else {
	            return false;
	        }
	    };
	    return GameView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('doll-machine-reset', _this.reset, _this);
	        engine.globalEvent.addEventListener('doll-machine-prize', _this.start, _this);
	        var gameView = _this._gameView = new GameView();
	        _this.addChild(gameView);
	        return _this;
	    }
	    GameWrapper.prototype.reset = function (event) {
	        injectProps(event.data);
	        this._gameView.visible = true;
	        this._gameView.reset();
	    };
	    GameWrapper.prototype.start = function (event) {
	        console.log('监听开始');
	        injectProps(event.data);
	        this._gameView.start(event.data);
	    };
	    GameWrapper.prototype.pause = function () {
	        this._gameView.pause();
	    };
	    GameWrapper.prototype.resume = function () {
	        this._gameView.resume();
	    };
	    GameWrapper.prototype.revive = function () {
	        this._gameView.revive();
	    };
	    GameWrapper.prototype.clear = function () {
	        this._gameView.visible = false;
	    };
	    GameWrapper.prototype.onTap = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map