(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global.circle = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    console.log('name', engine.getAssetByName(name));
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function createSvga(name, anchorName) {
	    var inst = new svga.Svga();
	    inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	    return inst;
	}
	//# sourceMappingURL=utils.js.map

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var Gameinit = (function (_super) {
	    tslib.__extends(Gameinit, _super);
	    function Gameinit() {
	        var _this = _super.call(this) || this;
	        _this._isSetUp = false;
	        _this.totleY = 1200;
	        _this.isMove = false;
	        _this.isChoose = true;
	        _this.isDid = true;
	        _this.listGift = [];
	        console.log("11111111111111");
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    Gameinit.prototype.setup = function () {
	        console.log("初始化加载000000000000000000000000！");
	        if (this._isSetUp) {
	            return;
	        }
	        else {
	            this.loadThings();
	            console.log("this._isSetUp=", this._isSetUp, '<<<<');
	        }
	    };
	    Gameinit.prototype.loadThings = function () {
	        var self = this;
	        var body;
	        body = this._body = new engine.Rect;
	        body.width = 0.0001;
	        body.height = 0.0001;
	        this.addChild(body);
	        var gift0 = this.addRes(body, '礼盒', 250, 100, 247, 188);
	        var gift1 = this.addRes(body, '礼盒', 485, 85, 247, 190);
	        var gift2 = this.addRes(body, '礼盒', 385, -15, 222, 170);
	        var gift3 = this.addRes(body, '礼盒', 165, -15, 222, 170);
	        var gift4 = this.addRes(body, '礼盒', 20, 85, 247, 190);
	        this.listGift = [gift0, gift1, gift2, gift3, gift4];
	        var circle = this.addRes(body, '圈', 260, 350, 240, 80);
	        var giftSvga = createSvga("套中动效");
	        giftSvga.visible = false;
	        body.addChild(giftSvga);
	        var _a = props.ferruleModuleGlobalPosition, v2X = _a[0], v2Y = _a[1];
	        body.x = v2X;
	        body.y = v2Y;
	        engine.globalEvent.addEventListener("circle-game-start", function () {
	            self.isMove = true;
	            console.log('this.isMove===', self.isMove);
	        }, this);
	        engine.globalEvent.addEventListener("circle-game-init", function () {
	            self.isChoose = true;
	            giftSvga.visible = false;
	            body.children[self.num].visible = true;
	            circle.x = 260;
	            circle.y = 350;
	            circle.width = 240;
	            circle.height = 80;
	            circle.visible = true;
	        }, this);
	        circle.addEventListener(engine.Event.ENTER_FRAME, function () {
	            if (self.isMove) {
	                console.log("物体移动");
	                if (self.isChoose) {
	                    self.num = Math.floor(Math.random() * self.listGift.length);
	                    self.isChoose = false;
	                }
	                self.nodeMove(circle, self.listGift[self.num], giftSvga);
	            }
	        });
	    };
	    Gameinit.prototype.aniPlay = function (node0, targetNode, bool) {
	        node0.scaleX = this.currentScale(targetNode.y, this.totleY) - 0.05 * this.currentScale(targetNode.y, this.totleY);
	        node0.scaleY = this.currentScale(targetNode.y, this.totleY) - 0.05 * this.currentScale(targetNode.y, this.totleY);
	        node0.x = targetNode.x;
	        node0.y = targetNode.y;
	        node0.visible = true;
	        node0.play(false, false);
	        node0.addEventListener(engine.Event.END_FRAME, function () {
	            console.log("播放到最后一帧", bool, '<<<');
	            engine.globalEvent.dispatchEvent("circle-game-end");
	            bool = false;
	        });
	    };
	    Gameinit.prototype.addRes = function (fatherNode, resName, v2X, v2Y, resW, resH) {
	        console.log("进行资源的添加");
	        var thing = new engine.Sprite(getTextureByName(resName));
	        thing.x = v2X;
	        thing.y = v2Y;
	        thing.width = resW;
	        thing.height = resH;
	        return fatherNode.addChild(thing);
	    };
	    Gameinit.prototype.nodeMove = function (moveNode, targetNode, nodePlay) {
	        console.log("moveNode.x=", moveNode.x, "targetNode.x=", targetNode.x);
	        var moveX = targetNode.x - moveNode.x;
	        var moveY = targetNode.y - moveNode.y;
	        console.log('moveX=', moveX, 'moveY=', moveY);
	        if (this.isDid) {
	            if (Math.abs(moveX) > 2) {
	                moveNode.x += moveX / Math.abs(moveX) * 5;
	            }
	            if (Math.abs(moveY) > 2) {
	                moveNode.y += moveY / Math.abs(moveY) * 5;
	                moveNode.scaleX = this.currentScale(moveNode.y, this.totleY) + 0.2;
	                moveNode.scaleY = moveNode.scaleX;
	            }
	            if (Math.abs(moveX) < 3 && Math.abs(moveY) < 3) {
	                targetNode.visible = false;
	                moveNode.visible = false;
	                this.aniPlay(nodePlay, targetNode, this.isDid);
	                this.isMove = false;
	            }
	        }
	    };
	    Gameinit.prototype.currentScale = function (currentY, totoleDisY) {
	        return (currentY + 830) / totoleDisY;
	    };
	    return Gameinit;
	}(engine.Container));
	//# sourceMappingURL=Gameinit.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new Gameinit();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map