/**
 * Created by rockyl on 2020-01-21.
 */

export function getTexture(uuid) {
	return engine.Texture.from(getAssetByUUID(uuid).uuid);
}

export function getTextureByName(name) {
	return getTexture(engine.getAssetByName(name).uuid);
}

export function playSound(name) {
	engine.playSound(engine.getAssetByName(name).uuid, {keep: true});
}
export function createSvga(name, anchorName?) {
	let inst = new svga.Svga();
	inst.source = 'asset://' + engine.getAssetByName(name).uuid;
	return inst;
}

export function getIndexFromRC(row,col,maxCol){
	let index;
	index = row * maxCol + col ;
	return index
}




export function getRandomArray(array){
	array.sort(function() {
		return .5 - Math.random();
	});
}

export function getPoint(r: number, ox: number, oy: number, count: number) {
	var p:any[] = []
    let radians = (Math.PI / 180) * Math.round(360 / count); //弧度
    for (let i: number = 2; i <= count+1; i++) {
        let x = ox + r * Math.sin(radians * i+Math.PI/180*45);
        let y = oy + r * Math.cos(radians * i+Math.PI/180*45);
        p.unshift({ x: x, y: y }); //为保持数据顺时针
	}
	return p;
}