import {getTexture, getPoint} from './utils'
import {props} from "../props";
export default class TestView extends engine.Container{
    turntableImage:engine.Image = null;
    pointerImage:engine.Image = null;
    count:number = 0;
    result:number = 0;
    rect:engine.Rect = null;
    angleArr:number[] = [];//当转盘不为规整的转盘时每个奖品所对应的角度数组（角度制）
    offsetAngle:number = 0;
    constructor(){
        super()
        this.addEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
        
    }

    setup(){
        var that = this;
        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
        that.turntableImage = new engine.Image(getTexture("2fcebfca-e31b-49b2-9af1-266607c23418"));
        that.addChild(that.turntableImage);
        that.pointerImage = new engine.Image(getTexture("56f1a88b-dd8d-4c38-853a-cf2be7525a14"));
        that.addChild(that.pointerImage);
        that.initGame();
        that.addEvnt();
        var p = getPoint(355,that.turntableImage.x,that.turntableImage.y,8);
        for(var i=0;i<p.length;i++){
            var a = new engine.Shape();
            a.beginFill(0x66ccff);
            a.drawRect(-30,-30,60,60);
            a.endFill();
            this.addChild(a);
            a.x = p[i].x+that.turntableImage.x;
            a.y = p[i].y;
        }
    }

    addEvnt(){
        engine.globalEvent.addEventListener("pictures-start",this.startRotate,this);
        engine.globalEvent.addEventListener("pictures-stop",this.stopRotate,this);
    }

    set(){
        this.result = props.setResult;
    }

    startRotate(){
        var that = this;
        var resultAngle:number = 0;
        var angle = 0;
        if(that.angleArr.length<=0){
            var unitAngle = 360/that.count;
            resultAngle = that.result*unitAngle;
            // if(that.count/2%2==0){
                angle = 360 - resultAngle+unitAngle*0.5-that.offsetAngle;
            // }else{
            //     angle = 360 - resultAngle+unitAngle; 
            // }
        }
        else{
            var baseAngle = 0;
            for(var i=0;i<that.result;i++){
                if(i==(that.result-1)){
                    baseAngle = that.angleArr[i]*0.5
                }else{
                    baseAngle = that.angleArr[i];
                }
                resultAngle += baseAngle;
            }
            angle = 360 - resultAngle - that.offsetAngle;
        }
        var targetAngle = angle + 360*8;
        engine.Tween.get(that.turntableImage).to({rotation:targetAngle},5000,engine.Ease.quadOut).call(()=>{
            engine.globalEvent.dispatchEvent("pictures-end");
        });
    }

    stopRotate(){
        engine.Tween.removeTweens(this.turntableImage);
    }

    initGame(){
        var that = this;
        that.count = props.count;
        that.result = props.result;
        that.offsetAngle = props.offsetAngle;

        that.turntableImage.x = engine.gameStage.width - that.turntableImage.width>>1;
        that.turntableImage.y = engine.gameStage.height - that.turntableImage.height>>1;
        that.pointerImage.x = engine.gameStage.width - that.pointerImage.width>>1;
        that.pointerImage.y = engine.gameStage.height - that.pointerImage.height>>1;
        that.turntableImage.anchorX = that.turntableImage.width>>1;
        that.turntableImage.anchorY = that.turntableImage.height>>1;
        that.pointerImage.anchorX = that.pointerImage.width>>1;
        that.pointerImage.anchorY = that.pointerImage.height>>1;
        that.setAngleArr();
   }

   setAngleArr(){
    if(props.angleArr){
        var tempArr = props.angleArr.split(',');
        for(var i=0;i<tempArr.length;i++){
            this.angleArr.push(parseFloat(tempArr[i]));
        }
    }
   }
}