(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['big-turntable'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getPoint(r, ox, oy, count) {
	    var p = [];
	    var radians = (Math.PI / 180) * Math.round(360 / count);
	    for (var i = 2; i <= count + 1; i++) {
	        var x = ox + r * Math.sin(radians * i + Math.PI / 180 * 45);
	        var y = oy + r * Math.cos(radians * i + Math.PI / 180 * 45);
	        p.unshift({ x: x, y: y });
	    }
	    return p;
	}

	var TestView = (function (_super) {
	    tslib.__extends(TestView, _super);
	    function TestView() {
	        var _this = _super.call(this) || this;
	        _this.turntableImage = null;
	        _this.pointerImage = null;
	        _this.count = 0;
	        _this.result = 0;
	        _this.rect = null;
	        _this.angleArr = [];
	        _this.offsetAngle = 0;
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    TestView.prototype.setup = function () {
	        var that = this;
	        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
	        that.turntableImage = new engine.Image(getTexture("2fcebfca-e31b-49b2-9af1-266607c23418"));
	        that.addChild(that.turntableImage);
	        that.pointerImage = new engine.Image(getTexture("56f1a88b-dd8d-4c38-853a-cf2be7525a14"));
	        that.addChild(that.pointerImage);
	        that.initGame();
	        that.addEvnt();
	        var p = getPoint(355, that.turntableImage.x, that.turntableImage.y, 8);
	        for (var i = 0; i < p.length; i++) {
	            var a = new engine.Shape();
	            a.beginFill(0x66ccff);
	            a.drawRect(-30, -30, 60, 60);
	            a.endFill();
	            this.addChild(a);
	            a.x = p[i].x + that.turntableImage.x;
	            a.y = p[i].y;
	        }
	    };
	    TestView.prototype.addEvnt = function () {
	        engine.globalEvent.addEventListener("pictures-start", this.startRotate, this);
	        engine.globalEvent.addEventListener("pictures-stop", this.stopRotate, this);
	    };
	    TestView.prototype.set = function () {
	        this.result = props.setResult;
	    };
	    TestView.prototype.startRotate = function () {
	        var that = this;
	        var resultAngle = 0;
	        var angle = 0;
	        if (that.angleArr.length <= 0) {
	            var unitAngle = 360 / that.count;
	            resultAngle = that.result * unitAngle;
	            angle = 360 - resultAngle + unitAngle * 0.5 - that.offsetAngle;
	        }
	        else {
	            var baseAngle = 0;
	            for (var i = 0; i < that.result; i++) {
	                if (i == (that.result - 1)) {
	                    baseAngle = that.angleArr[i] * 0.5;
	                }
	                else {
	                    baseAngle = that.angleArr[i];
	                }
	                resultAngle += baseAngle;
	            }
	            angle = 360 - resultAngle - that.offsetAngle;
	        }
	        var targetAngle = angle + 360 * 8;
	        engine.Tween.get(that.turntableImage).to({ rotation: targetAngle }, 5000, engine.Ease.quadOut).call(function () {
	            engine.globalEvent.dispatchEvent("pictures-end");
	        });
	    };
	    TestView.prototype.stopRotate = function () {
	        engine.Tween.removeTweens(this.turntableImage);
	    };
	    TestView.prototype.initGame = function () {
	        var that = this;
	        that.count = props.count;
	        that.result = props.result;
	        that.offsetAngle = props.offsetAngle;
	        that.turntableImage.x = engine.gameStage.width - that.turntableImage.width >> 1;
	        that.turntableImage.y = engine.gameStage.height - that.turntableImage.height >> 1;
	        that.pointerImage.x = engine.gameStage.width - that.pointerImage.width >> 1;
	        that.pointerImage.y = engine.gameStage.height - that.pointerImage.height >> 1;
	        that.turntableImage.anchorX = that.turntableImage.width >> 1;
	        that.turntableImage.anchorY = that.turntableImage.height >> 1;
	        that.pointerImage.anchorX = that.pointerImage.width >> 1;
	        that.pointerImage.anchorY = that.pointerImage.height >> 1;
	        that.setAngleArr();
	    };
	    TestView.prototype.setAngleArr = function () {
	        if (props.angleArr) {
	            var tempArr = props.angleArr.split(',');
	            for (var i = 0; i < tempArr.length; i++) {
	                this.angleArr.push(parseFloat(tempArr[i]));
	            }
	        }
	    };
	    return TestView;
	}(engine.Container));
	//# sourceMappingURL=TestView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener("pictures-set", _this.set, _this);
	        var testView = _this._testView = new TestView();
	        _this.addChild(testView);
	        return _this;
	    }
	    GameWrapper.prototype.set = function (event) {
	        injectProps(event.data);
	        this._testView.set();
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.stop = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map