
/**
 * Created by rockyl on 2020-01-21.
 */

export function getTexture(uuid) {
	return engine.Texture.from(getAssetByUUID(uuid).uuid);
}

export function getTextureByName(name) {
	return getTexture(engine.getAssetByName(name).uuid);
}

export function playSound(name) {
	engine.playSound(engine.getAssetByName(name).uuid, {keep: true});
}
export function getStage(){
	return engine.gameStage.stage;
}


export enum OptionState{
	CHOICE_RIGHT,//选对
	CHOICE_WRONG,//选错
	CHOICE_SELECT,//选中
}

export enum GameState{
	STATE_START,//开始 选择中
	STATE_END,//倒计时结束
}