


import { props } from '../props';


import { getTextureByName, GameState, getStage } from "./utils";
import { SvgaManager } from './SvgaManager';


export class SubjectTitle extends engine.Container {

    private _subjectTitleBox;//题目框
    private _titleLabel;//题目文字
    private _titleNumLabel;//当前题数文字
    private _countDownBg;//倒计时
    private _countDownText;//倒计时数字
    private _answerCountBg;//答对题数背景
    private _answerCountText;//答对题数
    private _bar;//倒计时进度条
    private _frameCurrAngle = 0;//累加
    private _frameCount = 0;//帧数记录
    private _countDownTmp = 0;//倒计时处理


    private _readyGo;//svga节点
    private _questionEnter;//svga节点
    private _square = new engine.Graphics();

    private _countDownSvga;
    init() {
        this.showSubjectBox();
        this.insideAddEventListener();

    }
    initCountDownSvga(tmpNode) {
        let countDownSvga = this._countDownSvga = SvgaManager.createSvga('countdown_321');
        countDownSvga.x = (getStage().width - 120) / 2;
        countDownSvga.y = (getStage().height - 120) / 2;
        countDownSvga.visible = false;
        tmpNode.addChild(countDownSvga);
    }

    private insideAddEventListener() {
        //更新题目
        engine.globalEvent.addEventListener('updateSubjectTitle', this.updateSubjectTitle, this)
        //更新答对题数
        engine.globalEvent.addEventListener('updateAnswerCount', this.updateAnswerCount, this);

        engine.globalEvent.addEventListener('resetTitle', this.reset, this);
        engine.globalEvent.addEventListener('outRest',this.outRest,this);
    }
    //初始化答题区域
    private showSubjectBox() {
        let tmpContainer = new engine.Container();
        tmpContainer.x = 0;
        tmpContainer.y = props.subjectBox_Y;
        this.addChild(tmpContainer);

        //题目栏
        let subjectBox = this._subjectTitleBox = new engine.Image(getTextureByName('题目栏'))
        subjectBox.x = (750 - subjectBox.width) / 2;
        subjectBox.y = 0;
        tmpContainer.addChild(subjectBox);


        //倒计时
        let countDownBg = this._countDownBg = new engine.Image(getTextureByName('倒计时'))
        countDownBg.x = (750 - countDownBg.width) / 2;
        countDownBg.y = - countDownBg.height / 2 + 10;
        tmpContainer.addChild(countDownBg);

        let bar = this._bar = new engine.Image(getTextureByName('进度条'))
        bar.x = 0;
        bar.y = 0;
        countDownBg.addChild(bar);
        bar.anchorX = bar.width / 2;
        bar.anchorY = bar.height / 2;
        bar.rotation = -90;
        bar.addChild(this._square);

        bar.mask = this._square;

        let answerCountBg = this._answerCountBg = new engine.Image(getTextureByName('答对题数'))
        answerCountBg.x = (750 - answerCountBg.width) / 2;
        answerCountBg.y = subjectBox.y + subjectBox.height - answerCountBg.height - 10
        tmpContainer.addChild(answerCountBg);

        this.initCountDownBar(0);
        this.initAnswerCountText();
        this.initCountDownText();
        this.initTitleText();
        this.initSvga();
    }
    //初始化倒计时数字
    private initCountDownText() {
        // let countDownText = this._countDownText = new engine.Label();
        // countDownText.fillColor = 0xfffcc6;
        // countDownText.size = 58;
        // countDownText.width = this._countDownBg.width;
        // countDownText.height = this._countDownBg.height;
        // countDownText.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        // countDownText.textAlign = engine.TEXT_ALIGN.CENTER;
        // countDownText.x = 0;
        // countDownText.y = 0;
        // countDownText.text = props.countDown;
        // this._countDownBg.addChild(countDownText);
        // this._countDownTmp = props.countDown;

        let countDownText = this._countDownText = new engine.BitmapText();
        countDownText.font = props.fontName;
        countDownText.text = props.countDown;
        this.handleAlign();
        this._countDownBg.addChild(countDownText);
        this._countDownTmp = props.countDown;

    }
    private handleAlign() {
        this._countDownText.x = (this._countDownBg.width - this._countDownText.width) / 2;
        this._countDownText.y = (this._countDownBg.height - this._countDownText.height) / 2;;
    }
    private countDownBitmapText() {
        let countDownString = props.countDown + '';
        for (let index = 0; index < countDownString.length; index++) {
            const element = countDownString[index];

        }
    }
    //初始化答对题目数字
    private initAnswerCountText() {
        let answerCountText = this._answerCountText = new engine.Label();
        answerCountText.fillColor = 0x2b3134;
        answerCountText.size = 30;
        answerCountText.width = this._answerCountBg.width;
        answerCountText.height = this._answerCountBg.height;
        answerCountText.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        answerCountText.x = 160;
        answerCountText.y = props.answerCountText_Y;
        answerCountText.text = '0';
        this._answerCountBg.addChild(answerCountText);
    }

    //初始化题目
    private initTitleText() {
        let titleLabel = this._titleLabel = new engine.Label();
        titleLabel.fillColor = 0xfffcc6;
        titleLabel.size = 36;
        titleLabel.width = this._subjectTitleBox.width - props.titleText_width;
        titleLabel.height = this._subjectTitleBox.height - props.titleText_height;
        titleLabel.lineType = engine.TEXT_lINETYPE.MULTI;
        titleLabel.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        titleLabel.textAlign = engine.TEXT_ALIGN.CENTER;
        titleLabel.x = props.titleText_X;
        titleLabel.y = props.titleText_Y;
        titleLabel.text = '';
        titleLabel.alpha = 0;
        this._subjectTitleBox.addChild(titleLabel);
    }
    //初始化 题数标识
    private initTitleNumText(tmpContainer) {
        let titleNumLabel = this._titleNumLabel = new engine.Label();
        titleNumLabel.fillColor = 0xfffcc6;
        titleNumLabel.size = 48;
        titleNumLabel.width = tmpContainer.width;
        titleNumLabel.height = tmpContainer.heigth;
        titleNumLabel.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
        titleNumLabel.textAlign = engine.TEXT_ALIGN.CENTER;
        // titleNumLabel.x = 90;
        // titleNumLabel.y = 85;
        titleNumLabel.text = '';
        titleNumLabel.visible = false;
        tmpContainer.addChild(titleNumLabel);
    }
    //更新当前题数
    private updateTitleNumText(curSubJect) {
        this.rest();
        this._titleNumLabel.text = `第${curSubJect}题`;
    }
    private reset() {
        this._titleLabel.text = '';
    }
    //更新题目
    private updateSubjectTitle(tmpData) {
        this._titleLabel.alpha = 0;
        this._titleLabel.text = tmpData.data.title;
        this.lastTime = 0;
        this.updateTitleNumText(tmpData.data.curSubJect + 1);
        if (tmpData.data.curSubJect == 0) {
            this.fristAnswer();
        } else {
            this.playQuestion_enter();
        }
    }
    //更新答对题数
    private updateAnswerCount(data) {
        this._answerCountText.text = data.data.count + '';
    }
    //更新倒计时
    private updateCountDownText(count) {
        this._countDownText.text = count + '';
        this.handleAlign();
    }
    //开启倒计时进度条
    private openCountDownBar() {
        this.rest();
        engine.gameStage.addEventListener(engine.Event.ENTER_FRAME, this.countDownBar, this)
    }
    //更新进度条
    private initCountDownBar(currAngle) {

        let ax = this._bar.width / 2;
        let ay = this._bar.height / 2;

        this._square.clear();
        this._square.beginFill(0);
        this._square.moveTo(ax, ay);
        this._square.arc(ax, ay, this._bar.width / 2, 0, (currAngle * Math.PI / 180))
        this._square.lineTo(ax, ay);
        this._square.endFill();
    }
    //帧处理 
    private lastTime;
    private countDownBar() {
        var now = Date.now();
        var deltaTime = this.lastTime ? now - this.lastTime : 16.7;
        this.lastTime = now;

        this._frameCurrAngle += 360 / (props.countDown * 1000) * deltaTime;
        this._frameCurrAngle = Math.min(360, this._frameCurrAngle);
        this.initCountDownBar(this._frameCurrAngle);

        this._frameCount += deltaTime;
        if (this._frameCount >= 1000) {
            let tmpTime = this._countDownTmp - 1 > 0 ? this._countDownTmp -= 1 : 0;
            if (tmpTime == 3) {
                this.playCountDownSvga();
            }
            this.updateCountDownText(tmpTime);
            this._frameCount = 0;

            if (this._frameCurrAngle >= 360) {
                engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.countDownBar, this)
                engine.globalEvent.dispatchEvent('upDateGameState', { gameState: GameState.STATE_END });
                engine.globalEvent.dispatchEvent('sendAnswer')
            }
        }
    }
    private rest() {
        this._frameCurrAngle = 0;
        this._frameCount = 0;
        this._square.clear();
        this._countDownTmp = props.countDown;
        this._countDownText.text = props.countDown + '';
        this.handleAlign();
        //this._readyGo.visible = false;
        //this._countDownSvga.visible = false;
        //this._questionEnter.visible = false;
        //engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.countDownBar, this)
    }
    outRest(){
        this._frameCurrAngle = 0;
        this._frameCount = 0;
        this._square.clear();
        this._countDownTmp = props.countDown;
        this._countDownText.text = props.countDown + '';
        this.handleAlign();
        this._readyGo.visible = false;
        this._countDownSvga.visible = false;
        this._questionEnter.visible = false;
        engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.countDownBar, this)
    }
    initSvga() {
        let readyGo = this._readyGo = SvgaManager.createSvga('ready_go');
        readyGo.x = 50;
        readyGo.y = 45;
        readyGo.visible = false;
        this._subjectTitleBox.addChild(readyGo);

        let tmpRect = new engine.Rect();
        tmpRect.x = 50
        tmpRect.y = 45;
        tmpRect.width = 520;
        tmpRect.height = 200;
        this._subjectTitleBox.addChild(tmpRect);
        readyGo.mask = tmpRect;

        let tmpContainer = new engine.Container();
        tmpContainer.width = 400;
        tmpContainer.height = 100;
        tmpContainer.x = (this._subjectTitleBox.width - 400) / 2;
        tmpContainer.y = 115;
        this._subjectTitleBox.addChild(tmpContainer);

        let questionEnter = this._questionEnter = SvgaManager.createSvga('question_enter');
        questionEnter.x = 0;
        questionEnter.y = 0;
        questionEnter.visible = false;
        tmpContainer.addChild(questionEnter);

        this.initTitleNumText(tmpContainer);


    }
    fristAnswer() {
        this.playReadyGo();
    }
    playReadyGo() {
        this._readyGo.visible = true;
        SvgaManager.play(this._readyGo, () => {
            this._readyGo.visible = false;
            this.playQuestion_enter();
        });
    }
    playQuestion_enter() {
        this._questionEnter.visible = true;
        this._titleNumLabel.visible = true;
        // return;
        SvgaManager.play(this._questionEnter, () => {
            this._questionEnter.visible = false;
            //this._titleLabel.visible = true;
            this.playTweenTitle();
            this._titleNumLabel.visible = false;
            this.openCountDownBar();
            //如果初始倒计时为3秒
            if (this._countDownTmp == 3) {
                this.playCountDownSvga();
            }
            engine.globalEvent.dispatchEvent('start');
        });
    }
    playTweenTitle() {
        engine.Tween.get(this._titleLabel, { loop: false })
            .set({ alpha: 0 })
            .to({ alpha: 1 }, 500, engine.Ease.cubicIn)
            .call(() => {
                engine.Tween.removeTweens(this._titleLabel);
            })
    }
    playCountDownSvga() {
        console.log('测试次数');
        this._countDownSvga.visible = true;
        this._countDownSvga.lockStep = true;
        SvgaManager.play(this._countDownSvga, () => {
            this._countDownSvga.visible = false;
        });
    }
}