

import { props } from './../props';


/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";

export class GameWrapper extends engine.Container {
	private _gameView: GameView;

	constructor() {
		super();

		engine.globalEvent.addEventListener('answer-game-start', this.start, this);

		engine.globalEvent.addEventListener('answer-game-subject', this.initSubject, this);

		engine.globalEvent.addEventListener('answer-game-result', this.result, this);
		this.visibilitychange();

	}

	start(event: engine.Event) {
		//初始化传入的倒计时
		if(event.data.countDown){
			props.countDown = event.data.countDown;
		}
		//未消除自定义模块节点 但执行了多次start事件处理
		if(!this._gameView){
			let gameView = this._gameView = new GameView();
			this.addChild(gameView);
			this._gameView.start();
		}
		engine.globalEvent.dispatchEvent('reset')
	}

	initSubject(event:engine.Event){
		let subjectData = event.data.subjectData;
		engine.globalEvent.dispatchEvent('handleOption',subjectData);
	}
	result(event:engine.Event){
		let result = event.data.result;
		engine.globalEvent.dispatchEvent('handleResult',{result:result});
	}

	private visibilitychange(){
		document.addEventListener('visibilitychange', function () {
            if (document.visibilityState === 'hidden') {
				console.log('放置后台');
				engine.globalEvent.dispatchEvent('outRest')
				engine.globalEvent.dispatchEvent('answer-game-visibilitychange',{hidden:true});

            }
        });
	}
}
