import { SubjectManager } from './SubjectManager';


/**
 * Created by rockyl on 2018/8/16.
 */

import {props} from "../props";

import { Background } from "./Background";

import { SubjectTitle } from "./SubjectTitle";
import { AnswerArea } from "./answerArea";



export default class GameView extends engine.Container {

	
	private _hasSetup;
	private _backgroud:Background;
	private _subject:SubjectTitle;
	private _answerArea:AnswerArea;

	private _subjectManager:SubjectManager;
	constructor() {
		super();	
		//this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
	}
	setup(){
		if (this._hasSetup) {
			return;
		}
		this._hasSetup = true;
		
		let backgroud = this._backgroud = new Background();
		this.addChild(backgroud);
		backgroud.init();

		let subject = this._subject = new SubjectTitle();
		this.addChild(subject);
		subject.init();

		let answerArea = this._answerArea = new AnswerArea();
		this.addChild(answerArea);
		answerArea.init();

		let tmpContainer = new engine.Container();
		this.addChildAt(tmpContainer,50);
		subject.initCountDownSvga(tmpContainer);

		// let svgaManager = this._svgaManager = new SvgaManager();
		// this.addChild(svgaManager);
		// svgaManager.init(answerArea.getArea())

		let subjectManager = this._subjectManager = new SubjectManager();
		subjectManager.init();	
	}

	async start() {
		this.setup();
	}    
	
}
