

import {getTextureByName} from "./utils";
import {getStage} from "./utils";

import { props } from './../props';

export class Background extends engine.Container{

    private _bg;
    private _cloudUp;//上云
    private _cloudDown;//下云
    private _answerBg;//答案背景
    private _subjectBox;//题目框
    private _countDownBg;//倒计时
    private _answerCountBg;//答对题数背景
    private _answerCountText;//答对题数
    init(){  
    
        // let bg = this._bg = new engine.Image(getTextureByName('gameBg'));
        // bg.x = 0;
        // bg.y = 0;
        // this.addChild(bg);

        // let answerBg = this._answerBg = new engine.Image(getTextureByName('答案区'))
        // answerBg.x = 0;
        // answerBg.y = bg.height - answerBg.height;
        // this.addChild(answerBg);
        // //上云
        // let cloudUp = this._cloudUp = new engine.Image(getTextureByName('前景云上'))
        // cloudUp.x = 0;
        // cloudUp.y = 0;
        // this.addChild(cloudUp);

        // //下云
        // let cloudDown = this._cloudDown = new engine.Image(getTextureByName('前景云下'))
        // cloudDown.x = 0;
        // cloudDown.y = bg.height - cloudDown.height;
        // this.addChild(cloudDown);

        this.showSubjectBox();

        this.insideAddEventListener();
    }

    private insideAddEventListener(){
        engine.globalEvent.addEventListener('changeCount', this.changeCount, this);
    }


    private showSubjectBox(){
        let tmpContainer = new engine.Container();
        tmpContainer.x = 0;
        tmpContainer.y = props.subjectBox_Y;
        this.addChild(tmpContainer);

        //题目栏
        let subjectBox = this._subjectBox = new engine.Image(getTextureByName('题目栏'))
        subjectBox.x = (750 - subjectBox.width)/2;
        subjectBox.y = 0;
        tmpContainer.addChild(subjectBox);

        //倒计时
        let countDownBg = this._countDownBg = new engine.Image(getTextureByName('倒计时'))
        countDownBg.x = (750-countDownBg.width) / 2;
        countDownBg.y = - countDownBg.height/2 + 10;
        tmpContainer.addChild(countDownBg);

        let answerCountBg = this._answerCountBg = new engine.Image(getTextureByName('答对题数'))
        answerCountBg.x = (750-answerCountBg.width)/2;
        answerCountBg.y = subjectBox.y + subjectBox.height - answerCountBg.height -10
        tmpContainer.addChild(answerCountBg);

        let answerCountText = this._answerCountText = new engine.Label();
        answerCountText.fillColor = 0x2b3134;
		answerCountText.size = 30;
		answerCountText.width = answerCountBg.width;
		answerCountText.height = answerCountBg.height;
		answerCountText.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
		answerCountText.x = 160;
        answerCountText.y = 3;
        answerCountText.text = '0';
        answerCountBg.addChild(answerCountText);
    }
    //更新答对题数
    private changeCount(data){
        this._answerCountText.text = data.data.count+'';
    }

}