(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['answer-game'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var SubjectManager = (function () {
	    function SubjectManager() {
	        this._curSubJect = 0;
	    }
	    SubjectManager.prototype.init = function () {
	        this.insideAddEventListener();
	    };
	    SubjectManager.prototype.insideAddEventListener = function () {
	        engine.globalEvent.addEventListener('handleOption', this.handleSubject, this);
	        engine.globalEvent.addEventListener('updateSubject', this.updateSubject, this);
	        engine.globalEvent.addEventListener('handleResult', this.handleResult, this);
	        engine.globalEvent.addEventListener('sendAnswerResult', this.sendAnswerResult, this);
	    };
	    SubjectManager.prototype.handleSubject = function (subject) {
	        this._curSubJect = 0;
	        this._loactionCache = subject.data;
	        this.updateSubject();
	        engine.globalEvent.dispatchEvent('updateAnswerCount', { count: 0 });
	    };
	    SubjectManager.prototype.updateSubject = function () {
	        if (this._curSubJect >= this._loactionCache.length) {
	            console.log('没有题目');
	            engine.globalEvent.dispatchEvent('answer-game-over');
	            return;
	        }
	        this._curTmpSubject = this._loactionCache[this._curSubJect];
	        var title = this._loactionCache[this._curSubJect].question;
	        var options = this._loactionCache[this._curSubJect].options;
	        var tmpIndex = this._loactionCache[this._curSubJect].index;
	        this.updateTitle(title, tmpIndex);
	        this.updateOption(options);
	        this._curSubJect++;
	    };
	    SubjectManager.prototype.updateTitle = function (title, tmpIndex) {
	        engine.globalEvent.dispatchEvent('updateSubjectTitle', { title: title, curSubJect: tmpIndex });
	    };
	    SubjectManager.prototype.updateOption = function (options) {
	        engine.globalEvent.dispatchEvent('updateOption', { options: options });
	    };
	    SubjectManager.prototype.handleResult = function (result) {
	        var tmp = result.data.result;
	        engine.globalEvent.dispatchEvent('updateAnswerCount', { count: tmp.count });
	        engine.globalEvent.dispatchEvent('handleAnswerOption', { state: tmp.state });
	    };
	    SubjectManager.prototype.sendAnswerResult = function (resultData) {
	        var tmpAnswer = resultData.data.answer;
	        engine.globalEvent.dispatchEvent('answer-game-select', { curSubJect: this._curTmpSubject.index, answer: tmpAnswer });
	    };
	    return SubjectManager;
	}());
	//# sourceMappingURL=SubjectManager.js.map

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	function getStage() {
	    return engine.gameStage.stage;
	}
	var OptionState;
	(function (OptionState) {
	    OptionState[OptionState["CHOICE_RIGHT"] = 0] = "CHOICE_RIGHT";
	    OptionState[OptionState["CHOICE_WRONG"] = 1] = "CHOICE_WRONG";
	    OptionState[OptionState["CHOICE_SELECT"] = 2] = "CHOICE_SELECT";
	})(OptionState || (OptionState = {}));
	var GameState;
	(function (GameState) {
	    GameState[GameState["STATE_START"] = 0] = "STATE_START";
	    GameState[GameState["STATE_END"] = 1] = "STATE_END";
	})(GameState || (GameState = {}));
	//# sourceMappingURL=utils.js.map

	var Background = (function (_super) {
	    tslib.__extends(Background, _super);
	    function Background() {
	        return _super !== null && _super.apply(this, arguments) || this;
	    }
	    Background.prototype.init = function () {
	        this.showSubjectBox();
	        this.insideAddEventListener();
	    };
	    Background.prototype.insideAddEventListener = function () {
	        engine.globalEvent.addEventListener('changeCount', this.changeCount, this);
	    };
	    Background.prototype.showSubjectBox = function () {
	        var tmpContainer = new engine.Container();
	        tmpContainer.x = 0;
	        tmpContainer.y = props.subjectBox_Y;
	        this.addChild(tmpContainer);
	        var subjectBox = this._subjectBox = new engine.Image(getTextureByName('题目栏'));
	        subjectBox.x = (750 - subjectBox.width) / 2;
	        subjectBox.y = 0;
	        tmpContainer.addChild(subjectBox);
	        var countDownBg = this._countDownBg = new engine.Image(getTextureByName('倒计时'));
	        countDownBg.x = (750 - countDownBg.width) / 2;
	        countDownBg.y = -countDownBg.height / 2 + 10;
	        tmpContainer.addChild(countDownBg);
	        var answerCountBg = this._answerCountBg = new engine.Image(getTextureByName('答对题数'));
	        answerCountBg.x = (750 - answerCountBg.width) / 2;
	        answerCountBg.y = subjectBox.y + subjectBox.height - answerCountBg.height - 10;
	        tmpContainer.addChild(answerCountBg);
	        var answerCountText = this._answerCountText = new engine.Label();
	        answerCountText.fillColor = 0x2b3134;
	        answerCountText.size = 30;
	        answerCountText.width = answerCountBg.width;
	        answerCountText.height = answerCountBg.height;
	        answerCountText.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        answerCountText.x = 160;
	        answerCountText.y = 3;
	        answerCountText.text = '0';
	        answerCountBg.addChild(answerCountText);
	    };
	    Background.prototype.changeCount = function (data) {
	        this._answerCountText.text = data.data.count + '';
	    };
	    return Background;
	}(engine.Container));
	//# sourceMappingURL=Background.js.map

	var SvgaManager = (function () {
	    function SvgaManager() {
	    }
	    SvgaManager.createSvga = function (name) {
	        var inst = new svga.Svga();
	        inst.source = engine.getAssetByName(name).uuid;
	        return inst;
	    };
	    SvgaManager.play = function (svga, callBack) {
	        if (!svga) {
	            console.log('svga节点出错');
	            return;
	        }
	        svga.gotoAndStop(0);
	        svga.play();
	        if (callBack) {
	            svga.addEventListener(engine.Event.END_FRAME, function () {
	                svga.stop();
	                callBack();
	                svga.removeAllEventListener();
	            }, this);
	        }
	    };
	    SvgaManager.stop = function (svga) {
	        if (!svga) {
	            console.log('svga节点出错');
	            return;
	        }
	        svga.stop();
	    };
	    return SvgaManager;
	}());
	//# sourceMappingURL=SvgaManager.js.map

	var SubjectTitle = (function (_super) {
	    tslib.__extends(SubjectTitle, _super);
	    function SubjectTitle() {
	        var _this = _super !== null && _super.apply(this, arguments) || this;
	        _this._frameCurrAngle = 0;
	        _this._frameCount = 0;
	        _this._countDownTmp = 0;
	        _this._square = new engine.Graphics();
	        return _this;
	    }
	    SubjectTitle.prototype.init = function () {
	        this.showSubjectBox();
	        this.insideAddEventListener();
	    };
	    SubjectTitle.prototype.initCountDownSvga = function (tmpNode) {
	        var countDownSvga = this._countDownSvga = SvgaManager.createSvga('countdown_321');
	        countDownSvga.x = (getStage().width - 120) / 2;
	        countDownSvga.y = (getStage().height - 120) / 2;
	        countDownSvga.visible = false;
	        tmpNode.addChild(countDownSvga);
	    };
	    SubjectTitle.prototype.insideAddEventListener = function () {
	        engine.globalEvent.addEventListener('updateSubjectTitle', this.updateSubjectTitle, this);
	        engine.globalEvent.addEventListener('updateAnswerCount', this.updateAnswerCount, this);
	        engine.globalEvent.addEventListener('resetTitle', this.reset, this);
	        engine.globalEvent.addEventListener('outRest', this.outRest, this);
	    };
	    SubjectTitle.prototype.showSubjectBox = function () {
	        var tmpContainer = new engine.Container();
	        tmpContainer.x = 0;
	        tmpContainer.y = props.subjectBox_Y;
	        this.addChild(tmpContainer);
	        var subjectBox = this._subjectTitleBox = new engine.Image(getTextureByName('题目栏'));
	        subjectBox.x = (750 - subjectBox.width) / 2;
	        subjectBox.y = 0;
	        tmpContainer.addChild(subjectBox);
	        var countDownBg = this._countDownBg = new engine.Image(getTextureByName('倒计时'));
	        countDownBg.x = (750 - countDownBg.width) / 2;
	        countDownBg.y = -countDownBg.height / 2 + 10;
	        tmpContainer.addChild(countDownBg);
	        var bar = this._bar = new engine.Image(getTextureByName('进度条'));
	        bar.x = 0;
	        bar.y = 0;
	        countDownBg.addChild(bar);
	        bar.anchorX = bar.width / 2;
	        bar.anchorY = bar.height / 2;
	        bar.rotation = -90;
	        bar.addChild(this._square);
	        bar.mask = this._square;
	        var answerCountBg = this._answerCountBg = new engine.Image(getTextureByName('答对题数'));
	        answerCountBg.x = (750 - answerCountBg.width) / 2;
	        answerCountBg.y = subjectBox.y + subjectBox.height - answerCountBg.height - 10;
	        tmpContainer.addChild(answerCountBg);
	        this.initCountDownBar(0);
	        this.initAnswerCountText();
	        this.initCountDownText();
	        this.initTitleText();
	        this.initSvga();
	    };
	    SubjectTitle.prototype.initCountDownText = function () {
	        var countDownText = this._countDownText = new engine.BitmapText();
	        countDownText.font = props.fontName;
	        countDownText.text = props.countDown;
	        this.handleAlign();
	        this._countDownBg.addChild(countDownText);
	        this._countDownTmp = props.countDown;
	    };
	    SubjectTitle.prototype.handleAlign = function () {
	        this._countDownText.x = (this._countDownBg.width - this._countDownText.width) / 2;
	        this._countDownText.y = (this._countDownBg.height - this._countDownText.height) / 2;
	    };
	    SubjectTitle.prototype.countDownBitmapText = function () {
	    };
	    SubjectTitle.prototype.initAnswerCountText = function () {
	        var answerCountText = this._answerCountText = new engine.Label();
	        answerCountText.fillColor = 0x2b3134;
	        answerCountText.size = 30;
	        answerCountText.width = this._answerCountBg.width;
	        answerCountText.height = this._answerCountBg.height;
	        answerCountText.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        answerCountText.x = 160;
	        answerCountText.y = props.answerCountText_Y;
	        answerCountText.text = '0';
	        this._answerCountBg.addChild(answerCountText);
	    };
	    SubjectTitle.prototype.initTitleText = function () {
	        var titleLabel = this._titleLabel = new engine.Label();
	        titleLabel.fillColor = 0xfffcc6;
	        titleLabel.size = 36;
	        titleLabel.width = this._subjectTitleBox.width - props.titleText_width;
	        titleLabel.height = this._subjectTitleBox.height - props.titleText_height;
	        titleLabel.lineType = engine.TEXT_lINETYPE.MULTI;
	        titleLabel.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        titleLabel.textAlign = engine.TEXT_ALIGN.CENTER;
	        titleLabel.x = props.titleText_X;
	        titleLabel.y = props.titleText_Y;
	        titleLabel.text = '';
	        titleLabel.alpha = 0;
	        this._subjectTitleBox.addChild(titleLabel);
	    };
	    SubjectTitle.prototype.initTitleNumText = function (tmpContainer) {
	        var titleNumLabel = this._titleNumLabel = new engine.Label();
	        titleNumLabel.fillColor = 0xfffcc6;
	        titleNumLabel.size = 48;
	        titleNumLabel.width = tmpContainer.width;
	        titleNumLabel.height = tmpContainer.heigth;
	        titleNumLabel.verticalAlign = engine.VERTICAL_ALIGN.MIDDLE;
	        titleNumLabel.textAlign = engine.TEXT_ALIGN.CENTER;
	        titleNumLabel.text = '';
	        titleNumLabel.visible = false;
	        tmpContainer.addChild(titleNumLabel);
	    };
	    SubjectTitle.prototype.updateTitleNumText = function (curSubJect) {
	        this.rest();
	        this._titleNumLabel.text = "\u7B2C" + curSubJect + "\u9898";
	    };
	    SubjectTitle.prototype.reset = function () {
	        this._titleLabel.text = '';
	    };
	    SubjectTitle.prototype.updateSubjectTitle = function (tmpData) {
	        this._titleLabel.alpha = 0;
	        this._titleLabel.text = tmpData.data.title;
	        this.lastTime = 0;
	        this.updateTitleNumText(tmpData.data.curSubJect + 1);
	        if (tmpData.data.curSubJect == 0) {
	            this.fristAnswer();
	        }
	        else {
	            this.playQuestion_enter();
	        }
	    };
	    SubjectTitle.prototype.updateAnswerCount = function (data) {
	        this._answerCountText.text = data.data.count + '';
	    };
	    SubjectTitle.prototype.updateCountDownText = function (count) {
	        this._countDownText.text = count + '';
	        this.handleAlign();
	    };
	    SubjectTitle.prototype.openCountDownBar = function () {
	        this.rest();
	        engine.gameStage.addEventListener(engine.Event.ENTER_FRAME, this.countDownBar, this);
	    };
	    SubjectTitle.prototype.initCountDownBar = function (currAngle) {
	        var ax = this._bar.width / 2;
	        var ay = this._bar.height / 2;
	        this._square.clear();
	        this._square.beginFill(0);
	        this._square.moveTo(ax, ay);
	        this._square.arc(ax, ay, this._bar.width / 2, 0, (currAngle * Math.PI / 180));
	        this._square.lineTo(ax, ay);
	        this._square.endFill();
	    };
	    SubjectTitle.prototype.countDownBar = function () {
	        var now = Date.now();
	        var deltaTime = this.lastTime ? now - this.lastTime : 16.7;
	        this.lastTime = now;
	        this._frameCurrAngle += 360 / (props.countDown * 1000) * deltaTime;
	        this._frameCurrAngle = Math.min(360, this._frameCurrAngle);
	        this.initCountDownBar(this._frameCurrAngle);
	        this._frameCount += deltaTime;
	        if (this._frameCount >= 1000) {
	            var tmpTime = this._countDownTmp - 1 > 0 ? this._countDownTmp -= 1 : 0;
	            if (tmpTime == 3) {
	                this.playCountDownSvga();
	            }
	            this.updateCountDownText(tmpTime);
	            this._frameCount = 0;
	            if (this._frameCurrAngle >= 360) {
	                engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.countDownBar, this);
	                engine.globalEvent.dispatchEvent('upDateGameState', { gameState: GameState.STATE_END });
	                engine.globalEvent.dispatchEvent('sendAnswer');
	            }
	        }
	    };
	    SubjectTitle.prototype.rest = function () {
	        this._frameCurrAngle = 0;
	        this._frameCount = 0;
	        this._square.clear();
	        this._countDownTmp = props.countDown;
	        this._countDownText.text = props.countDown + '';
	        this.handleAlign();
	    };
	    SubjectTitle.prototype.outRest = function () {
	        this._frameCurrAngle = 0;
	        this._frameCount = 0;
	        this._square.clear();
	        this._countDownTmp = props.countDown;
	        this._countDownText.text = props.countDown + '';
	        this.handleAlign();
	        this._readyGo.visible = false;
	        this._countDownSvga.visible = false;
	        this._questionEnter.visible = false;
	        engine.gameStage.removeEventListener(engine.Event.ENTER_FRAME, this.countDownBar, this);
	    };
	    SubjectTitle.prototype.initSvga = function () {
	        var readyGo = this._readyGo = SvgaManager.createSvga('ready_go');
	        readyGo.x = 50;
	        readyGo.y = 45;
	        readyGo.visible = false;
	        this._subjectTitleBox.addChild(readyGo);
	        var tmpRect = new engine.Rect();
	        tmpRect.x = 50;
	        tmpRect.y = 45;
	        tmpRect.width = 520;
	        tmpRect.height = 200;
	        this._subjectTitleBox.addChild(tmpRect);
	        readyGo.mask = tmpRect;
	        var tmpContainer = new engine.Container();
	        tmpContainer.width = 400;
	        tmpContainer.height = 100;
	        tmpContainer.x = (this._subjectTitleBox.width - 400) / 2;
	        tmpContainer.y = 115;
	        this._subjectTitleBox.addChild(tmpContainer);
	        var questionEnter = this._questionEnter = SvgaManager.createSvga('question_enter');
	        questionEnter.x = 0;
	        questionEnter.y = 0;
	        questionEnter.visible = false;
	        tmpContainer.addChild(questionEnter);
	        this.initTitleNumText(tmpContainer);
	    };
	    SubjectTitle.prototype.fristAnswer = function () {
	        this.playReadyGo();
	    };
	    SubjectTitle.prototype.playReadyGo = function () {
	        var _this = this;
	        this._readyGo.visible = true;
	        SvgaManager.play(this._readyGo, function () {
	            _this._readyGo.visible = false;
	            _this.playQuestion_enter();
	        });
	    };
	    SubjectTitle.prototype.playQuestion_enter = function () {
	        var _this = this;
	        this._questionEnter.visible = true;
	        this._titleNumLabel.visible = true;
	        SvgaManager.play(this._questionEnter, function () {
	            _this._questionEnter.visible = false;
	            _this.playTweenTitle();
	            _this._titleNumLabel.visible = false;
	            _this.openCountDownBar();
	            if (_this._countDownTmp == 3) {
	                _this.playCountDownSvga();
	            }
	            engine.globalEvent.dispatchEvent('start');
	        });
	    };
	    SubjectTitle.prototype.playTweenTitle = function () {
	        var _this = this;
	        engine.Tween.get(this._titleLabel, { loop: false })
	            .set({ alpha: 0 })
	            .to({ alpha: 1 }, 500, engine.Ease.cubicIn)
	            .call(function () {
	            engine.Tween.removeTweens(_this._titleLabel);
	        });
	    };
	    SubjectTitle.prototype.playCountDownSvga = function () {
	        var _this = this;
	        console.log('测试次数');
	        this._countDownSvga.visible = true;
	        this._countDownSvga.lockStep = true;
	        SvgaManager.play(this._countDownSvga, function () {
	            _this._countDownSvga.visible = false;
	        });
	    };
	    return SubjectTitle;
	}(engine.Container));
	//# sourceMappingURL=SubjectTitle.js.map

	var AnswerArea = (function (_super) {
	    tslib.__extends(AnswerArea, _super);
	    function AnswerArea() {
	        var _this = _super !== null && _super.apply(this, arguments) || this;
	        _this._optionArray = [];
	        _this._choiceWrong = [];
	        _this._choiceRight = [];
	        _this._choiceSelect = [];
	        _this._answerArray = ['A', 'B', 'C', 'D'];
	        _this._answer = -1;
	        _this._svgaArrayName = [];
	        return _this;
	    }
	    AnswerArea.prototype.init = function () {
	        var area = this._area = new engine.Container();
	        area.x = 0;
	        area.y = 0;
	        this._gameState = GameState.STATE_END;
	        this.addChild(area);
	        this.initSvgaArray();
	        this.initAnswerOption();
	        this.initPeople();
	        this.insideAddEventListener();
	    };
	    AnswerArea.prototype.initSvgaArray = function () {
	        this.setSvgaName('rian_mona', 'rian_weather');
	        this.setSvgaName('snow_mona', 'snow_weather');
	        this.setSvgaName('thunder_mona', 'thunder_weather');
	        this.setSvgaName('wind_mona', 'wind_weather');
	    };
	    AnswerArea.prototype.setSvgaName = function (peopleName, scene) {
	        var tmpSvgaName = {};
	        tmpSvgaName.people = peopleName;
	        tmpSvgaName.scene = scene;
	        this._svgaArrayName.push(tmpSvgaName);
	    };
	    AnswerArea.prototype.insideAddEventListener = function () {
	        engine.globalEvent.addEventListener('updateOption', this.updateOption, this);
	        engine.globalEvent.addEventListener('handleAnswerOption', this.handleAnswerOption, this);
	        engine.globalEvent.addEventListener('upDateGameState', this.upDateGameState, this);
	        engine.globalEvent.addEventListener('start', this.start, this);
	        engine.globalEvent.addEventListener('sendAnswer', this.sendAnswer, this);
	        engine.globalEvent.addEventListener('outRest', this.rest, this);
	    };
	    AnswerArea.prototype.initPeople = function () {
	        var people = this._people = SvgaManager.createSvga('mona_walk');
	        people.x = props.people_X;
	        people.y = props.people_Y;
	        this._area.addChild(people);
	        SvgaManager.play(people);
	        var mona_confuse = this._mona_confuse = SvgaManager.createSvga('mona_confuse');
	        mona_confuse.x = props.people_X;
	        mona_confuse.y = props.people_Y;
	        mona_confuse.visible = false;
	        this._area.addChild(mona_confuse);
	    };
	    AnswerArea.prototype.getArea = function () {
	        return this._area;
	    };
	    AnswerArea.prototype.initAnswerOption = function () {
	        var optionA = this._optionA = new engine.Image(getTextureByName('选区'));
	        optionA.x = (750 - (optionA.width * 2 + 30)) / 2;
	        optionA.y = props.answerArea_Y;
	        optionA.name = 'A';
	        optionA.alpha = 0;
	        this._area.addChild(optionA);
	        this._optionArray.push(optionA);
	        var optionB = this._optionB = new engine.Image(getTextureByName('选区'));
	        optionB.x = optionA.x + optionA.width + 30;
	        optionB.y = optionA.y;
	        optionB.name = 'B';
	        optionB.alpha = 0;
	        this._area.addChild(optionB);
	        this._optionArray.push(optionB);
	        var optionC = this._optionC = new engine.Image(getTextureByName('选区'));
	        optionC.x = optionA.x;
	        optionC.y = optionA.y + optionA.height + props.option_spaceY;
	        optionC.name = 'C';
	        optionC.alpha = 0;
	        this._area.addChild(optionC);
	        this._optionArray.push(optionC);
	        var optionD = this._optionD = new engine.Image(getTextureByName('选区'));
	        optionD.x = optionB.x;
	        optionD.y = optionC.y;
	        optionD.name = 'D';
	        optionD.alpha = 0;
	        this._area.addChild(optionD);
	        this._optionArray.push(optionD);
	        this.initOptionState();
	        this.initAddEventListener();
	        this.initSvga(optionA);
	        this.initSvga(optionB);
	        this.initSvga(optionC);
	        this.initSvga(optionD);
	    };
	    AnswerArea.prototype.initSvga = function (tmpNode) {
	        this.initSvgaNode('right_mona', tmpNode);
	        for (var index = 0; index < this._svgaArrayName.length; index++) {
	            var element = this._svgaArrayName[index];
	            this.initSvgaNode(element.people, tmpNode);
	            this.initSvgaNode(element.scene, tmpNode);
	        }
	    };
	    AnswerArea.prototype.initSvgaNode = function (svgaName, tmpNode) {
	        var tmpSvga = SvgaManager.createSvga(svgaName);
	        tmpSvga.x = -30;
	        tmpSvga.y = -105;
	        tmpSvga.visible = false;
	        tmpSvga.name = svgaName;
	        tmpNode.addChild(tmpSvga);
	    };
	    AnswerArea.prototype.initAddEventListener = function () {
	        for (var index = 0; index < this._optionArray.length; index++) {
	            var element = this._optionArray[index];
	            element.addEventListener(engine.MouseEvent.CLICK, this.selectOption, this);
	        }
	    };
	    AnswerArea.prototype.optionLabel = function (parent) {
	        var answerText = new engine.Label();
	        answerText.fillColor = 0x164b81;
	        answerText.bold = true;
	        answerText.size = 30;
	        answerText.width = parent.width;
	        answerText.height = parent.height;
	        answerText.textAlign = engine.TEXT_ALIGN.CENTER;
	        answerText.x = 0;
	        answerText.y = 0.75 * answerText.height;
	        answerText.text = '';
	        answerText.name = 'answerText';
	        return answerText;
	    };
	    AnswerArea.prototype.initOptionState = function () {
	        for (var i = 0; i < this._optionArray.length; i++) {
	            var tmpNode = this._optionArray[i];
	            tmpNode.addChild(this.getChoiceStateImg('选中', OptionState.CHOICE_SELECT, tmpNode.name));
	            tmpNode.addChild(this.getChoiceStateImg('选错', OptionState.CHOICE_WRONG, tmpNode.name));
	            tmpNode.addChild(this.getChoiceStateImg('选对', OptionState.CHOICE_RIGHT, tmpNode.name));
	            tmpNode.addChild(this.optionLabel(tmpNode));
	        }
	    };
	    AnswerArea.prototype.getChoiceStateImg = function (imgName, imgType, imgAnswer) {
	        var choiceImage = new engine.Image(getTextureByName(imgName));
	        choiceImage.x = 0;
	        choiceImage.y = 0;
	        choiceImage['type'] = imgType;
	        choiceImage['imgAnswer'] = imgAnswer;
	        choiceImage.visible = false;
	        switch (imgType) {
	            case OptionState.CHOICE_WRONG:
	                this._choiceWrong.push(choiceImage);
	                break;
	            case OptionState.CHOICE_RIGHT:
	                this._choiceRight.push(choiceImage);
	                break;
	            case OptionState.CHOICE_SELECT:
	                this._choiceSelect.push(choiceImage);
	                break;
	        }
	        return choiceImage;
	    };
	    AnswerArea.prototype.selectOption = function (event) {
	        if (this._gameState != GameState.STATE_START || this._svgaPlayState == GameState.STATE_START) {
	            console.log('暂时不能答题');
	            return;
	        }
	        this._gameState = GameState.STATE_END;
	        this.handleSelect(event.target.name);
	        this.peopleMove(event.target.x - 30, event.target.y - 110, false);
	        this._answer = this._answerArray.indexOf(event.target.name);
	        console.log('点击选择选项', event.target.name, this._answer);
	    };
	    AnswerArea.prototype.peopleMove = function (moveX, moveY, isPlaySVGA) {
	        var _this = this;
	        var tmpX = moveX;
	        var tmpY = moveY;
	        engine.Tween.get(this._people, { loop: false })
	            .to({ x: tmpX, y: tmpY }, 500, engine.Ease.cubicInOut)
	            .call(function () {
	            _this._gameState = GameState.STATE_START;
	            if (isPlaySVGA) {
	                SvgaManager.play(_this._people);
	                engine.globalEvent.dispatchEvent('updateSubject');
	            }
	        });
	    };
	    AnswerArea.prototype.rest = function () {
	        this._answer = -1;
	        if (this._right_mona) {
	            SvgaManager.stop(this._right_mona);
	            this._right_mona.visible = false;
	        }
	        this._people.visible = true;
	        this._mona_confuse.visible = false;
	        this.peopleMove(props.people_X, props.people_Y, true);
	        this.handleRight();
	        this.handleWrong();
	        this.handleSelect();
	        this.optionsShow(false);
	        engine.globalEvent.dispatchEvent('resetTitle');
	    };
	    AnswerArea.prototype.optionsShow = function (isShow) {
	        for (var index = 0; index < this._optionArray.length; index++) {
	            var element = this._optionArray[index];
	            var tmpAlpha = isShow ? 1 : 0;
	            this.optionIsShowTween(element, tmpAlpha);
	        }
	    };
	    AnswerArea.prototype.optionIsShowTween = function (tweenNode, tmpAlpha) {
	        engine.Tween.get(tweenNode, { loop: false })
	            .to({ alpha: tmpAlpha }, 500);
	    };
	    AnswerArea.prototype.handleSelect = function (select) {
	        for (var index = 0; index < this._choiceSelect.length; index++) {
	            var element = this._choiceSelect[index];
	            if (!select) {
	                element.visible = false;
	                continue;
	            }
	            if (element['imgAnswer'] === select) {
	                element.visible = true;
	                continue;
	            }
	            element.visible = false;
	        }
	    };
	    AnswerArea.prototype.handleRight = function (select) {
	        if (select === void 0) { select = ''; }
	        for (var index = 0; index < this._choiceRight.length; index++) {
	            var element = this._choiceRight[index];
	            if (select == '') {
	                element.visible = false;
	                continue;
	            }
	            if (element['imgAnswer'] === select) {
	                element.visible = true;
	                continue;
	            }
	            element.visible = false;
	        }
	    };
	    AnswerArea.prototype.handleWrong = function (select) {
	        var count = 0;
	        for (var index = 0; index < this._choiceWrong.length; index++) {
	            var element = this._choiceWrong[index];
	            if (!select) {
	                element.visible = false;
	                this.hideSvga(element);
	                continue;
	            }
	            if (element['imgAnswer'] == select) {
	                element.visible = false;
	                continue;
	            }
	            count++;
	            element.visible = true;
	            this.playWrongTween(element, (count == this._choiceWrong.length - 1));
	        }
	    };
	    AnswerArea.prototype.hideSvga = function (svgaNode) {
	        svgaNode.parent.children.forEach(function (element) {
	            if (element._instanceType == 'MovieClip') {
	                element.visible = false;
	            }
	        });
	    };
	    AnswerArea.prototype.playWrongTween = function (tweenNode, isLast) {
	        var _this = this;
	        engine.Tween.get(tweenNode, { loop: false })
	            .wait(460)
	            .to({ alpha: 0.3 }, 160, engine.Ease.circInOut)
	            .to({ alpha: 1 }, 160, engine.Ease.circInOut)
	            .to({ alpha: 0.3 }, 160, engine.Ease.circInOut)
	            .to({ alpha: 1 }, 160, engine.Ease.circInOut)
	            .call(function () {
	            engine.Tween.removeTweens(tweenNode);
	            if (isLast) {
	                if (_this._answer >= 0) {
	                    _this._people.visible = false;
	                    _this.handleSeceltRight();
	                    _this.handleSeceltError();
	                }
	                else {
	                    _this._people.visible = false;
	                    _this._mona_confuse.visible = true;
	                    SvgaManager.play(_this._mona_confuse, function () {
	                        _this.rest();
	                    });
	                }
	            }
	        });
	    };
	    AnswerArea.prototype.playResultSvga = function (svgaNode, isLast, isShowPeople) {
	        var _this = this;
	        var svgaData = this._svgaArrayName[this._randomSvga - 1];
	        if (isShowPeople) {
	            var peopleNode = this.getSvgaNode(svgaNode, svgaData.people);
	            this.playSvga(peopleNode);
	        }
	        var sceneNode = this.getSvgaNode(svgaNode, svgaData.scene);
	        this.playSvga(sceneNode, function () {
	            if (isLast)
	                _this.rest();
	        });
	    };
	    AnswerArea.prototype.getSvgaNode = function (svgaNode, svgaName) {
	        var tmp = svgaNode.getChildByName(svgaName);
	        if (!tmp) {
	            console.log('svga节点未找到');
	            return;
	        }
	        return tmp;
	    };
	    AnswerArea.prototype.playSvga = function (svgaNode, callBack) {
	        svgaNode.visible = true;
	        SvgaManager.play(svgaNode, function () {
	            svgaNode.visible = false;
	            if (callBack)
	                callBack();
	        });
	    };
	    AnswerArea.prototype.updateOption = function (optionData) {
	        this._randomSvga = Math.floor(Math.random() * (this._svgaArrayName.length) + 1);
	        var tmpOptionData = optionData.data.options;
	        for (var index = 0; index < tmpOptionData.length; index++) {
	            var element = tmpOptionData[index];
	            this._optionArray[index].getChildByName('answerText').text = element;
	        }
	    };
	    AnswerArea.prototype.handleAnswerOption = function (result) {
	        this._people.gotoAndStop(1);
	        var trueAnswer = this._trueAnswer = result.data.state;
	        this.handleRight(this._answerArray[trueAnswer]);
	        this.handleWrong(this._answerArray[trueAnswer]);
	        this.handleSelect();
	        this._svgaPlayState = GameState.STATE_START;
	    };
	    AnswerArea.prototype.handleSeceltRight = function () {
	        for (var index = 0; index < this._optionArray.length; index++) {
	            var element = this._optionArray[index];
	            if (element.name == this._answerArray[this._answer] && this._trueAnswer == this._answer) {
	                this._right_mona = this.getSvgaNode(element, 'right_mona');
	                if (this._right_mona) {
	                    this._right_mona.visible = true;
	                    SvgaManager.play(this._right_mona);
	                }
	            }
	        }
	    };
	    AnswerArea.prototype.handleSeceltError = function () {
	        var tmpNum = 0;
	        for (var index = 0; index < this._optionArray.length; index++) {
	            var element = this._optionArray[index];
	            if (element.name != this._answerArray[this._trueAnswer]) {
	                tmpNum++;
	                var isShowPeople = false;
	                if (element.name == this._answerArray[this._answer]) {
	                    isShowPeople = true;
	                }
	                this.playResultSvga(element, (tmpNum == 3), isShowPeople);
	            }
	        }
	    };
	    AnswerArea.prototype.upDateGameState = function (gameState) {
	        this._gameState = gameState.data.gameState;
	    };
	    AnswerArea.prototype.start = function () {
	        this.optionsShow(true);
	        this._gameState = GameState.STATE_START;
	        this._svgaPlayState = GameState.STATE_END;
	    };
	    AnswerArea.prototype.sendAnswer = function () {
	        engine.globalEvent.dispatchEvent('sendAnswerResult', { answer: this._answer });
	    };
	    return AnswerArea;
	}(engine.Container));
	//# sourceMappingURL=answerArea.js.map

	var GameView = (function (_super) {
	    tslib.__extends(GameView, _super);
	    function GameView() {
	        return _super.call(this) || this;
	    }
	    GameView.prototype.setup = function () {
	        if (this._hasSetup) {
	            return;
	        }
	        this._hasSetup = true;
	        var backgroud = this._backgroud = new Background();
	        this.addChild(backgroud);
	        backgroud.init();
	        var subject = this._subject = new SubjectTitle();
	        this.addChild(subject);
	        subject.init();
	        var answerArea = this._answerArea = new AnswerArea();
	        this.addChild(answerArea);
	        answerArea.init();
	        var tmpContainer = new engine.Container();
	        this.addChildAt(tmpContainer, 50);
	        subject.initCountDownSvga(tmpContainer);
	        var subjectManager = this._subjectManager = new SubjectManager();
	        subjectManager.init();
	    };
	    GameView.prototype.start = function () {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            return tslib.__generator(this, function (_a) {
	                this.setup();
	                return [2];
	            });
	        });
	    };
	    return GameView;
	}(engine.Container));
	//# sourceMappingURL=GameView.js.map

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener('answer-game-start', _this.start, _this);
	        engine.globalEvent.addEventListener('answer-game-subject', _this.initSubject, _this);
	        engine.globalEvent.addEventListener('answer-game-result', _this.result, _this);
	        _this.visibilitychange();
	        return _this;
	    }
	    GameWrapper.prototype.start = function (event) {
	        if (event.data.countDown) {
	            props.countDown = event.data.countDown;
	        }
	        if (!this._gameView) {
	            var gameView = this._gameView = new GameView();
	            this.addChild(gameView);
	            this._gameView.start();
	        }
	        engine.globalEvent.dispatchEvent('reset');
	    };
	    GameWrapper.prototype.initSubject = function (event) {
	        var subjectData = event.data.subjectData;
	        engine.globalEvent.dispatchEvent('handleOption', subjectData);
	    };
	    GameWrapper.prototype.result = function (event) {
	        var result = event.data.result;
	        engine.globalEvent.dispatchEvent('handleResult', { result: result });
	    };
	    GameWrapper.prototype.visibilitychange = function () {
	        document.addEventListener('visibilitychange', function () {
	            if (document.visibilityState === 'hidden') {
	                console.log('放置后台');
	                engine.globalEvent.dispatchEvent('outRest');
	                engine.globalEvent.dispatchEvent('answer-game-visibilitychange', { hidden: true });
	            }
	        });
	    };
	    return GameWrapper;
	}(engine.Container));
	//# sourceMappingURL=GameWrapper.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map