/**
 * Created by rockyl on 2019-12-16.
 */

const customId = 'answer-game';

(async function () {
	let customModule = await fetch(`../meta.json`);
	customModule = await customModule.json();
	console.log(customModule);

	await loadAssets(customModule.assets);
	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	//engine.registerCustomCodeModule(customModule);
	engine.registerCustomModule(customId, window[customId]);

	const {props: propsOption, assets} = customModule;
	let props = engine.computeProps(customModuleProps, propsOption);
	const customModuleIns = {
		id: customId,
		props,
		assets,
	};

	engine.registerCustomModules([customModuleIns]);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		views: [{
			name: 'entry',
			type: 'node',
			properties: {
				x: 0,
				y: 0,
			}
		}],
	}, null, function () {
		
		setTimeout(() => {
			engine.addCustomModule(customId, engine.gameStage.sceneContainer.getChildAt(0));
		}, 100);

		setTimeout(() => {
			let questionList = [
				{
					"question":"这是第一题",
					"index":0,
					"options":[
						"第一题答案A",
						"第一题答案B",
						"第一题答案C",
						"第一题答案D"
					]
				},
				{
					"question":"这是第二题",
					"index":2,
					"options":[
						"第二题答案A",
						"第二题答案B",
						"第二题答案C",
						"第二题答案D"
					]
				}
			]
			engine.globalEvent.dispatchEvent('answer-game-start', {countDown: 10});
			engine.globalEvent.dispatchEvent('answer-game-subject', {subjectData:questionList});
		}, 500);

	});
}

function getAssetByUUID(uuid) {
	return engine.resolveCustomAsset(customId, uuid);
}

function getProps() {
	return engine.getProps(customId);
}
