/** Declaration file generated by dts-gen */
declare module Matter{
export const name: string;

export const used: any[];

export const uses: any[];

export const version: string;

export function after(path: any, func: any): any;

export function before(path: any, func: any): any;

export function use(...args: any[]): void;

export namespace Axes {
    function fromVertices(vertices: any): any;

    function rotate(axes: any, angle: any): void;

}

export namespace Bodies {
    function circle(x: any, y: any, radius: any, options: any, maxSides: any): any;

    function fromVertices(x: any, y: any, vertexSets: any, options: any, flagInternal: any, removeCollinear: any, minimumArea: any): any;

    function polygon(x: any, y: any, sides: any, radius: any, options: any): any;

    function rectangle(x: any, y: any, width: any, height: any, options: any): any;

    function trapezoid(x: any, y: any, width: any, height: any, slope: any, options: any): any;

}

export namespace Body {
    function applyForce(body: any, position: any, force: any): void;

    function create(options: any): any;

    function nextCategory(): any;

    function nextGroup(isNonColliding: any): any;

    function rotate(body: any, rotation: any, point: any): void;

    function scale(body: any, scaleX: any, scaleY: any, point: any): void;

    function set(body: any, settings: any, value: any): void;

    function setAngle(body: any, angle: any): void;

    function setAngularVelocity(body: any, velocity: any): void;

    function setDensity(body: any, density: any): void;

    function setInertia(body: any, inertia: any): void;

    function setMass(body: any, mass: any): void;

    function setParts(body: any, parts: any, autoHull: any): void;

    function setPosition(body: any, position: any): void;

    function setStatic(body: any, isStatic: any): void;

    function setVelocity(body: any, velocity: any): void;

    function setVertices(body: any, vertices: any): void;

    function translate(body: any, translation: any): void;

    function update(body: any, deltaTime: any, timeScale: any, correction: any): void;

}

export namespace Bounds {
    function contains(bounds: any, point: any): any;

    function create(vertices: any): any;

    function overlaps(boundsA: any, boundsB: any): any;

    function shift(bounds: any, position: any): void;

    function translate(bounds: any, vector: any): void;

    function update(bounds: any, vertices: any, velocity: any): void;

}

export namespace Common {
    const logLevel: number;

    function chain(...args: any[]): any;

    function chainPathAfter(base: any, path: any, func: any): any;

    function chainPathBefore(base: any, path: any, func: any): any;

    function choose(choices: any): any;

    function clamp(value: any, min: any, max: any): any;

    function clone(obj: any, deep: any): any;

    function colorToNumber(colorString: any): any;

    function extend(obj: any, deep: any, ...args: any[]): any;

    function get(obj: any, path: any, begin: any, end: any): any;

    function indexOf(haystack: any, needle: any): any;

    function info(...args: any[]): void;

    function isArray(obj: any): any;

    function isElement(obj: any): any;

    function isFunction(obj: any): any;

    function isPlainObject(obj: any): any;

    function isString(obj: any): any;

    function keys(obj: any): any;

    function log(...args: any[]): void;

    function map(list: any, func: any): any;

    function nextId(): any;

    function now(): any;

    function random(min: any, max: any): any;

    function set(obj: any, path: any, val: any, begin: any, end: any): any;

    function shuffle(array: any): any;

    function sign(value: any): any;

    function topologicalSort(graph: any): any;

    function values(obj: any): any;

    function warn(...args: any[]): void;

}

export namespace Composite {
    function add(composite: any, object: any): any;

    function addBody(composite: any, body: any): any;

    function addComposite(compositeA: any, compositeB: any): any;

    function addConstraint(composite: any, constraint: any): any;

    function allBodies(composite: any): any;

    function allComposites(composite: any): any;

    function allConstraints(composite: any): any;

    function bounds(composite: any): any;

    function clear(composite: any, keepStatic: any, deep: any): any;

    function create(options: any): any;

    function get(composite: any, id: any, type: any): any;

    function move(compositeA: any, objects: any, compositeB: any): any;

    function rebase(composite: any): any;

    function remove(composite: any, object: any, deep: any): any;

    function removeBody(composite: any, body: any, deep: any): any;

    function removeBodyAt(composite: any, position: any): any;

    function removeComposite(compositeA: any, compositeB: any, deep: any): any;

    function removeCompositeAt(composite: any, position: any): any;

    function removeConstraint(composite: any, constraint: any, deep: any): any;

    function removeConstraintAt(composite: any, position: any): any;

    function rotate(composite: any, rotation: any, point: any, recursive: any): any;

    function scale(composite: any, scaleX: any, scaleY: any, point: any, recursive: any): any;

    function setModified(composite: any, isModified: any, updateParents: any, updateChildren: any): void;

    function translate(composite: any, translation: any, recursive: any): any;

}

export namespace Composites {
    function car(xx: any, yy: any, width: any, height: any, wheelSize: any): any;

    function chain(composite: any, xOffsetA: any, yOffsetA: any, xOffsetB: any, yOffsetB: any, options: any): any;

    function mesh(composite: any, columns: any, rows: any, crossBrace: any, options: any): any;

    function newtonsCradle(xx: any, yy: any, number: any, size: any, length: any): any;

    function pyramid(xx: any, yy: any, columns: any, rows: any, columnGap: any, rowGap: any, callback: any): any;

    function softBody(xx: any, yy: any, columns: any, rows: any, columnGap: any, rowGap: any, crossBrace: any, particleRadius: any, particleOptions: any, constraintOptions: any): any;

    function stack(xx: any, yy: any, columns: any, rows: any, columnGap: any, rowGap: any, callback: any): any;

}

export namespace Constraint {
    function create(options: any): any;

    function postSolveAll(bodies: any): void;

    function preSolveAll(bodies: any): void;

    function solve(constraint: any, timeScale: any): void;

    function solveAll(constraints: any, timeScale: any): void;

}

export namespace Contact {
    function create(vertex: any): any;

    function id(vertex: any): any;

}

export namespace Detector {
    function canCollide(filterA: any, filterB: any): any;

    function collisions(broadphasePairs: any, engine: any): any;

}

export namespace Engine {
    function clear(engine: any): void;

    function create(element: any, options: any): any;

    function merge(engineA: any, engineB: any): void;

    function run(runner: any, engine: any): any;

    function update(engine: any, delta: any, correction: any): any;

}

export namespace Events {
    function off(object: any, eventNames: any, callback: any): void;

    function on(object: any, eventNames: any, callback: any): any;

    function trigger(object: any, eventNames: any, event: any): void;

}

export namespace Grid {
    function clear(grid: any): void;

    function create(options: any): any;

    function update(grid: any, bodies: any, engine: any, forceUpdate: any): void;

}

export namespace Mouse {
    function clearSourceEvents(mouse: any): void;

    function create(element: any): any;

    function setElement(mouse: any, element: any): void;

    function setOffset(mouse: any, offset: any): void;

    function setScale(mouse: any, scale: any): void;

}

export namespace MouseConstraint {
    function create(engine: any, options: any): any;

    function update(mouseConstraint: any, bodies: any): void;

}

export namespace Pair {
    function create(collision: any, timestamp: any): any;

    function id(bodyA: any, bodyB: any): any;

    function setActive(pair: any, isActive: any, timestamp: any): void;

    function update(pair: any, collision: any, timestamp: any): void;

}

export namespace Pairs {
    function clear(pairs: any): any;

    function create(options: any): any;

    function removeOld(pairs: any, timestamp: any): void;

    function update(pairs: any, collisions: any, timestamp: any): void;

}

export namespace Plugin {
    function dependencies(module: any, tracked: any): any;

    function dependencyParse(dependency: any): any;

    function isFor(plugin: any, module: any): any;

    function isPlugin(obj: any): any;

    function isUsed(module: any, name: any): any;

    function register(plugin: any): any;

    function resolve(dependency: any): any;

    function toString(plugin: any): any;

    function use(module: any, plugins: any): void;

    function versionParse(range: any): any;

    function versionSatisfies(version: any, range: any): any;

}

export namespace Query {
    function collides(body: any, bodies: any): any;

    function point(bodies: any, point: any): any;

    function ray(bodies: any, startPoint: any, endPoint: any, rayWidth: any): any;

    function region(bodies: any, bounds: any, outside: any): any;

}

export namespace Render {
    function bodies(render: any, bodies: any, context: any): void;

    function bodyAxes(render: any, bodies: any, context: any): void;

    function bodyBounds(render: any, bodies: any, context: any): void;

    function bodyConvexHulls(render: any, bodies: any, context: any): void;

    function bodyIds(render: any, bodies: any, context: any): void;

    function bodyPositions(render: any, bodies: any, context: any): void;

    function bodyShadows(render: any, bodies: any, context: any): void;

    function bodyVelocity(render: any, bodies: any, context: any): void;

    function bodyWireframes(render: any, bodies: any, context: any): void;

    function collisions(render: any, pairs: any, context: any): void;

    function constraints(constraints: any, context: any): void;

    function create(options: any): any;

    function debug(render: any, context: any): void;

    function endViewTransform(render: any): void;

    function grid(render: any, grid: any, context: any): void;

    function inspector(inspector: any, context: any): void;

    function lookAt(render: any, objects: any, padding: any, center: any): void;

    function mousePosition(render: any, mouse: any, context: any): void;

    function run(render: any): void;

    function separations(render: any, pairs: any, context: any): void;

    function setPixelRatio(render: any, pixelRatio: any): void;

    function startViewTransform(render: any): void;

    function stop(render: any): void;

    function vertexNumbers(render: any, bodies: any, context: any): void;

    function world(render: any): void;

}

export namespace RenderPixi {
    function body(render: any, body: any): void;

    function clear(render: any): void;

    function constraint(render: any, constraint: any): void;

    function create(options: any): any;

    function run(render: any): void;

    function setBackground(render: any, background: any): void;

    function stop(render: any): void;

    function world(render: any): void;

}

export namespace Resolver {
    function postSolvePosition(bodies: any): void;

    function preSolvePosition(pairs: any): void;

    function preSolveVelocity(pairs: any): void;

    function solvePosition(pairs: any, timeScale: any): void;

    function solveVelocity(pairs: any, timeScale: any): void;

}

export namespace Runner {
    function create(options: any): any;

    function run(runner: any, engine: any): any;

    function start(runner: any, engine: any): void;

    function stop(runner: any): void;

    function tick(runner: any, engine: any, time: any): void;

}

export namespace SAT {
    function collides(bodyA: any, bodyB: any, previousCollision: any): any;

}

export namespace Sleeping {
    function afterCollisions(pairs: any, timeScale: any): void;

    function set(body: any, isSleeping: any): void;

    function update(bodies: any, timeScale: any): void;

}

export namespace Svg {
    function pathToVertices(path: any, sampleLength: any): any;

}

export namespace Vector {
    function add(vectorA: any, vectorB: any, output: any): any;

    function angle(vectorA: any, vectorB: any): any;

    function clone(vector: any): any;

    function create(x: any, y: any): any;

    function cross(vectorA: any, vectorB: any): any;

    function cross3(vectorA: any, vectorB: any, vectorC: any): any;

    function div(vector: any, scalar: any): any;

    function dot(vectorA: any, vectorB: any): any;

    function magnitude(vector: any): any;

    function magnitudeSquared(vector: any): any;

    function mult(vector: any, scalar: any): any;

    function neg(vector: any): any;

    function normalise(vector: any): any;

    function perp(vector: any, negate: any): any;

    function rotate(vector: any, angle: any, output: any): any;

    function rotateAbout(vector: any, angle: any, point: any, output: any): any;

    function sub(vectorA: any, vectorB: any, output: any): any;

}

export namespace Vertices {
    function area(vertices: any, signed: any): any;

    function centre(vertices: any): any;

    function chamfer(vertices: any, radius: any, quality: any, qualityMin: any, qualityMax: any): any;

    function clockwiseSort(vertices: any): any;

    function contains(vertices: any, point: any): any;

    function create(points: any, body: any): any;

    function fromPath(path: any, body: any): any;

    function hull(vertices: any): any;

    function inertia(vertices: any, mass: any): any;

    function isConvex(vertices: any): any;

    function mean(vertices: any): any;

    function rotate(vertices: any, angle: any, point: any): any;

    function scale(vertices: any, scaleX: any, scaleY: any, point: any): any;

    function translate(vertices: any, vector: any, scalar: any): any;

}

export namespace World {
    function add(composite: any, object: any): any;

    function addBody(composite: any, body: any): any;

    function addComposite(compositeA: any, compositeB: any): any;

    function addConstraint(composite: any, constraint: any): any;

    function clear(composite: any, keepStatic: any, deep: any): any;

    function create(options: any): any;

    function remove(composite: any, object: any, deep: any): any;

}
}
