"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var localWave = (function () {
    function localWave() {
        this._oldProperties = {};
        this._t = 0;
    }
    localWave.prototype.init = function (target, duration, calProps, loop, autoPlay, reverse, delay, offset) {
        if (calProps === void 0) { calProps = null; }
        if (loop === void 0) { loop = 0; }
        if (autoPlay === void 0) { autoPlay = true; }
        if (reverse === void 0) { reverse = false; }
        if (delay === void 0) { delay = 0; }
        if (offset === void 0) { offset = 0; }
        this.target = target;
        this._calProps = calProps ? calProps : localWave.round;
        this.duration = duration;
        this.loop = loop;
        this.reverse = reverse;
        this.delay = delay;
        this.offset = offset;
        this.updateRegisterPos();
        if (autoPlay) {
            this.play();
        }
    };
    localWave.prototype.updateRegisterPos = function () {
        this._oldProperties.x = this.target.x;
        this._oldProperties.y = this.target.y;
        this._oldProperties.scaleX = this.target.scaleX;
        this._oldProperties.scaleY = this.target.scaleY;
        this._oldProperties.skewX = this.target.skewX;
        this._oldProperties.skewY = this.target.skewY;
        this._oldProperties.rotation = this.target.rotation;
        this._oldProperties.alpha = this.target.alpha;
    };
    localWave.prototype.play = function () {
        if (this._tween) {
            return this._tween;
        }
        this._count = 0;
        return this._playStep();
    };
    localWave.prototype._playStep = function () {
        if (this.loop > 0 && this._count >= this.loop) {
            this.stop();
            return;
        }
        this._count++;
        this.t = this.reverse ? Math.PI * 2 : 0;
        this._tween = engine.Tween.get(this);
        this._tween.wait(this.delay).to({ t: this.reverse ? 0 : Math.PI * 2 }, this.duration).call(this._playStep, this);
        return this._tween;
    };
    Object.defineProperty(localWave.prototype, "t", {
        get: function () {
            return this._t;
        },
        set: function (value) {
            if (!this.target.stage) {
                return;
            }
            this._t = value;
            var props = this._calProps.call(this, this._t + this.offset);
            if (props.hasOwnProperty('x')) {
                this.target.x = (props.x || 0) + this._oldProperties.x;
            }
            if (props.hasOwnProperty('y')) {
                this.target.y = (props.y || 0) + this._oldProperties.y;
            }
            if (props.hasOwnProperty('sx')) {
                this.target.scaleX = props.sx;
            }
            if (props.hasOwnProperty('sy')) {
                this.target.scaleY = props.sy;
            }
            if (props.hasOwnProperty('skewX')) {
                this.target.skewX = props.skewX;
            }
            if (props.hasOwnProperty('skewY')) {
                this.target.skewY = props.skewY;
            }
            if (props.hasOwnProperty('r')) {
                this.target.rotation = props.r;
            }
            if (props.hasOwnProperty('alpha')) {
                this.target.alpha = props.alpha;
            }
        },
        enumerable: true,
        configurable: true
    });
    localWave.prototype.stop = function (recovery, animation, duration) {
        if (recovery === void 0) { recovery = false; }
        if (animation === void 0) { animation = false; }
        if (duration === void 0) { duration = 1000; }
        if (!this._tween) {
            return;
        }
        engine.Tween.removeTweens(this);
        if (recovery) {
            engine.Tween.get(this.target).to(this._oldProperties, duration);
        }
        this._tween = null;
    };
    Object.defineProperty(localWave.prototype, "playing", {
        get: function () {
            return this._tween != null;
        },
        enumerable: true,
        configurable: true
    });
    localWave.round = function (h, t) {
        return { x: Math.cos(t) * h, y: Math.sin(t) * h };
    };
    localWave.cos = function (h, t) {
        return { x: Math.cos(t) * h, y: 0 };
    };
    localWave.sin = function (h, t) {
        h = h || 1;
        return { x: 0, y: Math.sin(t) * h };
    };
    localWave.rotate = function (t) {
        return { r: 360 * t / Math.PI / 2 };
    };
    localWave.shake = function (angle, count, t) {
        return { r: Math.sin(t * count) * angle };
    };
    localWave.breath = function (scale, t) {
        return { sx: Math.sin(t) * scale + 1, sy: -Math.sin(t + Math.PI / 4) * scale + 1 };
    };
    localWave.zoom = function (scale, t) {
        scale = scale || 0.1;
        return { sx: Math.sin(t) * scale + 1, sy: Math.sin(t) * scale + 1 };
    };
    localWave.fade = function (base, t) {
        return { alpha: (Math.sin(t) + 1) * 0.5 + base };
    };
    return localWave;
}());
exports.localWave = localWave;
