"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var localWave_1 = require("./../localWave");
var ObjectPool = engine.ObjectPool;
var utils_1 = require("./utils");
var utils_2 = require("./utils");
var props_1 = require("../props");
var Block_1 = require("./Block");
var Road = (function (_super) {
    __extends(Road, _super);
    function Road() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dustIndex = 0;
        _this.index = 0;
        _this.minDistance = parseInt(props_1.props.blockMinDistance) || 100;
        _this.maxDistance = parseInt(props_1.props.blockMaxDistance) || 300;
        _this.basePos = utils_1.getStage().width / 2 - 100;
        _this.padding = 500;
        return _this;
    }
    Road.prototype.preSetup = function () {
        this.addChild(this.container = new engine.Container());
        var flag = this.flag = new engine.Sprite(utils_2.getTextureByName('flag_record'));
        this.anchorRate(flag, 0.5, 1);
        flag.y = -230;
        flag.x = this.transScoreToFlagPos();
        flag.visible = flag.x > 0;
        this.addChild(flag);
    };
    Road.prototype.setup = function () {
        this.dustNode = new engine.Container();
        this.dustSprite = new engine.Sprite();
        this.dustSprite.visible = false;
        this.dustNode.y = -1000;
        this.dustNode.x = -450;
        this.dustNode.addChild(this.dustSprite);
        this.addChild(this.dustNode);
        var reward = this.reward = new engine.Sprite();
        reward.visible = false;
        reward.y = -500;
        this.addChild(reward);
        this.aniReward = new localWave_1.localWave();
        this.aniReward.init(reward, 2000, localWave_1.localWave.sin.bind(null, 10));
    };
    Road.prototype.start = function (revive) {
        if (revive === void 0) { revive = false; }
        if (revive) {
        }
        else {
            this.rewardIndex = 0;
            this.showReward();
        }
    };
    Road.prototype.reset = function (revive) {
        if (revive === void 0) { revive = false; }
        if (!revive) {
            this.index = 0;
            this.lastPos = 0;
            this.clear();
            this.fill();
            this.flag.x = this.transScoreToFlagPos();
            this.flag.visible = this.flag.x > 0;
        }
    };
    Road.prototype.anchorRate = function (target, rx, ry, width, height, resetPos) {
        if (width === void 0) { width = 0; }
        if (height === void 0) { height = 0; }
        if (resetPos === void 0) { resetPos = true; }
        if (width == 0) {
            width = target.width;
        }
        if (height == 0) {
            height = target.height;
        }
        if (resetPos) {
            if (rx == 0) {
                target.x -= target.anchorOffsetX;
            }
            if (ry == 0) {
                target.y -= target.anchorOffsetY;
            }
        }
        target.anchorOffsetX = width * rx;
        target.anchorOffsetY = height * ry;
        if (resetPos) {
            if (rx > 0) {
                target.x += target.anchorOffsetX;
            }
            if (ry > 0) {
                target.y += target.anchorOffsetY;
            }
        }
    };
    Road.prototype.transScoreToFlagPos = function () {
        return -1;
    };
    Road.prototype.clear = function () {
        while (this.container.children.length > 0) {
            this.removeBlockAt(0);
        }
    };
    Road.prototype.addBlock = function () {
        var type = 0, v;
        if (this.index > 10) {
            do {
                var rv = Math.random();
                v = 0;
                for (var i = 0; i < 5; i++) {
                    v += Block_1.Block.configs[i].ratio;
                    if (rv < v) {
                        type = i;
                        break;
                    }
                }
            } while (this.lastBlockType == type);
            this.lastBlockType = type;
        }
        var block = ObjectPool.getObject('block', { type: type });
        var width = Block_1.Block.configs[type].width;
        var distance = this.index == 0 ?
            this.maxDistance :
            this.makeRandomFloat(this.maxDistance, this.minDistance);
        var pos = this.lastPos + distance;
        block.x = pos;
        this.container.addChild(block);
        this.lastPos = pos + width;
        this.index++;
    };
    Road.prototype.removeBlockAt = function (index) {
        var block = this.container.removeChildAt(index);
        ObjectPool.recycleObject('block', block);
    };
    Road.prototype.removeBlock = function (block) {
        this.container.removeChild(block);
        ObjectPool.recycleObject('block', block);
    };
    Road.prototype.fill = function () {
        if (isNaN(this.lastPos)) {
            return;
        }
        while (true) {
            if (this.lastPos + this.x > utils_1.getStage().width + this.padding) {
                break;
            }
            this.addBlock();
        }
    };
    Road.prototype.makeRandomFloat = function (max, min) {
        if (min === void 0) { min = 0; }
        return Math.random() * (max - min) + min;
    };
    Road.prototype.setViewport = function (pos) {
        this.x = this.basePos - pos;
        while (this.container.children.length > 0) {
            if (this.container.getChildAt(0).x >= pos - this.padding) {
                break;
            }
            this.removeBlockAt(0);
        }
        this.fill();
    };
    Road.prototype.showReward = function (type) {
        if (type === void 0) { type = 10; }
        this.rewardIndex++;
        var pos = this.rewardIndex * utils_1.getStage().width * 3;
        var reward = this.reward;
        reward.visible = true;
        reward.alpha = 1;
        reward.texture = utils_2.getTextureByName('menu_block_10');
        reward.x = pos;
        this.aniReward.updateRegisterPos();
    };
    Road.prototype.hideReward = function () {
        var _this = this;
        var reward = this.reward;
        this.tweenReward = engine.Tween.get(reward)
            .to({ alpha: 0 }, 200)
            .call(function () {
            _this.tweenReward = null;
            _this.showReward();
        });
    };
    Road.prototype.hitReward = function (pos) {
        if (this.reward.visible && pos >= this.reward.x && !this.tweenReward) {
            this.hideReward();
            return true;
        }
    };
    Road.prototype.playDust = function (pos) {
        this.dustSprite.x = pos;
        this.dustSprite.visible = true;
        this.addEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    Road.prototype.onEnterFrame = function () {
        if (this.dustIndex < 12) {
            this.dustSprite.texture = utils_2.getTextureByName('dust_' + this.dustIndex);
            this.dustIndex++;
        }
        else {
            this.dustIndex = 0;
            this.dustSprite.visible = false;
            this.removeEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
        }
    };
    Road.prototype.hitBlock = function (pos) {
        var _this = this;
        var target, lastTarget;
        var foot = { a: pos - 84 / 2, b: pos + 84 / 2 };
        this.container.children.some(function (block, i) {
            var width = Block_1.Block.configs[block.type].width;
            var line = { a: block.x - width / 2, b: block.x + width / 2 };
            if (_this.lineHitTest(foot, line)) {
                target = block;
                return true;
            }
        });
        if (!target) {
            for (var i = this.container.children.length; i > 0; i--) {
                var block = this.container.getChildAt(i - 1);
                if (block.x < pos) {
                    lastTarget = block;
                    break;
                }
            }
        }
        return {
            target: target,
            lastTarget: lastTarget,
        };
    };
    Road.prototype.lineHitTest = function (l0, l1) {
        return l0.a < l1.b && l0.b > l1.a;
    };
    return Road;
}(engine.Container));
exports.Road = Road;
