"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var LoopComponent_1 = require("./LoopComponent");
var utils_2 = require("./utils");
var Background = (function (_super) {
    __extends(Background, _super);
    function Background() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.partRes = ['bg_far', 'bg_mid', 'bg_near'];
        _this.speeds = [0.05, 0.5, 1];
        return _this;
    }
    Background.prototype.setup = function () {
        var bottomBg = new engine.Rect();
        bottomBg.x = 0;
        bottomBg.y = 0;
        bottomBg.width = utils_2.getStage().width;
        bottomBg.height = 0;
        bottomBg.fillColor = 0x75c9f5;
        this.addChild(bottomBg);
        var parts = [];
        for (var i = 0; i < 3; i++) {
            var part = new LoopComponent_1.LoopComponent();
            part.setupLoop([
                this.partRes[i],
                this.partRes[i],
            ]);
            parts.push(part);
            this.addChild(part);
        }
        var height = utils_2.getStage().height;
        parts[0].y = (height - parts[0].height) / 2 - 400;
        parts[1].y = (height - parts[1].height) / 2 - 120;
        parts[2].y = (height - parts[2].height) / 2 + 300;
        bottomBg.y = parts[2].y;
        bottomBg.height = height - parts[2].y;
        var moon = new engine.Sprite(utils_1.getTextureByName('moon'));
        moon.x = 100;
        moon.y = 100;
        this.addChild(moon);
    };
    Background.prototype.setViewport = function (pos) {
        for (var i = 0; i < 3; i++) {
            var part = this.getChildAt(i + 1);
            var speed = this.speeds[i];
            part.setViewport(pos * speed);
        }
    };
    Background.prototype.reset = function (revive) {
        if (revive === void 0) { revive = false; }
    };
    return Background;
}(engine.Container));
exports.Background = Background;
