"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameObject_1 = require("./GameObject");
var Collider_1 = require("../Phycics/Collider");
var MConst_1 = require("../Global/MConst");
var Bullet_1 = require("./Bullet");
var SoundMgr_1 = require("../Mgr/SoundMgr");
var MTimer_1 = require("../Global/MTimer");
var props_1 = require("../../props");
var DataMgr_1 = require("../Mgr/DataMgr");
var utils_1 = require("../utils");
var Car = (function (_super) {
    __extends(Car, _super);
    function Car() {
        var _this = _super.call(this) || this;
        _this.imgParticel = null;
        _this.fireTimer = null;
        _this.touchWall = 0;
        _this.isDied = false;
        _this.fireParticleTimer = 0;
        _this.invincible = false;
        _this.rowBulletNum = 1;
        _this.fireSpeed = MConst_1.MConst.BulletFireSpeed.min;
        var carCollidePaddingX = props_1.props.carCollidePaddingX, carCollidePaddingY = props_1.props.carCollidePaddingY;
        var sprite = new engine.Sprite(utils_1.getTexture("ddf5128e-be66-4c00-8505-e4167aac37bc"));
        sprite.x = 0;
        sprite.y = 16;
        _this.addChild(sprite);
        var particle = new engine.Sprite(utils_1.getTexture("d8daa113-0d75-4139-9e81-c54b7522c890"));
        particle.x = (sprite.width - particle.width) / 2;
        particle.y = 0;
        _this.addChild(particle);
        _this.imgParticel = particle;
        MTimer_1.default.onFrame("Car", _this.onUpdate, _this);
        var collider = _this.collider = _this.addComponent(Collider_1.RectCollider);
        collider.setData(carCollidePaddingX, carCollidePaddingY, sprite.width - carCollidePaddingX * 2, sprite.height - carCollidePaddingY * 2);
        collider.group = Collider_1.ColliderGroup.Car;
        return _this;
    }
    Car.prototype.fire = function () {
        SoundMgr_1.default.instance.playEffect("shoot");
        new Bullet_1.BulletGroup(new engine.Point(this.x + this.width / 2, this.y), this.rowBulletNum);
    };
    Car.prototype.die = function () {
        if (this.invincible)
            return;
        if (this.isDied)
            return;
        this.isDied = true;
        this.onDied && this.onDied();
    };
    Car.prototype.onCollisionEnter = function (other) {
        if (other.group == Collider_1.ColliderGroup.Ball) {
            this.die();
        }
        if (other.group == Collider_1.ColliderGroup.Wall) {
            this.touchWall = other.owner.x < 0 ? 1 : -1;
        }
    };
    Car.prototype.onCollisionStay = function (other) {
        if (other.group == Collider_1.ColliderGroup.Ball) {
            this.die();
        }
        if (other.group == Collider_1.ColliderGroup.Wall) {
            this.touchWall = other.owner.x < 0 ? 1 : -1;
        }
    };
    Car.prototype.onceBlink = function () {
        var _this = this;
        engine.Tween.get(this)
            .to({ alpha: 0 }, 1)
            .wait(100)
            .to({ alpha: 1 }, 1)
            .wait(100)
            .call(function () {
            _this.onceBlink();
        });
    };
    Car.prototype.revive = function () {
        var _this = this;
        this.invincible = true;
        this.isDied = false;
        engine.Tween.removeTweens(this);
        this.onceBlink();
        MTimer_1.default.setFrameTimer(MConst_1.MConst.ReviveInvincibleDuration * 60, function () {
            _this.invincible = false;
            _this.alpha = 1;
            engine.Tween.removeTweens(_this);
        });
    };
    Car.prototype.move = function (deltaX) {
        if (this.touchWall == 1 && deltaX <= 0) {
            return;
        }
        else if (this.touchWall == -1 && deltaX >= 0) {
            return;
        }
        var carCollidePaddingX = props_1.props.carCollidePaddingX;
        var _a = this.collider.rect, x = _a.x, width = _a.width;
        this.x = Math.max(-x, Math.min(750 - width - carCollidePaddingX, this.x + deltaX));
    };
    Car.prototype.onCollisionExit = function (other) {
        if (other.group == Collider_1.ColliderGroup.Wall) {
            this.touchWall = 0;
        }
    };
    Car.prototype.onUpdate = function () {
        if (DataMgr_1.DataMgr.game.pause)
            return;
        var score = DataMgr_1.DataMgr.game.bulletScore;
        if (score <= 20) {
            var max = MConst_1.MConst.BulletFireSpeed.max;
            var min = MConst_1.MConst.BulletFireSpeed.min;
            this.fireSpeed = min + (max - min) * (score / 20);
        }
        else {
            this.fireSpeed = MConst_1.MConst.BulletFireSpeed.max;
        }
        this.rowBulletNum = Math.ceil((utils_1.clamp(score, 15, 140) / 2) / 10);
        this.fireTimer += 1 * MTimer_1.default.dtFactor;
        if (this.fireTimer >= 60 / this.fireSpeed) {
            this.fire();
            this.fireTimer = 0;
        }
        if (this.fireParticleTimer % 3 == 0) {
            this.imgParticel.visible = !this.imgParticel.visible;
        }
        this.fireParticleTimer++;
    };
    return Car;
}(GameObject_1.default));
exports.default = Car;
